#ifdef STATISTICS
#include "Behavioural/include/Stat.h"

namespace morpheo {
namespace behavioural {

  Stat::Stat (std::string name_instance,
	      std::string name_component,
	      Parameters_Statistics * param):
    _name_instance         (name_instance),
    _name_component        (name_component),
    _nb_cycle_before_begin (static_cast<cycle_t>(param->_nb_cycle_before_begin)),
    _period                (static_cast<cycle_t>(param->_period_save)),
    _save_periodic         (_period>0)
  {
    _generate_file = true;

    _list_operand  = new std::map<std::string, var_t>;
    _list_expr     = new std::list<expr_t>;
    _list_stat     = new std::list<Stat *>;
    _list_counters = new std::list<counters_t *>;

    _cycle         = create_variable("cycle");
//  _cycle         = create_counter("cycle","","");
    *_cycle        = 0; // for the first period
  }

  Stat::Stat (std::string name_instance,
	      std::string name_component,
	      cycle_t nb_cycle_before_begin,
	      cycle_t period):
    _name_instance         (name_instance),
    _name_component        (name_component),
    _nb_cycle_before_begin (nb_cycle_before_begin),
    _period                (period),
    _save_periodic         (period>0)
  {
    _generate_file = true;

    _list_operand  = new std::map<std::string, var_t>;
    _list_expr     = new std::list<expr_t>;
    _list_stat     = new std::list<Stat *>;
    _list_counters = new std::list<counters_t *>;

    _cycle         = create_variable("cycle");
//  _cycle         = create_counter("cycle","","");
    *_cycle        = 0; // for the first period
  }

  Stat::~Stat (void)
  {
    if (_generate_file)
      generate_file();

    // parcourir la liste et desallouer les counters
    for (std::map<std::string, var_t>::iterator i=_list_operand->begin();
	 i!= _list_operand->end();
	 ++i)
      {
	delete i->second.counter;
      }
    delete _list_operand;

    // parcourir la liste et desallouer les arbres
    for (std::list<expr_t>::iterator i=_list_expr->begin();
	 i!= _list_expr->end();
	 ++i)
      {
	delete i->expression;
      }
    delete _list_expr;

    // parcourir la liste et desallouer les arbres
    for (std::list<counters_t*>::iterator i=_list_counters->begin();
	 i!= _list_counters->end();
	 ++i)
      {
	delete *i;
      }
    delete _list_counters;

    delete _list_stat;
  }
};
};
#endif
