#ifdef VHDL

/*
 * $Id: Vhdl_set_debug.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"
#include "Common/include/Tabulation.h"
#include <sstream>

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::set_debug"
  void Vhdl::set_debug (std::string     condition,
                        std::string     text,
                        vhdl_severity_t severity)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    std::string msg = "assert not ("+condition+") report \""+MSG_VHDL+" "+text+"\" severity "+toString(severity)+";";

    test_architecture();

    set_list(_architecture[_name_architecture]._list_debug, msg);

    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };
  
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
