#!/bin/bash

function usage()
{
    echo "${0} option";
    echo "  -h : print this message";
    echo "  -t : test rule";
    echo "  -m : modify all files";
    exit 1;
}

function modif_param ()
{
# example :

#    sed s/\<parameter\ name=\"commit_priority\"/\<parameter\ name=\"retire_ooo_scheme\"\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ value=\"0\"\ \\/\>\\\n\ \ \ \ \<parameter\ name=\"commit_priority\"/ ${1};
#    sed s/\<link\ name=\"link_read_bloc_and_functionnal_unit\"\ \ \ \ \ src=\"0.0\"/\<link\ name=\"link_read_bloc_with_load_store_unit\"\ \ \ \ \ src=\"0\"\ \ \ \ \ dest=\"0\"\ \ \ \\/\>\\\n\ \ \<link\ name=\"link_read_bloc_and_functionnal_unit\"\ \ \ \ \ src=\"0.0\"/ ${1};
#    sed s/\<link\ name=\"link_write_bloc_and_load_store_unit\"\ \ \ \ \ src=\"0.0\"/\<link\ name=\"link_write_bloc_with_load_store_unit\"\ \ \ \ src=\"0\"\ \ \ \ \ dest=\"0\"\ \ \ \\/\>\\\n\ \ \<link\ name=\"link_write_bloc_and_load_store_unit\"\ \ \ \ \ src=\"0.0\"/ ${1};
#    sed s/\<parameter\ name=\"nb_port_check\"/\<parameter\ name=\"nb_load_queue_bank\"\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ value=\"1\"\ \\/\>\\\n\ \ \ \ \<parameter\ name=\"nb_port_check\"/ ${1};
#    sed s/\<parameter\ name=\"nb_bypass_memory\"/\<parameter\ name=\"speculative_commit\"\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ value=\"1\"\ \\/\>\\\n\ \ \ \ \<parameter\ name=\"nb_bypass_memory\"/ ${1};


#    sed s/\<parameter\ name=\"nb_bypass_memory\"/\<predictor\ id=\"0\"\>\\\n\ \ \ \ \<parameter\ name=\"nb_bypass_memory\"/ ${1};
#    sed s/\<parameter\ name=\"nb_bypass_memory\"/\ \ \<parameter\ name=\"lsu_pht_nb_counter\"\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ value=\"64\"\\/\>\\\n\ \ \ \ \<parameter\ name=\"nb_bypass_memory\"/ ${1};
    sed s/\<parameter\ name=\"nb_bypass_memory\"/\<\\/predictor\>\\\n\ \ \ \ \<parameter\ name=\"nb_bypass_memory\"/ ${1};



#    <predictor id="0">                                      
#      <parameter name="dir_pht_size_counter"                value="2"  />
#      <parameter name="dir_pht_nb_counter"                  value="512"/>
#    </predictor>     


}

function modif_file ()
{
    echo ${1};

    modif_param ${1} > tmp;
    mv tmp ${1};
}

function modif_files ()
{
    for i in *.cfg; do 
        modif_file ${i};
    done 
}

function main ()
{
    set -- $(getopt :tmh "$@")
    for arg
    do	case "$arg" in
	    -t)	modif_param debug.cfg; break;;
	    -m)	modif_files;           break;;
            -h) usage   ${*}; break;;
	    --)	usage   ${*}; break;;
	esac
    done
}

main ${*};
