#!/bin/bash

declare distexe_env_is_subshell;
declare distexe_env_file="${HOME}/.distexe_env";

#-----[ distexe_env_usage ]---------------------------------
function distexe_env_usage()
{
    echo "${0} option";
    echo "  -h : print this message";
    echo "  -d : load default DISTEXE_HOSTS";
    echo "  -t : from DISTEXE_HOSTS, test hosts";
    echo "  -s : save DISTEXE_HOSTS in file ${distexe_env_file} (if -t, save after test host)";
    echo "  -l : load file ${distexe_env_file} and set DISTEXE_HOSTS";
    echo "";
    echo " 2 methode to set DISTEXE_HOSTS : ";
    echo "   * 1) \". $0\"";
    echo "   * 2) DISTEXE_HOSTS=\$($0);";

#    exit 1;
}

#-----[ distexe_env_default ]-------------------------------
function distexe_env_default ()
{
    export DISTEXE_HOSTS="";
    export DISTEXE_HOSTS="${DISTEXE_HOSTS} bip/4"      ; # serveur recherche
    export DISTEXE_HOSTS="${DISTEXE_HOSTS} bop/4"      ; # serveur recherche
    export DISTEXE_HOSTS="${DISTEXE_HOSTS} houla/8"    ; # serveur recherche
    export DISTEXE_HOSTS="${DISTEXE_HOSTS} hop/8"      ; # serveur recherche
    export DISTEXE_HOSTS="${DISTEXE_HOSTS} fox/2"      ; # serveur recherche
    export DISTEXE_HOSTS="${DISTEXE_HOSTS} trot/2"     ; # serveur recherche
   #export DISTEXE_HOSTS="${DISTEXE_HOSTS} polka/1"    ; # serveur recherche    - rserv  
   #export DISTEXE_HOSTS="${DISTEXE_HOSTS} debussy/1"  ; # serveur enseignement            
    export DISTEXE_HOSTS="${DISTEXE_HOSTS} do/2"       ; # serveur recherche               
    export DISTEXE_HOSTS="${DISTEXE_HOSTS} re/2"       ; # serveur recherche               
    export DISTEXE_HOSTS="${DISTEXE_HOSTS} mi/2"       ; # serveur recherche               
    export DISTEXE_HOSTS="${DISTEXE_HOSTS} fa/2"       ; # serveur recherche               
   #export DISTEXE_HOSTS="${DISTEXE_HOSTS} berlioz/1"  ; # serveur enseignement - g++ 3.4.6
    export DISTEXE_HOSTS="${DISTEXE_HOSTS} roll/1"     ; # serveur recherche               
   #export DISTEXE_HOSTS="${DISTEXE_HOSTS} rock/1"     ; # serveur recherche    - g++ 3.4.6
    export DISTEXE_HOSTS="${DISTEXE_HOSTS} lin/1"      ; # desktop
    export DISTEXE_HOSTS="${DISTEXE_HOSTS} eric/1"     ; # desktop
    export DISTEXE_HOSTS="${DISTEXE_HOSTS} amouri/1"   ; # desktop
   #export DISTEXE_HOSTS="${DISTEXE_HOSTS} cherry/1"   ; # desktop
    export DISTEXE_HOSTS="${DISTEXE_HOSTS} gamoudi/1"  ; # desktop
   #export DISTEXE_HOSTS="${DISTEXE_HOSTS} grunge/1"   ; # desktop
    export DISTEXE_HOSTS="${DISTEXE_HOSTS} mitra/1"    ; # desktop
   #export DISTEXE_HOSTS="${DISTEXE_HOSTS} pronky/1"   ; # desktop
   #export DISTEXE_HOSTS="${DISTEXE_HOSTS} babylone/1" ; # desktop  

    if test ${1} -eq 1; then
        echo "${DISTEXE_HOSTS}";
    fi;
}

#-----[ distexe_env_load ]----------------------------------
function distexe_env_load ()
{
    if test -f ${distexe_env_file}; then
        DISTEXE_HOSTS=$(cat ${distexe_env_file});
    fi;
}

#-----[ distexe_env_save ]----------------------------------
function distexe_env_save ()
{
    echo ${DISTEXE_HOSTS} > ${distexe_env_file};
}

#-----[ distexe_env_test ]----------------------------------
function distexe_env_test ()
{
    local hosts="${DISTEXE_HOSTS}";

    # re init DISTEXE_HOSTS

    export DISTEXE_HOSTS="";
    for line in ${hosts}; do
        host=$(echo ${line} | cut -d/ -f1);

        if test ${1} -eq 0; then
            echo -n " * station : ${host} ... ";
        fi;
        
        # ping host ...
        ping -w 1 ${host} &> /dev/null;

        if test "$?" -eq "0"; then
            # ... if ok, reinsert
            if test ${1} -eq 0; then
                echo "online";
            fi;
            export DISTEXE_HOSTS="${DISTEXE_HOSTS} ${line}";
        else
            if test ${1} -eq 0; then
                echo "offline";
            fi;
        fi;
    done;

    if test ${1} -eq 1; then
        echo "${DISTEXE_HOSTS}";
    fi;
}

#-----[ distexe_env ]---------------------------------------
function distexe_env ()
{
    if test "${0}" = "$(basename ${SHELL})"; then
        distexe_env_is_subshell=0;
    else
        distexe_env_is_subshell=1;
    fi;
    
    local exec_distexe_env_default=0;
    local exec_distexe_env_test=0;
    local exec_distexe_env_save=0;
    local exec_distexe_env_load=0;
    local exec_distexe_env_usage=0;
    local no_option=1;
    
    set -- $(getopt :sldth "$@")
    for arg
    do	case "$arg" in
            -d) exec_distexe_env_default=1; no_option=0; ;;
            -t)	exec_distexe_env_test=1;    no_option=0; ;;
            -s) exec_distexe_env_save=1;    no_option=0; ;;
            -l) exec_distexe_env_load=1;    no_option=0; ;;
            -h) exec_distexe_env_usage=1;   break; ;;
            --)	if test $no_option -eq 1; then
                    exec_distexe_env_usage=1;
                fi;
                break;;
        esac
    done


    if test $exec_distexe_env_usage -eq 1; then
        distexe_env_usage ${*};
        
        if test ${distexe_env_is_subshell} -eq 1; then
            exit 1;
        fi;
    else
        if test $exec_distexe_env_default -eq 1; then
            if test $exec_distexe_env_test    -eq 1; then
                distexe_env_default 0;
            else
                distexe_env_default ${distexe_env_is_subshell};
            fi;
        fi;
        if test $exec_distexe_env_load    -eq 1; then
            distexe_env_load;
        fi;
        if test $exec_distexe_env_test    -eq 1; then
            distexe_env_test ${distexe_env_is_subshell};
        fi;
        if test $exec_distexe_env_save   -eq 1; then
            distexe_env_save;
        fi;
    fi;
    
    unset distexe_env_file;
    unset distexe_env_is_subshell;
}

#-----[ Corps ]---------------------------------------------
distexe_env ${*};