/*
 * Test_032
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.or
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r0 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:
        /*
             A (r1)     B (r2)     - D (r3 wait)
                                       (r4)     
          1) 0x0f0f0f0f 0xff0000ff - 0xff0f0fff 
          */

        /**********/
        /* Test 1 */
        /**********/
	l.movhi r1,     hi(0x0f0f0f0f) /* RA */
	l.ori   r1, r1, lo(0x0f0f0f0f)
	l.movhi r2,     hi(0xff0000ff) /* RB */
	l.ori   r2, r2, lo(0xff0000ff)
	l.movhi r3,     hi(0xff0f0fff) /* RD wait */
	l.ori   r3, r3, lo(0xff0f0fff)
        
        l.or    r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /**********/
        /* End */
        /**********/

        l.j     _end_ok
        l.nop
