#ifndef morpheo_behavioural_generic_queue_Parameters_h
#define morpheo_behavioural_generic_queue_Parameters_h

/*
 * $Id: Parameters.h 137 2010-02-16 12:35:48Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include <math.h>

namespace morpheo {
namespace behavioural {
namespace generic {
namespace queue {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t _size_queue         ;
  public : uint32_t _size_data          ;
  public : uint32_t _nb_port_slot       ;
  public : bool     _have_port_ptr_write;
  public : bool     _have_port_ptr_read ;

  public : uint32_t _size_ptr           ;
  public : bool     _have_port_ptr      ;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t size_queue         ,
			uint32_t size_data          ,
                        uint32_t nb_port_slot       ,
                        bool     have_port_ptr_write,
                        bool     have_port_ptr_read );

//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string   print      (uint32_t depth);
  public : friend std::ostream& operator<< (std::ostream& output_stream,
					    morpheo::behavioural::generic::queue::Parameters & x);
  };

}; // end namespace queue
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
