#ifdef VHDL

/*
 * $Id: Vhdl_get_debug.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"
#include "Common/include/Tabulation.h"
#include <sstream>

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::get_debug"
  std::string Vhdl::get_debug (uint32_t depth)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    test_architecture();

    std::string _return = "";

    if (_architecture[_name_architecture]._list_debug.size()>0)
      {
//         if (_port_clock == "")
//           throw ERRORMORPHEO(FUNCTION,_("Clock port is not define.\n"));
        
        std::string tab0=morpheo::tab(depth);
        std::string tab1=morpheo::tab(depth+1);
        
        _return += "\n";
        _return += tab0+"debug: process\n";
        _return += tab0+"begin  -- process debug\n";
        _return += get_list(_architecture[_name_architecture]._list_debug,depth+1,"",true);
        _return += "\n";
        _return += tab1+"-- wait one period\n";
        _return += tab1+"wait for "+toString(VHDL_TIME_PERIOD)+" "+toString(VHDL_TIME_UNIT)+";\n";
        _return += tab0+"end process debug;\n";
      }

    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return _return;
  };
  
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
