#ifndef ENVIRONMENT_DATA_H
#define ENVIRONMENT_DATA_H

#include "Data_Parameters.h"
#include "Entity.h"

namespace environment {
namespace data {

  class Data
  {
  private  : std::string  name;
  private  : uint32_t     nb_seg;
  private  : Segment   ** segment;
  private  : Parameters * param;

  public   :  Data (std::string name, Parameters * param);
  public   : ~Data (void);

  public   : bool   init   (std::string section, const char * filename, const char ** list_section);
  public   : void   reset  (void);
  public   : bool   read   (uint32_t address, uint32_t size, char * & data_dest);
  public   : bool   write  (uint32_t address, uint32_t size, char * & data_src);
  public   : Entity entity (uint32_t address, uint32_t size);
  public   : Entity entity (std::string name);
  public   : friend std::ostream& operator<< (std::ostream& output, const Data & x);
  };

};
};
#endif
