#include "../include/Cache_Access.h"

namespace environment {

  Cache_Access ireq_type2cache_type (morpheo::behavioural::Ticache_type_t ireq_type, bool uncached)
  {
    cache::type_req_cache_t      type     ;
    cache::direction_req_cache_t direction;
    
    switch (ireq_type)
      {
      case ICACHE_TYPE_LOAD       : {direction=cache::READ ; type=cache::CACHED    ; break;}
      case ICACHE_TYPE_INVALIDATE : {direction=cache::NONE ; type=cache::INVALIDATE; break;}
      case ICACHE_TYPE_PREFETCH   : {direction=cache::NONE ; type=cache::PREFETCH  ; break;}
      case ICACHE_TYPE_LOCK       : {direction=cache::NONE ; type=cache::LOCK      ; break;}
      default : {std::cerr << "<ireq_type2cache_type> Unkown type (" << ireq_type << ")" << std::endl; exit(1);}
      }
    
    return Cache_Access (type,direction, 4); // instruction = 32 bits = 4 bytes
  }

};
