#ifndef morpheo_behavioural_configuration_XMLUtils_h
#define morpheo_behavioural_configuration_XMLUtils_h

/*
 * $Id: XMLUtils.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/FileXMLLight.h"
#include "Behavioural/include/XMLLightFunctors.h"
#include "Common/include/ErrorMorpheo.h"
#include "Common/include/Debug.h"
#include <string>
#include <map>

namespace morpheo {
namespace behavioural {
namespace configuration {
  
  typedef XMLUtils::IXMLLightASCII XML_t;
  typedef std::basic_string<char> attribute_t;
  typedef std::map<std::basic_string<char>, std::basic_string<char> > attributes_t;

  attribute_t getAttribute        (XML_t *             xml,
                                   attributes_t      & attributes,
                                   const attribute_t & name);
  
  void        testAttributesEmpty (XML_t * xml,
                                   attributes_t attributes);

  void        testNoAttribute     (XML_t * xml);
  void        testNodeName        (XML_t * xml, std::string name);
  void        testSingleton       (XML_t * xml, bool must_be_singleton);

}; // end namespace configuration
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
