#ifdef SYSTEMC
/*
 * $Id: Core_Glue_genMealy_branch_complete.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Core_Glue/include/Core_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace core_glue {


#undef  FUNCTION
#define FUNCTION "Core_Glue::genMealy_branch_complete"
  void Core_Glue::genMealy_branch_complete (void)
  {
    log_begin(Core_Glue,FUNCTION);
    log_function(Core_Glue,FUNCTION,_name.c_str());

    Tcontrol_t BRANCH_COMPLETE_FRONT_END_VAL  [_param->_nb_front_end ][_param->_max_front_end_nb_inst_branch_complete ];
    Tcontrol_t BRANCH_COMPLETE_OOO_ENGINE_ACK [_param->_nb_ooo_engine][_param->_max_ooo_engine_nb_inst_branch_complete];

    // init val/ack at 0
    for (uint32_t i=0; i<_param->_nb_front_end; ++i)
      for (uint32_t j=0; j<_param->_front_end_nb_inst_branch_complete[i]; ++j)
        BRANCH_COMPLETE_FRONT_END_VAL [i][j] = 0;
    for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_param->_ooo_engine_nb_inst_branch_complete[i]; ++j)
        BRANCH_COMPLETE_OOO_ENGINE_ACK [i][j] = 0;

    if (PORT_READ(in_NRESET))
      {
    for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_param->_ooo_engine_nb_inst_branch_complete[i]; ++j)
        {
          // Take the ooo_engine.num_front_end and translate in core.num_front_end
          Tcontext_t front_end_id  = (_param->_have_port_front_end_id)?PORT_READ(in_BRANCH_COMPLETE_OOO_ENGINE_FRONT_END_ID [i][j]):0;
          Tcontext_t num_front_end = _param->_translate_ooo_engine_num_front_end [i][front_end_id];

          // Warning : ooo_engine.nb_inst_branch_complete[i] = front_end.nb_inst_branch_complete[num_front_end]
//           log_printf(TRACE,Core_Glue,FUNCTION,"  * [%d][%d] front_end_id %d, num_front_end %d",i,j,front_end_id,num_front_end);

          BRANCH_COMPLETE_FRONT_END_VAL [num_front_end][j] = PORT_READ(in_BRANCH_COMPLETE_OOO_ENGINE_VAL [i][j]);
          BRANCH_COMPLETE_OOO_ENGINE_ACK [i][j] = PORT_READ(in_BRANCH_COMPLETE_FRONT_END_ACK [num_front_end][j]);
          
          if (_param->_have_port_context_id)
          PORT_WRITE(out_BRANCH_COMPLETE_FRONT_END_CONTEXT_ID [num_front_end][j],PORT_READ(in_BRANCH_COMPLETE_OOO_ENGINE_CONTEXT_ID [i][j]));
          if (_param->_have_port_depth)
          PORT_WRITE(out_BRANCH_COMPLETE_FRONT_END_DEPTH      [num_front_end][j],PORT_READ(in_BRANCH_COMPLETE_OOO_ENGINE_DEPTH      [i][j]));
          PORT_WRITE(out_BRANCH_COMPLETE_FRONT_END_ADDRESS    [num_front_end][j],PORT_READ(in_BRANCH_COMPLETE_OOO_ENGINE_ADDRESS    [i][j]));
          PORT_WRITE(out_BRANCH_COMPLETE_FRONT_END_NO_SEQUENCE[num_front_end][j],PORT_READ(in_BRANCH_COMPLETE_OOO_ENGINE_NO_SEQUENCE[i][j]));
          PORT_WRITE(out_BRANCH_COMPLETE_OOO_ENGINE_MISS_PREDICTION [i][j], PORT_READ(in_BRANCH_COMPLETE_FRONT_END_MISS_PREDICTION [num_front_end][j]));
        }
      }

    for (uint32_t i=0; i<_param->_nb_front_end; ++i)
      for (uint32_t j=0; j<_param->_front_end_nb_inst_branch_complete[i]; ++j)
        PORT_WRITE(out_BRANCH_COMPLETE_FRONT_END_VAL [i][j], BRANCH_COMPLETE_FRONT_END_VAL [i][j]);

    for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_param->_ooo_engine_nb_inst_branch_complete[i]; ++j)
        PORT_WRITE(out_BRANCH_COMPLETE_OOO_ENGINE_ACK [i][j], BRANCH_COMPLETE_OOO_ENGINE_ACK [i][j]);

    log_end(Core_Glue,FUNCTION);
  };

}; // end namespace core_glue
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
