/*
 * $Id: Instruction.cpp 137 2010-02-16 12:35:48Z rosiere $
 *
 * [ Description ]
 * 
 * instruction MAC_UNIT (l.mac, l.maci, l.macrc, l.msb) throw a context event. Also is sequential.
 * If your program need intensive mac_unit, you can change the implementation of this unit :
 *  1) "decod"            : inst->_event_type = EVENT_TYPE_NONE;
 *  2) "rename"           : add component as load_store_unit pointer management
 *  3) "functionnal_unit" : test type instruction, if type=MAC_UNIT, insert in queue, the localisation is the ptr give by rename stage. Retire in this queue in sequence (as the store queue).
 *
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod/Instruction/include/Instruction.h"
#include "Behavioural/include/Constants.h"
#include "Behavioural/include/Operation.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod {

#define EXTENDS(x,nb_bits) extend<Tgeneral_data_t>(param->_size_data, x,true ,nb_bits)
#define EXTENDZ(x,nb_bits) extend<Tgeneral_data_t>(param->_size_data, x,false,nb_bits)

  void instruction_decod               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_decod","  * instruction   : decod");

//     instruction_decod_type_0 (inst,param);

    uint32_t opcod = range<uint32_t>(inst->_instruction,31,26);

    log_printf(TRACE,Decod,"instruction_decod","    * opcod : %d (0x%x)",opcod,opcod);

    (* param->_function_decod[ 0][opcod]) (inst,param);
  }

//   void instruction_decod_type_0        (decod_instruction_t * inst, decod_param_t * param)
//   {
//     uint32_t opcod = range<uint32_t>(inst->_instruction,31,26);
//     (* param->_function_decod[ 0][opcod]) (inst,param);
//   }

  void instruction_decod_type_1        (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_decod_type_1","  * instruction   : decod type_1");
    
    uint32_t opcod = range<uint32_t>(inst->_instruction, 7, 0);

    log_printf(TRACE,Decod,"instruction_decod","    * opcod : %d (0x%x)",opcod,opcod);

    (* param->_function_decod[ 1][opcod]) (inst,param);
  }

  void instruction_decod_type_2        (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_decod_type_2","  * instruction   : decod type_2");

    uint32_t opcod = range<uint32_t>(inst->_instruction, 7, 0);

    log_printf(TRACE,Decod,"instruction_decod","    * opcod : %d (0x%x)",opcod,opcod);

    (* param->_function_decod[ 2][opcod]) (inst,param);
  }

  void instruction_decod_type_3        (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_decod_type_3","  * instruction   : decod type_3");

    uint32_t opcod = ((range<uint32_t>(inst->_instruction, 9, 8)<<4) |
		      (range<uint32_t>(inst->_instruction, 3, 0)));

    log_printf(TRACE,Decod,"instruction_decod","    * opcod : %d (0x%x)",opcod,opcod);

    (* param->_function_decod[ 3][opcod]) (inst,param);
  }

  void instruction_decod_type_4        (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_decod_type_4","  * instruction   : decod type_4");

    uint32_t opcod = range<uint32_t>(inst->_instruction,25,21);

    log_printf(TRACE,Decod,"instruction_decod","    * opcod : %d (0x%x)",opcod,opcod);

    (* param->_function_decod[ 4][opcod]) (inst,param);
  }

  void instruction_decod_type_5        (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_decod_type_5","  * instruction   : decod type_5");

    uint32_t opcod = range<uint32_t>(inst->_instruction,25,21);

    log_printf(TRACE,Decod,"instruction_decod","    * opcod : %d (0x%x)",opcod,opcod);

    (* param->_function_decod[ 5][opcod]) (inst,param);
  }

  void instruction_decod_type_6        (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_decod_type_6","  * instruction   : decod type_6");

    uint32_t opcod = range<uint32_t>(inst->_instruction, 7, 6);

    log_printf(TRACE,Decod,"instruction_decod","    * opcod : %d (0x%x)",opcod,opcod);

    (* param->_function_decod[ 6][opcod]) (inst,param);
  }

  void instruction_decod_type_7        (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_decod_type_7","  * instruction   : decod type_7");

    uint32_t opcod = range<uint32_t>(inst->_instruction, 3, 0);

    log_printf(TRACE,Decod,"instruction_decod","    * opcod : %d (0x%x)",opcod,opcod);

    (* param->_function_decod[ 7][opcod]) (inst,param);
  }

  void instruction_decod_type_8        (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_decod_type_8","  * instruction   : decod type_8");

    uint32_t opcod = range<uint32_t>(inst->_instruction,16,16);

    log_printf(TRACE,Decod,"instruction_decod","    * opcod : %d (0x%x)",opcod,opcod);

    (* param->_function_decod[ 8][opcod]) (inst,param);
  }

  void instruction_decod_type_9        (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_decod_type_9","  * instruction   : decod type_9");

    uint32_t opcod = range<uint32_t>(inst->_instruction,25,23);

    log_printf(TRACE,Decod,"instruction_decod","    * opcod : %d (0x%x)",opcod,opcod);

    (* param->_function_decod[ 9][opcod]) (inst,param);
  }

  void instruction_decod_type_10       (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_decod_type_10","  * instruction   : decod type_10");

    uint32_t opcod = range<uint32_t>(inst->_instruction,25,24);

    log_printf(TRACE,Decod,"instruction_decod","    * opcod : %d (0x%x)",opcod,opcod);

    (* param->_function_decod[10][opcod]) (inst,param);
  }

  void instruction_decod_type_11       (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_decod_type_11","  * instruction   : decod type_11");

    uint32_t opcod = range<uint32_t>(inst->_instruction, 7, 6);

    log_printf(TRACE,Decod,"instruction_decod","    * opcod : %d (0x%x)",opcod,opcod);

    (* param->_function_decod[11][opcod]) (inst,param);
  }

  void instruction_decod_type_12       (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_decod_type_12","  * instruction   : decod type_12");

    uint32_t opcod = range<uint32_t>(inst->_instruction, 7, 6);

    log_printf(TRACE,Decod,"instruction_decod","    * opcod : %d (0x%x)",opcod,opcod);

    (* param->_function_decod[12][opcod]) (inst,param);
  }

  void instruction_decod_type_13       (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_decod_type_13","  * instruction   : decod type_13");

    uint32_t opcod = range<uint32_t>(inst->_instruction, 7, 6);

    log_printf(TRACE,Decod,"instruction_decod","    * opcod : %d (0x%x)",opcod,opcod);

    (* param->_function_decod[13][opcod]) (inst,param);
  }

  void instruction_illegal             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_illegal","  * instruction   : illegal");

    msgWarning(_("Instruction \"%.8x\" at address \"%.8x\" is illegal.\n"),inst->_instruction,inst->_address);
	
    inst->_exception_use = EXCEPTION_USE_ILLEGAL_INSTRUCTION;
    inst->_exception     = EXCEPTION_ILLEGAL_INSTRUCTION;

    if (inst->_is_delay_slot)
      inst->_address_next       = inst->_address_previous;
    else
      inst->_address_next       = inst->_address;

    inst->_event_type         = EVENT_TYPE_EXCEPTION;
  }

  void instruction_l_custom            (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_custom","  * instruction   : custom");

    uint32_t opcod = range<uint32_t>(inst->_instruction,31,26);
    
    switch (opcod)
      {
      case OPCOD_L_CUST1 : 
	{
#ifdef STATISTICS
	  inst->_opcod     =                         INSTRUCTION_L_CUST1; 
#endif
	  inst->_type      = instruction_information(INSTRUCTION_L_CUST1)._type; 
	  inst->_operation = instruction_information(INSTRUCTION_L_CUST1)._operation;
	  break;
	}
      case OPCOD_L_CUST2 : 
	{
#ifdef STATISTICS
	  inst->_opcod     =                         INSTRUCTION_L_CUST2; 
#endif
	  inst->_type      = instruction_information(INSTRUCTION_L_CUST2)._type;
	  inst->_operation = instruction_information(INSTRUCTION_L_CUST2)._operation;
	  break;
	}
      case OPCOD_L_CUST3 : 
	{
#ifdef STATISTICS
	  inst->_opcod     =                         INSTRUCTION_L_CUST3; 
#endif
	  inst->_type      = instruction_information(INSTRUCTION_L_CUST3)._type; 
	  inst->_operation = instruction_information(INSTRUCTION_L_CUST3)._operation; 
	  break;
	}
      case OPCOD_L_CUST4 : 
	{
#ifdef STATISTICS
	  inst->_opcod     =                         INSTRUCTION_L_CUST4; 
#endif
	  inst->_type      = instruction_information(INSTRUCTION_L_CUST4)._type; 
	  inst->_operation = instruction_information(INSTRUCTION_L_CUST4)._operation; 
	  break;
	}
      case OPCOD_L_CUST5 : 
	{
#ifdef STATISTICS
	  inst->_opcod     =                         INSTRUCTION_L_CUST5; 
#endif
	  inst->_type      = instruction_information(INSTRUCTION_L_CUST5)._type; 
	  inst->_operation = instruction_information(INSTRUCTION_L_CUST5)._operation; 
	  break;
	}
      case OPCOD_L_CUST6 : 
	{
#ifdef STATISTICS
	  inst->_opcod     =                         INSTRUCTION_L_CUST6; 
#endif
	  inst->_type      = instruction_information(INSTRUCTION_L_CUST6)._type; 
	  inst->_operation = instruction_information(INSTRUCTION_L_CUST6)._operation; 
	  break;
	}
      case OPCOD_L_CUST7 : 
	{
#ifdef STATISTICS
	  inst->_opcod     =                         INSTRUCTION_L_CUST7; 
#endif
	  inst->_type      = instruction_information(INSTRUCTION_L_CUST7)._type; 
	  inst->_operation = instruction_information(INSTRUCTION_L_CUST7)._operation; 
	  break;
	}
      case OPCOD_L_CUST8 : 
	{
#ifdef STATISTICS
	  inst->_opcod     =                         INSTRUCTION_L_CUST8; 
#endif
	  inst->_type      = instruction_information(INSTRUCTION_L_CUST8)._type; 
	  inst->_operation = instruction_information(INSTRUCTION_L_CUST8)._operation; 
	  break;
	}

      default            : {throw ERRORMORPHEO("instruction_l_custom",_("Invalid Custom Opcod."));}
      }
    
    (* param->_function_custom[ 0][opcod]) (inst,param);

    instruction_custom(inst,param);
  }

  void instruction_lf_custom           (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_lf_custom","  * instruction   : custom");

    uint32_t opcod = range<uint32_t>(inst->_instruction, 7, 0);

    switch (opcod)
      {
//       case OPCOD_LF_CUST1_D : 
// 	{
// #ifdef STATISTICS
// 	  inst->_opcod     =                         INSTRUCTION_LF_CUST1_D; 
// #endif
// 	  inst->_type      = instruction_information(INSTRUCTION_LF_CUST1_D)._type; 
// 	  inst->_operation = instruction_information(INSTRUCTION_LF_CUST1_D)._operation;
// 	  break;
// 	}
//       case OPCOD_LF_CUST1_S : 
// 	{
// #ifdef STATISTICS
// 	  inst->_opcod     =                         INSTRUCTION_LF_CUST1_S; 
// #endif
// 	  inst->_type      = instruction_information(INSTRUCTION_LF_CUST1_S)._type; 
// 	  inst->_operation = instruction_information(INSTRUCTION_LF_CUST1_S)._operation;
// 	  break;
// 	}
      default               : {throw ERRORMORPHEO("instruction_lf_custom",_("Invalid Custom Opcod."));}
      }
    
    (* param->_function_custom[ 1][opcod]) (inst,param);

    instruction_custom(inst,param);
  }

  void instruction_lv_custom           (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_lv_custom","  * instruction   : custom");

    uint32_t opcod = range<uint32_t>(inst->_instruction, 7, 0);

    switch (opcod)
      {
//       case OPCOD_LV_CUST1 : 
// 	{
// #ifdef STATISTICS
// 	  inst->_opcod     =                         INSTRUCTION_LV_CUST1; 
// #endif
// 	  inst->_type      = instruction_information(INSTRUCTION_LV_CUST1)._type; 
// 	  inst->_operation = instruction_information(INSTRUCTION_LV_CUST1)._operation;
// 	  break;
// 	}
//       case OPCOD_LV_CUST2 : 
// 	{
// #ifdef STATISTICS
// 	  inst->_opcod     =                         INSTRUCTION_LV_CUST2; 
// #endif
// 	  inst->_type      = instruction_information(INSTRUCTION_LV_CUST2)._type; 
// 	  inst->_operation = instruction_information(INSTRUCTION_LV_CUST2)._operation;
// 	  break;
// 	}
//       case OPCOD_LV_CUST3 : 
// 	{
// #ifdef STATISTICS
// 	  inst->_opcod     =                         INSTRUCTION_LV_CUST3; 
// #endif
// 	  inst->_type      = instruction_information(INSTRUCTION_LV_CUST3)._type; 
// 	  inst->_operation = instruction_information(INSTRUCTION_LV_CUST3)._operation;
// 	  break;
// 	}
//       case OPCOD_LV_CUST4 : 
// 	{
// #ifdef STATISTICS
// 	  inst->_opcod     =                         INSTRUCTION_LV_CUST4; 
// #endif
// 	  inst->_type      = instruction_information(INSTRUCTION_LV_CUST4)._type; 
// 	  inst->_operation = instruction_information(INSTRUCTION_LV_CUST4)._operation;
// 	  break;
// 	}
      default             : {throw ERRORMORPHEO("instruction_lv_custom",_("Invalid Custom Opcod."));}
      }
    
    (* param->_function_custom[ 2][opcod]) (inst,param);

    instruction_custom(inst,param);
  }

  void instruction_custom              (decod_instruction_t * inst, decod_param_t * param)
  {
    // Test custom operation
    
    std::string msg = "";

    if (inst->_exception_use !=  EXCEPTION_USE_ILLEGAL_INSTRUCTION)
      {
	if (inst->_type != TYPE_CUSTOM)
	  msg += _("Invalid Type.\n");
	
	if ((inst->_operation != OPERATION_CUSTOM_L_1   ) and
	    (inst->_operation != OPERATION_CUSTOM_L_2   ) and
	    (inst->_operation != OPERATION_CUSTOM_L_3   ) and
	    (inst->_operation != OPERATION_CUSTOM_L_4   ) and
	    (inst->_operation != OPERATION_CUSTOM_L_5   ) and
	    (inst->_operation != OPERATION_CUSTOM_L_6   ) and
	    (inst->_operation != OPERATION_CUSTOM_L_7   ) and
	    (inst->_operation != OPERATION_CUSTOM_L_8   ) and
	    (inst->_operation != OPERATION_CUSTOM_LF_1_D) and
	    (inst->_operation != OPERATION_CUSTOM_LF_1_S) and
	    (inst->_operation != OPERATION_CUSTOM_LV_1  ) and
	    (inst->_operation != OPERATION_CUSTOM_LV_2  ) and
	    (inst->_operation != OPERATION_CUSTOM_LV_3  ) and
	    (inst->_operation != OPERATION_CUSTOM_LV_4  ))
	  msg += _("Invalid Operation.\n");
	
	if ((inst->_exception_use !=  EXCEPTION_USE_NONE               ) and 
	    (inst->_exception_use !=  EXCEPTION_USE_RANGE              ) and
	    (inst->_exception_use !=  EXCEPTION_USE_CUSTOM_0           ) and 
	    (inst->_exception_use !=  EXCEPTION_USE_CUSTOM_1           ) and 
	    (inst->_exception_use !=  EXCEPTION_USE_CUSTOM_2           ) and 
	    (inst->_exception_use !=  EXCEPTION_USE_CUSTOM_3           ) and 
	    (inst->_exception_use !=  EXCEPTION_USE_CUSTOM_4           ) and 
	    (inst->_exception_use !=  EXCEPTION_USE_CUSTOM_5           ) and 
	    (inst->_exception_use !=  EXCEPTION_USE_CUSTOM_6           ))
	  msg += _("Invalid Exception.\n");

	if ((inst->_event_type != EVENT_TYPE_NONE      ) and
	    (inst->_event_type != EVENT_TYPE_SPR_ACCESS))
	  msg += _("Invalid Event_type.\n");

	if (inst->_address_next != (inst->_address+1))
	  msg += _("Address must be in sequence.\n");

	if (msg != "")
	  throw ERRORMORPHEO("instruction_custom","Invalid decod : "+msg);
      }
  }
  
  // ORBIS
  void instruction_l_add               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_add","  * instruction   : l.add");
#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_ADD; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_ADD)._type     ; //TYPE_ALU;
    inst->_operation          = instruction_information(INSTRUCTION_L_ADD)._operation; //OPERATION_ALU_L_ADD;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_CY_OV;
    inst->_exception_use      = EXCEPTION_USE_RANGE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_addc              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_addc","  * instruction   : l.addc");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_ADDC; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_ADDC)._type     ; //TYPE_ALU;
    inst->_operation          = instruction_information(INSTRUCTION_L_ADDC)._operation; //OPERATION_ALU_L_ADD;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 1;
    inst->_num_reg_rc         = SPR_LOGIC_SR_CY_OV;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_CY_OV;
    inst->_exception_use      = EXCEPTION_USE_RANGE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_addi              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_addi","  * instruction   : l.addi");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_ADDI; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_ADDI)._type     ; //TYPE_ALU;
    inst->_operation          = instruction_information(INSTRUCTION_L_ADDI)._operation; //OPERATION_ALU_L_ADD;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_CY_OV;
    inst->_exception_use      = EXCEPTION_USE_RANGE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_addic             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_addic","  * instruction   : l.addic");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_ADDIC; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_ADDIC)._type     ; //TYPE_ALU;
    inst->_operation          = instruction_information(INSTRUCTION_L_ADDIC)._operation; //OPERATION_ALU_L_ADD;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 1;
    inst->_num_reg_rc         = SPR_LOGIC_SR_CY_OV;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_CY_OV;
    inst->_exception_use      = EXCEPTION_USE_RANGE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_and               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_and","  * instruction   : l.and");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_AND; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_AND)._type     ; //TYPE_ALU;
    inst->_operation          = instruction_information(INSTRUCTION_L_AND)._operation; //OPERATION_ALU_L_AND;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_andi              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_andi","  * instruction   : l.andi");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_ANDI; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_ANDI)._type     ; //TYPE_ALU;
    inst->_operation          = instruction_information(INSTRUCTION_L_ANDI)._operation; //OPERATION_ALU_L_AND;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDZ(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_bf	               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_bf","  * instruction   : l.bf");

    Tgeneral_data_t address_next = signed(param->_size_data,inst->_address+EXTENDS(inst->_instruction,26)// <<2
                                                   );

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_BF; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_BF)._type     ; //TYPE_BRANCH;
    inst->_operation          = instruction_information(INSTRUCTION_L_BF)._operation; //OPERATION_BRANCH_L_TEST_F;
    inst->_has_immediat       = 1;
    inst->_immediat           = address_next;
    inst->_read_ra            = 0;
    inst->_num_reg_ra         = 0; //unnecessary
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 1;
    inst->_num_reg_rc         = SPR_LOGIC_SR_F;
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
    inst->_branch_condition   = BRANCH_CONDITION_FLAG_SET;
//  inst->_branch_stack_write = 0;

    inst->_branch_direction   = range<Tgeneral_data_t   >(inst->_instruction,25,25);
    inst->_address_next       = address_next;
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_bnf               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_bnf","  * instruction   : l.bnf");

    Tgeneral_data_t address_next = signed(param->_size_data,inst->_address+EXTENDS(inst->_instruction,26)// <<2
                                                   );

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_BNF; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_BNF)._type     ; //TYPE_BRANCH;
    inst->_operation          = instruction_information(INSTRUCTION_L_BNF)._operation; //OPERATION_BRANCH_L_TEST_NF;
    inst->_has_immediat       = 1;
    inst->_immediat           = address_next;
    inst->_read_ra            = 0;
    inst->_num_reg_ra         = 0; //unnecessary
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 1;
    inst->_num_reg_rc         = SPR_LOGIC_SR_F;
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
    inst->_branch_condition   = BRANCH_CONDITION_FLAG_UNSET;
//  inst->_branch_stack_write = 0;
    inst->_branch_direction   = range<Tgeneral_data_t   >(inst->_instruction,25,25);
    inst->_address_next       = address_next;
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_cmov              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_cmov","  * instruction   : l.cmov");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_CMOV; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_CMOV)._type     ; //TYPE_MOVE;
    inst->_operation          = instruction_information(INSTRUCTION_L_CMOV)._operation; //OPERATION_MOVE_L_CMOV;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 1;
    inst->_num_reg_rc         = SPR_LOGIC_SR_F;
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_csync             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_csync","  * instruction   : l.csync");

    if (range<Tinstruction_t>(inst->_instruction,23) != 0)
      {
	instruction_illegal (inst, param);
      }
    else
      {
#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_CSYNC; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_CSYNC)._type     ; //TYPE_SPECIAL;
    inst->_operation          = instruction_information(INSTRUCTION_L_CSYNC)._operation; //OPERATION_SPECIAL_L_CSYNC;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 0;
    inst->_num_reg_ra         = 0; //unnecessary
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4 // don't change
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_CSYNC;
      }
  }

//   void instruction_l_cust1             (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_l_cust2             (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_l_cust3             (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_l_cust4             (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_l_cust5             (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_l_cust6             (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_l_cust7             (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_l_cust8             (decod_instruction_t * inst, decod_param_t * param)

  void instruction_l_div               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_div","  * instruction   : l.div");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_DIV; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_DIV)._type     ; //TYPE_DIV;
    inst->_operation          = instruction_information(INSTRUCTION_L_DIV)._operation; //OPERATION_DIV_L_DIV;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_CY_OV;
    inst->_exception_use      = EXCEPTION_USE_RANGE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_divu              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_divu","  * instruction   : l.divu");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_DIVU; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_DIVU)._type     ; //TYPE_DIV;
    inst->_operation          = instruction_information(INSTRUCTION_L_DIVU)._operation; //OPERATION_DIV_L_DIVU;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_CY_OV;
    inst->_exception_use      = EXCEPTION_USE_RANGE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_extbs             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_extbs","  * instruction   : l.extbs");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_EXTBS; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_EXTBS)._type     ; //TYPE_EXTEND;
    inst->_operation          = instruction_information(INSTRUCTION_L_EXTBS)._operation; //OPERATION_EXTEND_L_EXTEND_S;
    inst->_has_immediat       = 1;
    inst->_immediat           = 8;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_extbz             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_extbz","  * instruction   : l.extbz");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_EXTBZ;
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_EXTBZ)._type     ; //TYPE_EXTEND;
    inst->_operation          = instruction_information(INSTRUCTION_L_EXTBZ)._operation; //OPERATION_EXTEND_L_EXTEND_Z;
    inst->_has_immediat       = 1;
    inst->_immediat           = 8;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_exths             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_exths","  * instruction   : l.exths");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_EXTHS; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_EXTHS)._type     ; //TYPE_EXTEND;
    inst->_operation          = instruction_information(INSTRUCTION_L_EXTHS)._operation; //OPERATION_EXTEND_L_EXTEND_S;
    inst->_has_immediat       = 1;
    inst->_immediat           = 16;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_exthz             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_exthz","  * instruction   : l.exthz");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_EXTHZ;
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_EXTHZ)._type     ; //TYPE_EXTEND;
    inst->_operation          = instruction_information(INSTRUCTION_L_EXTHZ)._operation; //OPERATION_EXTEND_L_EXTEND_Z;
    inst->_has_immediat       = 1;
    inst->_immediat           = 16;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_extws             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_extws","  * instruction   : l.extws");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_EXTWS; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_EXTWS)._type     ; //TYPE_EXTEND;
    inst->_operation          = instruction_information(INSTRUCTION_L_EXTWS)._operation; //OPERATION_EXTEND_L_EXTEND_S;
    inst->_has_immediat       = 1;
    inst->_immediat           = 32;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_extwz             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_extwz","  * instruction   : l.extwz");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_EXTWZ; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_EXTWZ)._type     ; //TYPE_EXTEND;
    inst->_operation          = instruction_information(INSTRUCTION_L_EXTWZ)._operation; //OPERATION_EXTEND_L_EXTEND_Z;
    inst->_has_immediat       = 1;
    inst->_immediat           = 32;
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_ff1               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_ff1","  * instruction   : l.ff1");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_FF1; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_FF1)._type     ; //TYPE_FIND;
    inst->_operation          = instruction_information(INSTRUCTION_L_FF1)._operation; //OPERATION_FIND_L_FF1;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_fl1               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_fl1","  * instruction   : l.fl1");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_FL1; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_FL1)._type     ; //TYPE_FIND;
    inst->_operation          = instruction_information(INSTRUCTION_L_FL1)._operation; //OPERATION_FIND_L_FL1;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_j                 (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_j","  * instruction   : l.j");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_J; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_J)._type     ; //TYPE_BRANCH;
    inst->_operation          = instruction_information(INSTRUCTION_L_J)._operation; //OPERATION_BRANCH_NONE;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 0;
    inst->_num_reg_ra         = 0; //unnecessary
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
    inst->_branch_condition   = BRANCH_CONDITION_NONE_WITHOUT_WRITE_STACK;
//  inst->_branch_stack_write = 0;
    inst->_branch_direction   = 1;
    inst->_address_next       = signed(param->_size_data,inst->_address+EXTENDS(inst->_instruction,26)// <<2
                                                               );
    inst->_no_execute         = 1;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_jal               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_jal","  * instruction   : l.jal");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_JAL; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_JAL)._type     ; //TYPE_BRANCH;
    inst->_operation          = instruction_information(INSTRUCTION_L_JAL)._operation; //OPERATION_BRANCH_L_JALR;
    inst->_has_immediat       = 1;
    inst->_immediat           = inst->_address_next+1;
    inst->_read_ra            = 0;
    inst->_num_reg_ra         = 0; //unnecessary
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = 9; // Link register
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
    inst->_branch_condition   = BRANCH_CONDITION_NONE_WITH_WRITE_STACK; // Always jump
//  inst->_branch_stack_write = 1;
    inst->_branch_direction   = 1;
    inst->_address_next       = signed(param->_size_data,inst->_address+EXTENDS(inst->_instruction,26)// <<2
                                                );
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_jalr              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_jalr","  * instruction   : l.jalr");

    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);

    if (inst->_num_reg_rb == 9)
      {
	instruction_illegal (inst, param);
      }
    else
      {
#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_JALR; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_JALR)._type     ; //TYPE_BRANCH;
    inst->_operation          = instruction_information(INSTRUCTION_L_JALR)._operation; //OPERATION_BRANCH_L_JALR;
    inst->_has_immediat       = 1;
    inst->_immediat           = inst->_address_next+1;
    inst->_read_ra            = 0;
    inst->_num_reg_ra         = 0; //unnecessary
    inst->_read_rb            = 1;
//  inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = 9; // Link register
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = (inst->_num_reg_rb == 9)?BRANCH_CONDITION_READ_STACK:BRANCH_CONDITION_READ_REGISTER;
    inst->_branch_condition   = BRANCH_CONDITION_READ_REGISTER_WITH_WRITE_STACK;
//  inst->_branch_stack_write = 1;
    inst->_branch_direction   = 1;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
      }
  }

  void instruction_l_jr                (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_jr","  * instruction   : l.jr");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_JR; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_JR)._type     ; //TYPE_BRANCH;
    inst->_operation          = instruction_information(INSTRUCTION_L_JR)._operation; //OPERATION_BRANCH_L_JALR;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 0;
    inst->_num_reg_ra         = 0; //unnecessary
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
    inst->_branch_condition   = (inst->_num_reg_rb == 9)?BRANCH_CONDITION_READ_STACK:BRANCH_CONDITION_READ_REGISTER_WITHOUT_WRITE_STACK;
//  inst->_branch_stack_write = 0;
    inst->_branch_direction   = 1;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_lbs               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_lbs","  * instruction   : l.lbs");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_LBS; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_LBS)._type     ; //TYPE_MEMORY;
    inst->_operation          = instruction_information(INSTRUCTION_L_LBS)._operation; //OPERATION_MEMORY_LOAD_8_S;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITHOUT_ALIGNMENT;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_lbz               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_lbz","  * instruction   : l.lbz");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_LBZ; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_LBZ)._type     ; //TYPE_MEMORY;
    inst->_operation          = instruction_information(INSTRUCTION_L_LBZ)._operation; //OPERATION_MEMORY_LOAD_8_Z;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITHOUT_ALIGNMENT;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }
  
  void instruction_l_ld	               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_ld","  * instruction   : l.ld");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_LD; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_LD)._type     ; //TYPE_MEMORY;
    inst->_operation          = instruction_information(INSTRUCTION_L_LD)._operation; //OPERATION_MEMORY_LOAD_64_S;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITH_ALIGNMENT;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }
  
  void instruction_l_lhs               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_lhs","  * instruction   : l.lhs");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_LHS; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_LHS)._type     ; //TYPE_MEMORY;
    inst->_operation          = instruction_information(INSTRUCTION_L_LHS)._operation; //OPERATION_MEMORY_LOAD_16_S;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITH_ALIGNMENT;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }
  
  void instruction_l_lhz               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_lhz","  * instruction   : l.lhz");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_LHZ; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_LHZ)._type     ; //TYPE_MEMORY;
    inst->_operation          = instruction_information(INSTRUCTION_L_LHZ)._operation; //OPERATION_MEMORY_LOAD_16_Z;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITH_ALIGNMENT;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }
  
  void instruction_l_lws               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_lws","  * instruction   : l.lws");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_LWS; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_LWS)._type     ; //TYPE_MEMORY;
    inst->_operation          = instruction_information(INSTRUCTION_L_LWS)._operation; //OPERATION_MEMORY_LOAD_32_S;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITH_ALIGNMENT;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_lwz               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_lwz","  * instruction   : l.lwz");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_LWZ; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_LWZ)._type     ; //TYPE_MEMORY;
    inst->_operation          = instruction_information(INSTRUCTION_L_LWZ)._operation; //OPERATION_MEMORY_LOAD_32_Z;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITH_ALIGNMENT;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_mac               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_mac","  * instruction   : l.mac");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_MAC; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_MAC)._type     ; //TYPE_SPECIAL;
    inst->_operation          = instruction_information(INSTRUCTION_L_MAC)._operation; //OPERATION_SPECIAL_L_MAC;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4 // don't change
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_SPR_ACCESS;
  }

  void instruction_l_maci              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_maci","  * instruction   : l.maci");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_MACI; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_MACI)._type     ; //TYPE_SPECIAL;
    inst->_operation          = instruction_information(INSTRUCTION_L_MACI)._operation; //OPERATION_SPECIAL_L_MAC;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(((range<Tgeneral_data_t   >(inst->_instruction,25,21)<<11)|
					 (range<Tgeneral_data_t   >(inst->_instruction,10, 0))),16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4 // don't change
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_SPR_ACCESS;
  }

  void instruction_l_macrc             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_macrc","  * instruction   : l.macrc");

    if (range<uint32_t>(inst->_instruction,15, 0) != 0)
      {
	instruction_illegal (inst, param);
      }
    else
      {
#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_MACRC; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_MACRC)._type     ; //TYPE_SPECIAL;
    inst->_operation          = instruction_information(INSTRUCTION_L_MACRC)._operation; //OPERATION_SPECIAL_L_MACRC;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 0;
    inst->_num_reg_ra         = 0; //unnecessary
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4 // don't change
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_SPR_ACCESS;
      }
  }

  void instruction_l_mfspr             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_mfspr","  * instruction   : l.mfspr");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_MFSPR; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_MFSPR)._type     ; //TYPE_SPECIAL;
    inst->_operation          = instruction_information(INSTRUCTION_L_MFSPR)._operation; //OPERATION_SPECIAL_L_MFSPR;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDZ(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4 // don't change
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_SPR_ACCESS;
  }

  void instruction_l_movhi             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_movhi","  * instruction   : l.movhi");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_MOVHI; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_MOVHI)._type     ; //TYPE_MOVE;
    inst->_operation          = instruction_information(INSTRUCTION_L_MOVHI)._operation; //OPERATION_MOVE_L_MOVHI;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDZ(inst->_instruction,16);
    inst->_read_ra            = 0;
    inst->_num_reg_ra         = 0; //unnecessary
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_msb               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_msb","  * instruction   : l.msb");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_MSB; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_MSB)._type     ; //TYPE_SPECIAL;
    inst->_operation          = instruction_information(INSTRUCTION_L_MSB)._operation; //OPERATION_SPECIAL_L_MSB;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4 // don't change
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_SPR_ACCESS;
  }

  void instruction_l_msync             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_msync","  * instruction   : l.msync");

    if (range<uint32_t>(inst->_instruction,22, 0) != 0)
      {
	instruction_illegal (inst, param);
      }
    else
      {
#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_MSYNC; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_MSYNC)._type     ; //TYPE_SPECIAL;
    inst->_operation          = instruction_information(INSTRUCTION_L_MSYNC)._operation; //OPERATION_SPECIAL_L_MSYNC;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 0;
    inst->_num_reg_ra         = 0; //unnecessary
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4 // don't change
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_MSYNC;
      }
  }

  void instruction_l_mtspr             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_mtspr","  * instruction   : l.mtspr");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_MTSPR; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_MTSPR)._type     ; //TYPE_SPECIAL;
    inst->_operation          = instruction_information(INSTRUCTION_L_MTSPR)._operation; //OPERATION_SPECIAL_L_MTSPR;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDZ(((range<Tgeneral_data_t   >(inst->_instruction,25,21)<<11)|
					 (range<Tgeneral_data_t   >(inst->_instruction,10, 0))),16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4 // don't change
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_SPR_ACCESS;
  }
    
  void instruction_l_mul               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_mul","  * instruction   : l.mul");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_MUL; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_MUL)._type     ; //TYPE_MUL;
    inst->_operation          = instruction_information(INSTRUCTION_L_MUL)._operation; //OPERATION_MUL_L_MUL;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_CY_OV;
    inst->_exception_use      = EXCEPTION_USE_RANGE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_muli              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_muli","  * instruction   : l.muli");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_MULI; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_MULI)._type     ; //TYPE_MUL;
    inst->_operation          = instruction_information(INSTRUCTION_L_MULI)._operation; //OPERATION_MUL_L_MUL;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_CY_OV;
    inst->_exception_use      = EXCEPTION_USE_RANGE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_mulu              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_mulu","  * instruction   : l.mulu");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_MULU; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_MULU)._type     ; //TYPE_MUL;
    inst->_operation          = instruction_information(INSTRUCTION_L_MULU)._operation; //OPERATION_MUL_L_MULU;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_CY_OV;
    inst->_exception_use      = EXCEPTION_USE_RANGE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_nop               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_nop","  * instruction   : l.nop");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_NOP; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_NOP)._type     ; //TYPE_SPECIAL;
    inst->_operation          = instruction_information(INSTRUCTION_L_NOP)._operation; //OPERATION_SPECIAL_L_NOP;
//  inst->_has_immediat       = 1;
//  inst->_immediat           = EXTENDZ(inst->_instruction,16);
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 0;
    inst->_num_reg_ra         = 0; //unnecessary
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 1;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_or                (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_or","  * instruction   : l.or");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_OR; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_OR)._type     ; //TYPE_ALU;
    inst->_operation          = instruction_information(INSTRUCTION_L_OR)._operation; //OPERATION_ALU_L_OR;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_ori               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_ori","  * instruction   : l.ori");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_ORI; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_ORI)._type     ; //TYPE_ALU;
    inst->_operation          = instruction_information(INSTRUCTION_L_ORI)._operation; //OPERATION_ALU_L_OR;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDZ(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_psync             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_psync","  * instruction   : l.psync");

    if (range<uint32_t>(inst->_instruction,22, 0) != 0)
      {
	instruction_illegal (inst, param);
      }
    else
      {
#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_PSYNC; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_PSYNC)._type     ; //TYPE_SPECIAL;
    inst->_operation          = instruction_information(INSTRUCTION_L_PSYNC)._operation; //OPERATION_SPECIAL_L_PSYNC;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 0;
    inst->_num_reg_ra         = 0; //unnecessary
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4 // don't change
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_PSYNC;
      }
  }

  void instruction_l_rfe               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_rfe","  * instruction   : l.rfe");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_RFE; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_RFE)._type     ; //TYPE_SPECIAL;
    inst->_operation          = instruction_information(INSTRUCTION_L_RFE)._operation; //OPERATION_SPECIAL_L_RFE;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 0;
    inst->_num_reg_ra         = 0; //unnecessary
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4 // don't change
    inst->_no_execute         = 1;
    inst->_event_type         = EVENT_TYPE_NONE; // can't anticip this instruction : must read EPCR in rename stage
  }

  void instruction_l_ror               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_ror","  * instruction   : l.ror");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_ROR; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_ROR)._type     ; //TYPE_SHIFT;
    inst->_operation          = instruction_information(INSTRUCTION_L_ROR)._operation; //OPERATION_SHIFT_L_ROR;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_rori              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_rori","  * instruction   : l.rori");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_RORI; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_RORI)._type     ; //TYPE_SHIFT;
    inst->_operation          = instruction_information(INSTRUCTION_L_RORI)._operation; //OPERATION_SHIFT_L_ROR;
    inst->_has_immediat       = 1;
    inst->_immediat           = range<Tgeneral_data_t   >(inst->_instruction, 5, 0);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sb	               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sb","  * instruction   : l.sb");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SB; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SB)._type     ; //TYPE_MEMORY;
    inst->_operation          = instruction_information(INSTRUCTION_L_SB)._operation; //OPERATION_MEMORY_STORE_8;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(((range<Tgeneral_data_t   >(inst->_instruction,25,21)<<11)|
					 (range<Tgeneral_data_t   >(inst->_instruction,10, 0))),16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITHOUT_ALIGNMENT;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sd	               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sb","  * instruction   : l.sb");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SD; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SD)._type     ; //TYPE_MEMORY;
    inst->_operation          = instruction_information(INSTRUCTION_L_SD)._operation; //OPERATION_MEMORY_STORE_64;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(((range<Tgeneral_data_t   >(inst->_instruction,25,21)<<11)|
					 (range<Tgeneral_data_t   >(inst->_instruction,10, 0))),16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1; 
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITH_ALIGNMENT;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfeq              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfeq","  * instruction   : l.sfeq");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SFEQ; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SFEQ)._type     ; //TYPE_TEST;
    inst->_operation          = instruction_information(INSTRUCTION_L_SFEQ)._operation; //OPERATION_TEST_L_SFEQ;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfeqi             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfeqi","  * instruction   : l.sfeqi");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SFEQI; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SFEQI)._type     ; //TYPE_TEST;
    inst->_operation          = instruction_information(INSTRUCTION_L_SFEQI)._operation; //OPERATION_TEST_L_SFEQ;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfges             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfges","  * instruction   : l.sfges");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SFGES; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SFGES)._type     ; //TYPE_TEST;
    inst->_operation          = instruction_information(INSTRUCTION_L_SFGES)._operation; //OPERATION_TEST_L_SFGES;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfgesi            (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfgesi","  * instruction   : l.sfgesi");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SFGESI; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SFGESI)._type     ; //TYPE_TEST;
    inst->_operation          = instruction_information(INSTRUCTION_L_SFGESI)._operation; //OPERATION_TEST_L_SFGES;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfgeu             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfgeu","  * instruction   : l.sfgeu");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SFGEU; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SFGEU)._type     ; //TYPE_TEST;
    inst->_operation          = instruction_information(INSTRUCTION_L_SFGEU)._operation; //OPERATION_TEST_L_SFGEU;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfgeui            (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfgeui","  * instruction   : l.sfgeui");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SFGEUI; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SFGEUI)._type     ; //TYPE_TEST;
    inst->_operation          = instruction_information(INSTRUCTION_L_SFGEUI)._operation; //OPERATION_TEST_L_SFGEU;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfgts             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfgts","  * instruction   : l.sfgts");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SFGTS; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SFGTS)._type     ; //TYPE_TEST;
    inst->_operation          = instruction_information(INSTRUCTION_L_SFGTS)._operation; //OPERATION_TEST_L_SFGTS;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfgtsi            (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfgtsi","  * instruction   : l.sfgtsi");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SFGTSI; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SFGTSI)._type     ; //TYPE_TEST;
    inst->_operation          = instruction_information(INSTRUCTION_L_SFGTSI)._operation; //OPERATION_TEST_L_SFGTS;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfgtu             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfgtu","  * instruction   : l.sfgtu");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SFGTU; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SFGTU)._type     ; //TYPE_TEST;
    inst->_operation          = instruction_information(INSTRUCTION_L_SFGTU)._operation; //OPERATION_TEST_L_SFGTU;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfgtui            (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfgtui","  * instruction   : l.sfgtui");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SFGTUI; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SFGTUI)._type     ; //TYPE_TEST;
    inst->_operation          = instruction_information(INSTRUCTION_L_SFGTUI)._operation; //OPERATION_TEST_L_SFGTU;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfles             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfles","  * instruction   : l.sfles");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SFLES; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SFLES)._type     ; //TYPE_TEST;
    inst->_operation          = instruction_information(INSTRUCTION_L_SFLES)._operation; //OPERATION_TEST_L_SFLES;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sflesi            (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sflesi","  * instruction   : l.sflesi");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SFLESI; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SFLESI)._type     ; //TYPE_TEST;
    inst->_operation          = instruction_information(INSTRUCTION_L_SFLESI)._operation; //OPERATION_TEST_L_SFLES;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfleu             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfleu","  * instruction   : l.sfleu");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SFLEU; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SFLEU)._type     ; //TYPE_TEST;
    inst->_operation          = instruction_information(INSTRUCTION_L_SFLEU)._operation; //OPERATION_TEST_L_SFLEU;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfleui            (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfleui","  * instruction   : l.sfleui");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SFLEUI; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SFLEUI)._type     ; //TYPE_TEST;
    inst->_operation          = instruction_information(INSTRUCTION_L_SFLEUI)._operation; //OPERATION_TEST_L_SFLEU;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sflts             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sflts","  * instruction   : l.sflts");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SFLTS; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SFLTS)._type     ; //TYPE_TEST;
    inst->_operation          = instruction_information(INSTRUCTION_L_SFLTS)._operation; //OPERATION_TEST_L_SFLTS;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfltsi            (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfltsi","  * instruction   : l.sfltsi");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SFLTSI; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SFLTSI)._type     ; //TYPE_TEST;
    inst->_operation          = instruction_information(INSTRUCTION_L_SFLTSI)._operation; //OPERATION_TEST_L_SFLTS;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfltu             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfltu","  * instruction   : l.sfltu");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SFLTU; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SFLTU)._type     ; //TYPE_TEST;
    inst->_operation          = instruction_information(INSTRUCTION_L_SFLTU)._operation; //OPERATION_TEST_L_SFLTU;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfltui            (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfltui","  * instruction   : l.sfltui");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SFLTUI; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SFLTUI)._type     ; //TYPE_TEST;
    inst->_operation          = instruction_information(INSTRUCTION_L_SFLTUI)._operation; //OPERATION_TEST_L_SFLTU;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfne              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfne","  * instruction   : l.sfne");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SFNE; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SFNE)._type     ; //TYPE_TEST;
    inst->_operation          = instruction_information(INSTRUCTION_L_SFNE)._operation; //OPERATION_TEST_L_SFNE;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sfnei             (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sfnei","  * instruction   : l.sfnei");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SFNEI; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SFNEI)._type     ; //TYPE_TEST;
    inst->_operation          = instruction_information(INSTRUCTION_L_SFNEI)._operation; //OPERATION_TEST_L_SFNE;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_F;
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sh	               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sh","  * instruction   : l.sh");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SH; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SH)._type     ; //TYPE_MEMORY;
    inst->_operation          = instruction_information(INSTRUCTION_L_SH)._operation; //OPERATION_MEMORY_STORE_16;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(((range<Tgeneral_data_t   >(inst->_instruction,25,21)<<11)|
					 (range<Tgeneral_data_t   >(inst->_instruction,10, 0))),16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1; 
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITH_ALIGNMENT;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sll               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sll","  * instruction   : l.sll");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SLL; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SLL)._type     ; //TYPE_SHIFT;
    inst->_operation          = instruction_information(INSTRUCTION_L_SLL)._operation; //OPERATION_SHIFT_L_SLL;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_slli              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_slli","  * instruction   : l.slli");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SLLI; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SLLI)._type     ; //TYPE_SHIFT;
    inst->_operation          = instruction_information(INSTRUCTION_L_SLLI)._operation; //OPERATION_SHIFT_L_SLL;
    inst->_has_immediat       = 1;
    inst->_immediat           = range<Tgeneral_data_t   >(inst->_instruction, 5, 0);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sra               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sra","  * instruction   : l.sra");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SRA; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SRA)._type     ; //TYPE_SHIFT;
    inst->_operation          = instruction_information(INSTRUCTION_L_SRA)._operation; //OPERATION_SHIFT_L_SRA;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_srai              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_srai","  * instruction   : l.srai");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SRAI; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SRAI)._type     ; //TYPE_SHIFT;
    inst->_operation          = instruction_information(INSTRUCTION_L_SRAI)._operation; //OPERATION_SHIFT_L_SRA;
    inst->_has_immediat       = 1;
    inst->_immediat           = range<Tgeneral_data_t   >(inst->_instruction, 5, 0);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_srl               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_srl","  * instruction   : l.srl");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SRL; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SRL)._type     ; //TYPE_SHIFT;
    inst->_operation          = instruction_information(INSTRUCTION_L_SRL)._operation; //OPERATION_SHIFT_L_SRL;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_srli              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_srli","  * instruction   : l.srli");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SRLI; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SRLI)._type     ; //TYPE_SHIFT;
    inst->_operation          = instruction_information(INSTRUCTION_L_SRLI)._operation; //OPERATION_SHIFT_L_SRL;
    inst->_has_immediat       = 1;
    inst->_immediat           = range<Tgeneral_data_t   >(inst->_instruction, 5, 0);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }
    
  void instruction_l_sub               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sub","  * instruction   : l.sub");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SUB; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SUB)._type     ; //TYPE_ALU;
    inst->_operation          = instruction_information(INSTRUCTION_L_SUB)._operation; //OPERATION_ALU_L_SUB;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 1;
    inst->_num_reg_re         = SPR_LOGIC_SR_CY_OV;
    inst->_exception_use      = EXCEPTION_USE_RANGE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sw	               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sw","  * instruction   : l.sw");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SW; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SW)._type     ; //TYPE_MEMORY;
    inst->_operation          = instruction_information(INSTRUCTION_L_SW)._operation; //OPERATION_MEMORY_STORE_32;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(((range<Tgeneral_data_t   >(inst->_instruction,25,21)<<11)|
					 (range<Tgeneral_data_t   >(inst->_instruction,10, 0))),16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1; 
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_MEMORY_WITH_ALIGNMENT;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_sys               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_sys","  * instruction   : l.sys");

    if (range<uint32_t>(inst->_instruction,22,16) != 0)
      {
	instruction_illegal (inst, param);
      }
    else
      {
#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_SYS; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_SYS)._type     ; //TYPE_SPECIAL;
    inst->_operation          = instruction_information(INSTRUCTION_L_SYS)._operation; //OPERATION_SPECIAL_L_SYS;
//  inst->_has_immediat       = 1;
//  inst->_immediat           = EXTENDZ(inst->_instruction,16);
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 0;
    inst->_num_reg_ra         = 0; //unnecessary
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_SYSCALL;
    inst->_exception          = EXCEPTION_SYSCALL;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;

//     if (inst->_is_delay_slot)
//       inst->_address_next       = inst->_address_previous;
//     else
//       inst->_address_next       = inst->_address;


//  inst->_address_next       = ; // already define : PC+4 // don't change
    inst->_no_execute         = 1;
    inst->_event_type         = EVENT_TYPE_EXCEPTION;
      }
  }

  void instruction_l_trap              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_trap","  * instruction   : l.trap");

    if (range<uint32_t>(inst->_instruction,22,16) != 0)
      {
	instruction_illegal (inst, param);
      }
    else
      {
#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_TRAP; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_TRAP)._type     ; //TYPE_SPECIAL;
    inst->_operation          = instruction_information(INSTRUCTION_L_TRAP)._operation; //OPERATION_SPECIAL_L_TRAP;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDZ(inst->_instruction,16);
    inst->_read_ra            = 0;
    inst->_num_reg_ra         = 0; //unnecessary
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0; // read all SR
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 0;
    inst->_num_reg_rd         = 0; //unnecessary
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_TRAP;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 1;
    inst->_event_type         = EVENT_TYPE_NONE;
      }
  }

  void instruction_l_xor               (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_xor","  * instruction   : l.xor");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_XOR; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_XOR)._type     ; //TYPE_ALU;
    inst->_operation          = instruction_information(INSTRUCTION_L_XOR)._operation; //OPERATION_ALU_L_XOR;
    inst->_has_immediat       = 0;
    inst->_immediat           = 0; // unnecessary
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 1;
    inst->_num_reg_rb         = range<Tgeneral_address_t>(inst->_instruction,15,11);
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

  void instruction_l_xori              (decod_instruction_t * inst, decod_param_t * param)
  {
    log_printf(TRACE,Decod,"instruction_l_xori","  * instruction   : l.xori");

#ifdef STATISTICS
    inst->_opcod              =                         INSTRUCTION_L_XORI; 
#endif
    inst->_type               = instruction_information(INSTRUCTION_L_XORI)._type     ; //TYPE_ALU;
    inst->_operation          = instruction_information(INSTRUCTION_L_XORI)._operation; //OPERATION_ALU_L_XOR;
    inst->_has_immediat       = 1;
    inst->_immediat           = EXTENDS(inst->_instruction,16);
    inst->_read_ra            = 1;
    inst->_num_reg_ra         = range<Tgeneral_address_t>(inst->_instruction,20,16);
    inst->_read_rb            = 0;
    inst->_num_reg_rb         = 0; //unnecessary
    inst->_read_rc            = 0;
    inst->_num_reg_rc         = 0; //unnecessary
    inst->_write_rd           = 1;
    inst->_num_reg_rd         = range<Tgeneral_address_t>(inst->_instruction,25,21);
    inst->_write_re           = 0;
    inst->_num_reg_re         = 0; //unnecessary
    inst->_exception_use      = EXCEPTION_USE_NONE;
    inst->_exception          = EXCEPTION_DECOD_NONE;
//  inst->_branch_condition   = ;
//  inst->_branch_stack_write = ;
//  inst->_branch_direction   = ;
//  inst->_address_next       = ; // already define : PC+4
    inst->_no_execute         = 0;
    inst->_event_type         = EVENT_TYPE_NONE;
  }

//   // ORFPX
//   void instruction_lf_add_d            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_add_s            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_cust1_d          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_cust1_s          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_div_d            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_div_s            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_ftoi_d           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_ftoi_s           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_itof_d           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_itof_s           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_madd_d           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_madd_s           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_mul_d            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_mul_s            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_rem_d            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_rem_s            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sfeq_d           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sfeq_s           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sfge_d           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sfge_s           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sfgt_d           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sfgt_s           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sfle_d           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sfle_s           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sflt_d           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sflt_s           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sfne_d           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sfne_s           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sub_d            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lf_sub_s            (decod_instruction_t * inst, decod_param_t * param)

//   // ORVDX
//   void instruction_lv_add_b            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_add_h            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_adds_b           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_adds_h           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_addu_b           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_addu_h           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_addus_b          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_addus_h          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_eq_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_eq_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_ge_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_ge_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_gt_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_gt_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_le_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_le_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_lt_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_lt_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_ne_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_all_ne_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_and              (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_eq_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_eq_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_ge_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_ge_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_gt_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_gt_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_le_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_le_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_lt_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_lt_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_ne_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_any_ne_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_avg_b            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_avg_h            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_eq_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_eq_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_ge_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_ge_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_gt_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_gt_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_le_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_le_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_lt_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_lt_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_ne_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cmp_ne_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cust1            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cust2            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cust3            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_cust4            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_madds_h          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_max_b            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_max_h            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_merge_b          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_merge_h          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_min_b            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_min_h            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_msubs_h          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_muls_h           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_nand             (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_nor              (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_or               (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_pack_b           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_pack_h           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_packs_b          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_packs_h          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_packus_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_packus_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_perm_n           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_rl_b             (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_rl_h             (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_sll              (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_sll_b            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_sll_h            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_sra_b            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_sra_h            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_srl              (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_srl_b            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_srl_h            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_sub_b            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_sub_h            (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_subs_b           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_subs_h           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_subu_b           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_subu_h           (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_subus_b          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_subus_h          (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_unpack_b         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_unpack_h         (decod_instruction_t * inst, decod_param_t * param)
//   void instruction_lv_xor              (decod_instruction_t * inst, decod_param_t * param)

}; // end namespace decod
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
