/*
 * $Id: Parameters_print.cpp 107 2009-02-10 23:03:25Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod {


#undef  FUNCTION
#define FUNCTION "Decod::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_printf(FUNC,Decod,FUNCTION,"Begin");

    XML xml ("decod");

    xml.balise_open("decod");
    xml.singleton_begin("nb_context                   "); xml.attribut("value",toString(_nb_context                   )); xml.singleton_end();
    xml.singleton_begin("nb_inst_decod                "); xml.attribut("value",toString(_nb_inst_decod                )); xml.singleton_end();
//  xml.singleton_begin("size_branch_update_prediction"); xml.attribut("value",toString(_size_branch_update_prediction)); xml.singleton_end();
    xml.singleton_begin("nb_context_select            "); xml.attribut("value",toString(_nb_context_select            )); xml.singleton_end();
    xml.singleton_begin("size_general_data            "); xml.attribut("value",toString(_size_general_data            )); xml.singleton_end();
    xml.singleton_begin("priority                     "); xml.attribut("value",toString(_priority                     )); xml.singleton_end();
    xml.singleton_begin("load_balancing               "); xml.attribut("value",toString(_load_balancing               )); xml.singleton_end();

    for (uint32_t i=0;i<_nb_context; i++)
      {
        xml. balise_open_begin("component");
        xml.  attribut("type","context");
        xml.  attribut("id"  ,toString(i));
        xml. balise_open_end();
        xml.  singleton_begin("nb_inst_fetch                "); xml.attribut("value",toString(_nb_inst_fetch                [i])); xml.singleton_end();
        xml.  singleton_begin("nb_branch_speculated         "); xml.attribut("value",toString(_nb_branch_speculated         [i])); xml.singleton_end();
        xml. balise_close();
      }

    xml.balise_close();

    log_printf(FUNC,Decod,FUNCTION,"End");
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Decod::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod::Parameters & x)
  {
    log_printf(FUNC,Decod,FUNCTION,"Begin");

    output_stream << x.print(0);
    
    log_printf(FUNC,Decod,FUNCTION,"End");

    return output_stream;
  };

}; // end namespace decod
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
