/*
 * $Id: Branch_Target_Buffer_Glue_allocation.cpp 128 2009-06-26 08:43:23Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Glue/include/Branch_Target_Buffer_Glue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace branch_target_buffer {
namespace branch_target_buffer_glue {



#undef  FUNCTION
#define FUNCTION "Branch_Target_Buffer_Glue::allocation"
  void Branch_Target_Buffer_Glue::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Branch_Target_Buffer_Glue,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Branch_Target_Buffer_Glue"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 _("Generalist interface")
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      {
	ALLOC1_INTERFACE_BEGIN("predict", IN, WEST, _("predict"),_param->_nb_inst_predict);

	ALLOC1_SIGNAL_IN ( in_PREDICT_VAL           , "val"           ,Tcontrol_t         , 1);
	ALLOC1_SIGNAL_OUT(out_PREDICT_ACK           , "ack"           ,Tcontrol_t         , 1);
	ALLOC1_SIGNAL_OUT(out_PREDICT_HIT           , "hit"           ,Tcontrol_t         , 1);
	ALLOC1_SIGNAL_OUT(out_PREDICT_ADDRESS_SRC   , "address_src"   ,Tgeneral_data_t    , _param->_size_instruction_address);
	ALLOC1_SIGNAL_OUT(out_PREDICT_ADDRESS_DEST  , "address_dest"  ,Tgeneral_data_t    , _param->_size_instruction_address);
	ALLOC1_SIGNAL_OUT(out_PREDICT_CONDITION     , "condition"     ,Tbranch_condition_t, _param->_size_branch_condition);
	ALLOC1_SIGNAL_OUT(out_PREDICT_LAST_TAKE     , "last_take"     ,Tcontrol_t         , 1);
	ALLOC1_SIGNAL_OUT(out_PREDICT_IS_ACCURATE   , "is_accurate"   ,Tcontrol_t         , 1);
	ALLOC1_SIGNAL_OUT(out_PREDICT_REGISTER_VAL  , "register_val"  ,Tcontrol_t         , 1);
	ALLOC1_SIGNAL_IN ( in_PREDICT_REGISTER_ACK  , "register_ack"  ,Tcontrol_t         , 1);
	if (_param->_have_port_victim)
	  {
	ALLOC1_SIGNAL_IN ( in_PREDICT_SORT_VAL      , "sort_val"      ,Tcontrol_t         ,1);
	ALLOC1_SIGNAL_IN ( in_PREDICT_SORT_INDEX    , "sort_index"    ,Tptr_t             ,_param->_size_victim);

	ALLOC1_SIGNAL_OUT(out_PREDICT_VICTIM_VAL    , "victim_val"    ,Tcontrol_t         , 1);
	ALLOC1_SIGNAL_IN ( in_PREDICT_VICTIM_ACK    , "victim_ack"    ,Tcontrol_t         , 1);
	ALLOC1_SIGNAL_OUT(out_PREDICT_VICTIM_HIT    , "victim_hit"    ,Tcontrol_t         , 1);
	ALLOC1_SIGNAL_OUT(out_PREDICT_VICTIM_ADDRESS, "victim_address",Tgeneral_data_t    , _param->_size_victim_address);
	ALLOC1_SIGNAL_OUT(out_PREDICT_VICTIM_INDEX  , "victim_index"  ,Tptr_t             , _param->_size_victim);
	ALLOC1_SIGNAL_IN ( in_PREDICT_VICTIM_VICTIM , "victim_victim" ,Tptr_t             , _param->_size_victim);
	  }

	ALLOC1_INTERFACE_END(_param->_nb_inst_predict);
      }
      {
	ALLOC2_INTERFACE_BEGIN("predict", IN, WEST, _("predict"),_param->_nb_inst_predict, _param->_associativity);

	ALLOC2_SIGNAL_IN ( in_PREDICT_REGISTER_HIT         ,"register_hit"         ,Tcontrol_t         ,1);
	ALLOC2_SIGNAL_IN ( in_PREDICT_REGISTER_ADDRESS_SRC ,"register_address_src" ,Tgeneral_data_t    ,_param->_size_instruction_address);
	ALLOC2_SIGNAL_IN ( in_PREDICT_REGISTER_ADDRESS_DEST,"register_address_dest",Tgeneral_data_t    ,_param->_size_instruction_address);
	ALLOC2_SIGNAL_IN ( in_PREDICT_REGISTER_CONDITION   ,"register_condition"   ,Tbranch_condition_t,_param->_size_branch_condition);
	ALLOC2_SIGNAL_IN ( in_PREDICT_REGISTER_LAST_TAKE   ,"register_last_take"   ,Tcontrol_t         ,1);
	ALLOC2_SIGNAL_IN ( in_PREDICT_REGISTER_IS_ACCURATE ,"register_is_accurate" ,Tcontrol_t         ,1);

	ALLOC2_INTERFACE_END(_param->_nb_inst_predict, _param->_associativity);
      }
    }

    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("decod", IN, WEST, _("decod"),_param->_nb_inst_decod);

      ALLOC1_SIGNAL_IN ( in_DECOD_VAL           ,"val"           ,Tcontrol_t     ,1);
      ALLOC1_SIGNAL_OUT(out_DECOD_ACK           ,"ack"           ,Tcontrol_t     ,1);
      if (not _param->_is_full_associative)
      ALLOC1_SIGNAL_IN ( in_DECOD_ADDRESS_SRC   ,"address_src"   ,Tgeneral_data_t,_param->_size_instruction_address);

      ALLOC1_SIGNAL_OUT(out_DECOD_REGISTER_VAL  ,"register_val"  ,Tcontrol_t     ,1);
      ALLOC1_SIGNAL_IN ( in_DECOD_REGISTER_ACK  ,"register_ack"  ,Tcontrol_t     ,1);

      if (_param->_have_port_victim)
	{
      ALLOC1_SIGNAL_OUT(out_DECOD_VICTIM_VAL    ,"victim_val"    ,Tcontrol_t     ,1);
      ALLOC1_SIGNAL_IN ( in_DECOD_VICTIM_ACK    ,"victim_ack"    ,Tcontrol_t     ,1);
      ALLOC1_SIGNAL_OUT(out_DECOD_VICTIM_ADDRESS,"victim_address",Tgeneral_data_t,_param->_size_victim_address);
	}

      ALLOC1_INTERFACE_END(_param->_nb_inst_decod);
    }

    // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("update", IN, WEST, _("update"),_param->_nb_inst_update);

      ALLOC1_SIGNAL_IN ( in_UPDATE_VAL           ,"val"           ,Tcontrol_t     ,1);
      ALLOC1_SIGNAL_OUT(out_UPDATE_ACK           ,"ack"           ,Tcontrol_t     ,1);
      if (not _param->_is_full_associative)
      ALLOC1_SIGNAL_IN ( in_UPDATE_ADDRESS_SRC   ,"address_src"   ,Tgeneral_data_t,_param->_size_instruction_address);

      ALLOC1_SIGNAL_OUT(out_UPDATE_REGISTER_VAL  ,"register_val"  ,Tcontrol_t     ,1);
      ALLOC1_SIGNAL_IN ( in_UPDATE_REGISTER_ACK  ,"register_ack"  ,Tcontrol_t     ,1);

      if (_param->_have_port_victim)
	{
      ALLOC1_SIGNAL_OUT(out_UPDATE_VICTIM_VAL    ,"victim_val"    ,Tcontrol_t     ,1);
      ALLOC1_SIGNAL_IN ( in_UPDATE_VICTIM_ACK    ,"victim_ack"    ,Tcontrol_t     ,1);
      ALLOC1_SIGNAL_OUT(out_UPDATE_VICTIM_ADDRESS,"victim_address",Tgeneral_data_t,_param->_size_victim_address);
	}

      ALLOC1_INTERFACE_END(_param->_nb_inst_update);
    }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif

    log_printf(FUNC,Branch_Target_Buffer_Glue,FUNCTION,"End");
  };

}; // end namespace branch_target_buffer_glue
}; // end namespace branch_target_buffer
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
