/*
 * $Id: main.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Direction_Glue/SelfTest/include/test.h"

#define NB_PARAMS 5

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * predictor_scheme (Tpredictor_t)\n"));
  err (_(" * nb_inst_predict  (uint32_t    )\n"));
  err (_(" * nb_inst_update   (uint32_t    )\n"));
  err (_(" * size_address     (uint32_t    )\n"));
  err (_(" * size_history     (uint32_t    )\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc != static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];
  Tpredictor_t _predictor_scheme = fromString<Tpredictor_t>(argv[x++]);
  uint32_t     _nb_inst_predict  = fromString<uint32_t    >(argv[x++]);
  uint32_t     _nb_inst_update   = fromString<uint32_t    >(argv[x++]);
  uint32_t     _size_address     = fromString<uint32_t    >(argv[x++]);
  uint32_t     _size_history     = fromString<uint32_t    >(argv[x++]);
  
  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::direction_glue::Parameters * param = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::direction_glue::Parameters
	(_predictor_scheme,
	 _nb_inst_predict ,
	 _nb_inst_update  ,
	 _size_address    ,
	 _size_history    ,
         true // is_toplevel
         );
      
      msg(_("%s"),param->print(1).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  catch (...)
    {
      err (_("<%s> : This test must generate a error.\n"),name.c_str());
      _return = EXIT_FAILURE;
    }

  return (_return);
}
