/*
 * $Id: Meta_Predictor.cpp 138 2010-05-12 17:34:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/include/Meta_Predictor.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace meta_predictor {


#undef  FUNCTION
#define FUNCTION "Meta_Predictor::Meta_Predictor"
  Meta_Predictor::Meta_Predictor 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Meta_Predictor,FUNCTION);

    usage_environment(_usage);

    log_printf(INFO,Meta_Predictor,FUNCTION,_("<%s> : Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Meta_Predictor,FUNCTION,_("<%s> : Allocation of statistics"),_name.c_str());

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Meta_Predictor,FUNCTION,_("<%s> : Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#if defined(SYSTEMC) and (defined(STATISTICS) or defined(VHDL_TESTBENCH))
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Meta_Predictor,FUNCTION,_("<%s> : Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
      }
#endif
    log_end(Meta_Predictor,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Meta_Predictor::~Meta_Predictor"
  Meta_Predictor::~Meta_Predictor (void)
  {
    log_begin(Meta_Predictor,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Meta_Predictor,FUNCTION,_("<%s> : Deallocation"),_name.c_str());
    deallocation ();

    log_end(Meta_Predictor,FUNCTION);
  };

}; // end namespace meta_predictor
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
