/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Prediction_unit_Glue/SelfTest/include/test.h"

#define NB_PARAMS 6

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * nb_context                             (uint32_t)\n"));
  err (_(" * nb_decod_unit                          (uint32_t)\n"));
//   err (_(" * nb_ooo_engine                          (uint32_t)\n"));
  err (_(" * size_address                           (uint32_t)\n"));
  err (_(" * nb_instruction         [nb_context]    (uint32_t)\n"));
  err (_(" * size_depth             [nb_context]    (uint32_t)\n"));
  err (_(" * nb_inst_decod          [nb_decod_unit] (uint32_t)\n"));
//   err (_(" * nb_inst_update         [nb_ooo_engine] (uint32_t)\n"));
  err (_(" * nb_inst_branch_predict                 (uint32_t)\n"));
  err (_(" * nb_inst_branch_decod                   (uint32_t)\n"));
  err (_(" * nb_inst_branch_update                  (uint32_t)\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc < static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];

  uint32_t   _nb_context      = fromString<uint32_t>(argv[x++]);
  uint32_t   _nb_decod_unit   = fromString<uint32_t>(argv[x++]);
//   uint32_t   _nb_ooo_engine   = fromString<uint32_t>(argv[x++]);
  uint32_t   _size_address    = fromString<uint32_t>(argv[x++]);
  
  if (argc != static_cast<int>(2+NB_PARAMS+2*_nb_context+_nb_decod_unit// +_nb_ooo_engine
			       ))
    usage (argc, argv);

  uint32_t * _nb_instruction  = new uint32_t [_nb_context];
  for (uint32_t i=0; i<_nb_context; i++)
    _nb_instruction [i] = fromString<uint32_t>(argv[x++]);
  uint32_t * _size_depth      = new uint32_t [_nb_context];
  for (uint32_t i=0; i<_nb_context; i++)
    _size_depth     [i] = fromString<uint32_t>(argv[x++]);
  uint32_t * _nb_inst_decod   = new uint32_t [_nb_decod_unit];
  for (uint32_t i=0; i<_nb_decod_unit; i++)
    _nb_inst_decod  [i] = fromString<uint32_t>(argv[x++]);
//   uint32_t * _nb_inst_update  = new uint32_t [_nb_ooo_engine];
//   for (uint32_t i=0; i<_nb_ooo_engine; i++)
//     _nb_inst_update [i] = fromString<uint32_t>(argv[x++]);
  uint32_t   _nb_inst_branch_predict = fromString<uint32_t>(argv[x++]);
  uint32_t   _nb_inst_branch_update  = fromString<uint32_t>(argv[x++]);
  uint32_t   _nb_inst_branch_decod   = fromString<uint32_t>(argv[x++]);

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::prediction_unit_glue::Parameters * param = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::prediction_unit_glue::Parameters
	(_nb_context            ,
	 _nb_decod_unit         ,
// 	 _nb_ooo_engine         ,
	 _size_address          ,
	 _nb_instruction        ,
	 _size_depth            ,
	 _nb_inst_decod         ,
// 	 _nb_inst_update        ,
	 _nb_inst_branch_predict,
	 _nb_inst_branch_decod  ,
	 _nb_inst_branch_update ,
         true // is_toplevel
         );
      
      msg(_("%s"),param->print(1).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  catch (...)
    {
      err (_("<%s> : This test must generate a error.\n"),name.c_str());
      _return = EXIT_FAILURE;
    }

  delete [] _nb_instruction;
  delete [] _size_depth    ;
  delete [] _nb_inst_decod ;
//   delete [] _nb_inst_update;

  return (_return);
}
