#ifndef morpheo_behavioural_core_multi_front_end_front_end_Front_end_h
#define morpheo_behavioural_core_multi_front_end_front_end_Front_end_h

/*
 * $Id: Front_end.h 139 2010-07-30 14:47:27Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include "Behavioural/Core/Multi_Front_end/Front_end/include/Parameters.h"
#include "Behavioural/include/Types.h"

#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/include/Ifetch_unit.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/include/Prediction_unit.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/include/Decod_unit.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Context_State/include/Context_State.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Front_end_Glue/include/Front_end_Glue.h"

#include <iostream>

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_front_end {
namespace front_end {


  class Front_end 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                       *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t )            *  in_NRESET       ;

    // ~~~~~[ Interface "icache_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t           ) ** out_ICACHE_REQ_VAL                   ;//[nb_context]
  public    : SC_IN (Tcontrol_t           ) **  in_ICACHE_REQ_ACK                   ;//[nb_context]
//public    : SC_OUT(Tcontext_t           ) ** out_ICACHE_REQ_THREAD_ID             ;//[nb_context]
  public    : SC_OUT(Tpacket_t            ) ** out_ICACHE_REQ_PACKET_ID             ;//[nb_context]
  public    : SC_OUT(Ticache_instruction_t) ** out_ICACHE_REQ_ADDRESS               ;//[nb_context]
  public    : SC_OUT(Ticache_type_t       ) ** out_ICACHE_REQ_TYPE                  ;//[nb_context]

    // ~~~~~[ Interface "icache_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t           ) **  in_ICACHE_RSP_VAL                   ;//[nb_context]
  public    : SC_OUT(Tcontrol_t           ) ** out_ICACHE_RSP_ACK                   ;//[nb_context]
//public    : SC_IN (Tcontext_t           ) **  in_ICACHE_RSP_THREAD_ID             ;//[nb_context]
  public    : SC_IN (Tpacket_t            ) **  in_ICACHE_RSP_PACKET_ID             ;//[nb_context]
  public    : SC_IN (Ticache_instruction_t)***  in_ICACHE_RSP_INSTRUCTION           ;//[nb_context][nb_inst_fetch]
  public    : SC_IN (Ticache_error_t      ) **  in_ICACHE_RSP_ERROR                 ;//[nb_context]

    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t           ) ** out_DECOD_VAL                       ;//[sum_inst_decod]
  public    : SC_IN (Tcontrol_t           ) **  in_DECOD_ACK                       ;//[sum_inst_decod]
  public    : SC_OUT(Tcontext_t           ) ** out_DECOD_CONTEXT_ID                ;//[sum_inst_decod]
  public    : SC_OUT(Tdepth_t             ) ** out_DECOD_DEPTH                     ;//[sum_inst_decod]
#ifdef STATISTICS
  public    : SC_OUT(uint32_t             ) ** out_DECOD_INSTRUCTION               ;//[sum_inst_decod]
#endif
  public    : SC_OUT(Ttype_t              ) ** out_DECOD_TYPE                      ;//[sum_inst_decod]
  public    : SC_OUT(Toperation_t         ) ** out_DECOD_OPERATION                 ;//[sum_inst_decod]
  public    : SC_OUT(Tcontrol_t           ) ** out_DECOD_NO_EXECUTE                ;//[sum_inst_decod]
//public    : SC_OUT(Tcontrol_t           ) ** out_DECOD_HAVE_EVENT                ;//[sum_inst_decod]
  public    : SC_OUT(Tcontrol_t           ) ** out_DECOD_LAST_EVENT                ;//[sum_inst_decod]
  public    : SC_OUT(Tcontrol_t           ) ** out_DECOD_IS_DELAY_SLOT             ;//[sum_inst_decod]
  public    : SC_OUT(Tcontrol_t           ) ** out_DECOD_SAVE_RAT                  ;//[sum_inst_decod]
#ifdef DEBUG
  public    : SC_OUT(Tgeneral_data_t      ) ** out_DECOD_ADDRESS                   ;//[sum_inst_decod]
#endif
  public    : SC_OUT(Tgeneral_data_t      ) ** out_DECOD_ADDRESS_NEXT              ;//[sum_inst_decod]
  public    : SC_OUT(Tcontrol_t           ) ** out_DECOD_HAS_IMMEDIAT              ;//[sum_inst_decod]
  public    : SC_OUT(Tgeneral_data_t      ) ** out_DECOD_IMMEDIAT                  ;//[sum_inst_decod]
  public    : SC_OUT(Tcontrol_t           ) ** out_DECOD_READ_RA                   ;//[sum_inst_decod]
  public    : SC_OUT(Tgeneral_address_t   ) ** out_DECOD_NUM_REG_RA                ;//[sum_inst_decod]
  public    : SC_OUT(Tcontrol_t           ) ** out_DECOD_READ_RB                   ;//[sum_inst_decod]
  public    : SC_OUT(Tgeneral_address_t   ) ** out_DECOD_NUM_REG_RB                ;//[sum_inst_decod]
  public    : SC_OUT(Tcontrol_t           ) ** out_DECOD_READ_RC                   ;//[sum_inst_decod]
  public    : SC_OUT(Tspecial_address_t   ) ** out_DECOD_NUM_REG_RC                ;//[sum_inst_decod]
  public    : SC_OUT(Tcontrol_t           ) ** out_DECOD_WRITE_RD                  ;//[sum_inst_decod]
  public    : SC_OUT(Tgeneral_address_t   ) ** out_DECOD_NUM_REG_RD                ;//[sum_inst_decod]
  public    : SC_OUT(Tcontrol_t           ) ** out_DECOD_WRITE_RE                  ;//[sum_inst_decod]
  public    : SC_OUT(Tspecial_address_t   ) ** out_DECOD_NUM_REG_RE                ;//[sum_inst_decod]
  public    : SC_OUT(Texception_t         ) ** out_DECOD_EXCEPTION_USE             ;//[sum_inst_decod]
  public    : SC_OUT(Texception_t         ) ** out_DECOD_EXCEPTION                 ;//[sum_inst_decod]

    // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~         
  public    : SC_IN (Tcontrol_t           ) **  in_BRANCH_COMPLETE_VAL              ;//[nb_inst_branch_complete]
  public    : SC_OUT(Tcontrol_t           ) ** out_BRANCH_COMPLETE_ACK              ;//[nb_inst_branch_complete]
  public    : SC_IN (Tcontext_t           ) **  in_BRANCH_COMPLETE_CONTEXT_ID       ;//[nb_inst_branch_complete]
  public    : SC_IN (Tdepth_t             ) **  in_BRANCH_COMPLETE_DEPTH            ;//[nb_inst_branch_complete]
  public    : SC_IN (Taddress_t           ) **  in_BRANCH_COMPLETE_ADDRESS          ;//[nb_inst_branch_complete]
  public    : SC_IN (Tcontrol_t           ) **  in_BRANCH_COMPLETE_NO_SEQUENCE      ;//[nb_inst_branch_complete]
  public    : SC_OUT(Tcontrol_t           ) ** out_BRANCH_COMPLETE_MISS_PREDICTION  ;//[nb_inst_branch_complete]
                                                                                   
    // ~~~~~[ Interface : "commit_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t           )  *  in_COMMIT_EVENT_VAL                 ;
  public    : SC_OUT(Tcontrol_t           )  * out_COMMIT_EVENT_ACK                 ;
  public    : SC_IN (Tcontext_t           )  *  in_COMMIT_EVENT_CONTEXT_ID          ;
  public    : SC_IN (Tdepth_t             )  *  in_COMMIT_EVENT_DEPTH               ;
  public    : SC_IN (Tevent_type_t        )  *  in_COMMIT_EVENT_TYPE                ;
  public    : SC_IN (Tcontrol_t           )  *  in_COMMIT_EVENT_IS_DELAY_SLOT       ;
  public    : SC_IN (Taddress_t           )  *  in_COMMIT_EVENT_ADDRESS             ;
  public    : SC_IN (Tcontrol_t           )  *  in_COMMIT_EVENT_ADDRESS_EPCR_VAL    ;
  public    : SC_IN (Taddress_t           )  *  in_COMMIT_EVENT_ADDRESS_EPCR        ;
  public    : SC_IN (Tcontrol_t           )  *  in_COMMIT_EVENT_ADDRESS_EEAR_VAL    ;
  public    : SC_IN (Taddress_t           )  *  in_COMMIT_EVENT_ADDRESS_EEAR        ;

    // ~~~~~[ Interface "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t           ) ** out_EVENT_VAL                        ;//[nb_context]
  public    : SC_IN (Tcontrol_t           ) **  in_EVENT_ACK                        ;//[nb_context]
  public    : SC_OUT(Taddress_t           ) ** out_EVENT_ADDRESS                    ;//[nb_context]
  public    : SC_OUT(Taddress_t           ) ** out_EVENT_ADDRESS_NEXT               ;//[nb_context] 
  public    : SC_OUT(Tcontrol_t           ) ** out_EVENT_ADDRESS_NEXT_VAL           ;//[nb_context]
  public    : SC_OUT(Tcontrol_t           ) ** out_EVENT_IS_DS_TAKE                 ;//[nb_context]

    // ~~~~~[ Interface "spr_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t           ) ** out_SPR_EVENT_VAL                    ;//[nb_context]
  public    : SC_IN (Tcontrol_t           ) **  in_SPR_EVENT_ACK                    ;//[nb_context]
  public    : SC_OUT(Tspr_t               ) ** out_SPR_EVENT_EPCR                   ;//[nb_context]
  public    : SC_OUT(Tcontrol_t           ) ** out_SPR_EVENT_EEAR_WEN               ;//[nb_context]
  public    : SC_OUT(Tspr_t               ) ** out_SPR_EVENT_EEAR                   ;//[nb_context]
  public    : SC_OUT(Tcontrol_t           ) ** out_SPR_EVENT_SR_DSX                 ;//[nb_context]
  public    : SC_OUT(Tcontrol_t           ) ** out_SPR_EVENT_SR_TO_ESR              ;//[nb_context]
                                                                                   
    // ~~~~~[ Interface : "nb_inst" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~         
  public    : SC_IN (Tcounter_t           ) **  in_NB_INST_COMMIT_ALL               ;//[nb_context]
  public    : SC_IN (Tcounter_t           ) **  in_NB_INST_COMMIT_MEM               ;//[nb_context]
  public    : SC_OUT(Tcounter_t           ) ** out_NB_INST_DECOD_ALL                ;//[nb_context]
                                                                                   
    // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~         
  public    : SC_OUT(Tdepth_t             ) ** out_DEPTH_MIN                        ;//[nb_context]
  public    : SC_OUT(Tdepth_t             ) ** out_DEPTH_MAX                        ;//[nb_context]
  public    : SC_OUT(Tcontrol_t           ) ** out_DEPTH_FULL                       ;//[nb_context]

    // ~~~~~[ Interface : "spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~         
  public    : SC_IN (Tcontrol_t           ) **  in_SPR_SR_IEE                       ;//[nb_context] - Interrupt Exception Enabled
  public    : SC_IN (Tcontrol_t           ) **  in_SPR_SR_EPH                       ;//[nb_context] - Exception Prefix High

    // ~~~~~[ Interface : "interrupt" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t           ) **  in_INTERRUPT_ENABLE                 ;//[nb_context] - Interrupt Exception

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  public    : behavioural::core::multi_front_end::front_end::ifetch_unit    ::Ifetch_unit     ** _component_ifetch_unit    ;
  public    : behavioural::core::multi_front_end::front_end::prediction_unit::Prediction_unit  * _component_prediction_unit;
  public    : behavioural::core::multi_front_end::front_end::decod_unit     ::Decod_unit      ** _component_decod_unit     ;
  public    : behavioural::core::multi_front_end::front_end::context_state  ::Context_State    * _component_context_state  ;
  public    : behavioural::core::multi_front_end::front_end::front_end_glue ::Front_end_Glue   * _component_glue           ;

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Front_end);
#endif
  public  :          Front_end              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Front_end             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
# if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void        transition                (void);
# endif					       
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
