#ifdef STATISTICS
/*
 * $Id: Issue_queue_statistics_allocation.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Issue_queue/include/Issue_queue.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace issue_queue {


#undef  FUNCTION
#define FUNCTION "Issue_queue::statistics_allocation"
  void Issue_queue::statistics_allocation (morpheo::behavioural::Parameters_Statistics * param_statistics)
  {
    log_begin(Issue_queue,FUNCTION);

    _stat = new Stat (static_cast<std::string>(_name),
		      "Issue_queue",
		      param_statistics);
    
    _stat_bank_nb_inst     = new counter_t * [_param->_nb_bank];
    _stat_nb_inst_issue_in = new counter_t * [_param->_nb_rename_unit];

    // instruction
    {
      _stat_nb_inst_reexecute = _stat->create_variable("nb_inst_reexecute");

      std::string sum_nb_inst_issue_in = "";
      std::string sum_average_use_interface_issue_in = "";
      for (uint32_t i=0; i<_param->_nb_rename_unit; i++)
	{
	  _stat_nb_inst_issue_in [i] = _stat->create_variable("nb_inst_issue_in_"+toString(i));
	  
	  _stat->create_expr_average_by_cycle("average_use_interface_issue_in_"+toString(i), "nb_inst_issue_in_"+toString(i), "", toString(_("Average instruction by cycle on issue_in interface (rename_unit %d)"),i));
	  _stat->create_expr_percent         ("percent_use_interface_issue_in_"+toString(i) , "average_use_interface_issue_in_"+toString(i), toString(_param->_nb_inst_rename [i]), toString(_("Percent usage of issue_in interface (rename_unit %d)"),i));
	  
	  if (i == 0)
	    {
	      sum_nb_inst_issue_in               = "nb_inst_issue_in_"+toString(i);
	      sum_average_use_interface_issue_in = "average_use_interface_issue_in_"+toString(i);
	    }
	  else
	    {
	      sum_nb_inst_issue_in               = "+ nb_inst_issue_in_"+toString(i) + " " +sum_nb_inst_issue_in;
	      sum_average_use_interface_issue_in = "+ average_use_interface_issue_in_"+toString(i)+ " "+sum_average_use_interface_issue_in;
	    }
      	}
      
      _stat->create_expr_average_by_cycle("average_use_interface_reexecute", "nb_inst_reexecute", "", _("Average instruction by cycle on reexecute interface"));
      _stat->create_expr_percent         ("percent_use_interface_reexecute" , "average_use_interface_reexecute", toString(_param->_nb_inst_reexecute), _("Percent usage of reexecute interface"));
      
      _stat->create_expr_average_by_cycle("average_inst_in", "+ nb_inst_reexecute " + sum_nb_inst_issue_in, "", _("Average instruction by cycle"));
      _stat->create_expr_percent         ("percent_inst_in"          , "average_inst_in"              , toString(_param->_nb_bank), _("Percent of instruction by cycle"));
      _stat->create_expr_percent         ("percent_inst_reexecute", "average_use_interface_reexecute" , "average_inst_in", _("Percent of instruction reexecute by cycle"));
      _stat->create_expr_percent         ("percent_inst_issue_in" , sum_average_use_interface_issue_in, "average_inst_in", _("Percent of instruction issue_in by cycle"));
    }
    
    {
      _stat_nb_inst_issue_out = _stat->create_variable("nb_inst_issue_out");

      _stat->create_expr_average_by_cycle("average_use_interface_issue_out", "nb_inst_issue_out", "", _("Average instruction by cycle on issue_out interface"));
      _stat->create_expr_percent         ("percent_use_interface_issue_out" , "average_use_interface_issue_out", toString(_param->_nb_inst_issue), _("Percent usage of issue_out interface"));
    }

    // bank/queue occupation
    {
      std::string sum_bank_nb_inst = "";
      for (uint32_t i=0; i<_param->_nb_bank; i++)
	{
	  _stat_bank_nb_inst [i] = _stat->create_variable("bank_nb_inst_"+toString(i));
	  
	  _stat->create_expr_average_by_cycle("average_occupation_bank_"+toString(i), "bank_nb_inst_"+toString(i), "", toString(_("Average instruction by cycle (bank %d)"),i));
	  _stat->create_expr_percent         ("percent_occupation_bank_"+toString(i), "average_occupation_bank_"+toString(i), toString(_param->_size_bank), toString(_("Percent occupation of bank (bank %d)"),i));
	  
	  if (i == 0)
	    sum_bank_nb_inst = "bank_nb_inst_"+toString(i);
	  else
	    sum_bank_nb_inst = "+ bank_nb_inst_"+toString(i) + " " +sum_bank_nb_inst;
	}
      
      _stat->create_expr_average_by_cycle("average_occupation_bank", sum_bank_nb_inst, "", _("Average instruction by cycle (all bank)"));
      _stat->create_expr_percent         ("percent_occupation_bank" , "average_occupation_bank", toString(_param->_size_queue), _("Percent occupation of issue_queue (all bank)"));
    }

    log_end(Issue_queue,FUNCTION);
  };

}; // end namespace issue_queue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
