#ifdef SYSTEMC
/*
 * $Id: Rename_unit_Glue_genMealy_insert.cpp 139 2010-07-30 14:47:27Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_unit_Glue/include/Rename_unit_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace rename_unit_glue {


#undef  FUNCTION
#define FUNCTION "Rename_unit_Glue::genMealy_insert"
  void Rename_unit_Glue::genMealy_insert (void)
  {
    log_begin(Rename_unit_Glue,FUNCTION);
    log_function(Rename_unit_Glue,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET))
      {
    for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
      {
	
	Tcontext_t         FRONT_END_ID       = (_param->_have_port_front_end_id)?PORT_READ(in_INSERT_RENAME_SELECT_FRONT_END_ID [i]):0;
	Tcontext_t         CONTEXT_ID         = (_param->_have_port_context_id  )?PORT_READ(in_INSERT_RENAME_SELECT_CONTEXT_ID   [i]):0;
	Tdepth_t           DEPTH              = ((_param->_rat_scheme == RAT_DEPTH_SAVE) and _param->_have_port_depth)?PORT_READ(in_INSERT_RENAME_SELECT_DEPTH [i]):0;
	Ttype_t            TYPE               = PORT_READ(in_INSERT_RENAME_SELECT_TYPE                      [i]);
	Toperation_t       OPERATION          = PORT_READ(in_INSERT_RENAME_SELECT_OPERATION                 [i]);
	Tgeneral_data_t    IMMEDIAT           = PORT_READ(in_INSERT_RENAME_SELECT_IMMEDIAT                  [i]);
// 	Texception_t       EXCEPTION_USE      = PORT_READ(in_INSERT_RENAME_SELECT_EXCEPTION_USE             [i]);
	Texception_t       EXCEPTION          = PORT_READ(in_INSERT_RENAME_SELECT_EXCEPTION                 [i]);
	Tspecial_address_t NUM_REG_RE_PHY_NEW = PORT_READ(in_INSERT_REGISTER_TRANSLATION_NUM_REG_RE_PHY_NEW [i]);
	Tspr_t             SR                 = PORT_READ(in_SPR_READ_SR[FRONT_END_ID][CONTEXT_ID]);

	switch (TYPE)
	  {
	  case TYPE_SPECIAL :
	    {
	      switch (OPERATION)
		{
		case OPERATION_SPECIAL_L_TRAP  :
		  {
#ifdef DEBUG_TEST
		    if (IMMEDIAT > 32)
		      throw ERRORMORPHEO(FUNCTION,_("Immediat is too high.\n"));
#endif
		    
		    // Test if bit is set
		    if ((SR>>IMMEDIAT)&1)
		      EXCEPTION = EXCEPTION_TRAP;

		    // Test 
		    break;
		  }
		case OPERATION_SPECIAL_L_MFSPR :
		case OPERATION_SPECIAL_L_MTSPR :
		  {
		    // HACK : use the field num_reg_re to pass the SM and SUMRA flag.
		    NUM_REG_RE_PHY_NEW = (
					  ((SR >> 16)&1) | // SUMRA
					  ((SR >>  0)&1)   // SM
					  );

		    break;
		  }
		default :
		  {
		    break;
		  }
		}
	      break;
	    }
	  default :
	    {
	      break;
	    }
	  }

	
	if (_param->_have_port_front_end_id)
	  {
	PORT_WRITE(out_INSERT_FRONT_END_ID                          [i],FRONT_END_ID      );
	PORT_WRITE(out_INSERT_REGISTER_TRANSLATION_FRONT_END_ID     [i],FRONT_END_ID      );
	PORT_WRITE(out_INSERT_LOAD_STORE_QUEUE_POINTER_FRONT_END_ID [i],FRONT_END_ID      );
	  }
	if (_param->_have_port_context_id)
	  {
	PORT_WRITE(out_INSERT_CONTEXT_ID                            [i],CONTEXT_ID        );
	PORT_WRITE(out_INSERT_REGISTER_TRANSLATION_CONTEXT_ID       [i],CONTEXT_ID        );
	PORT_WRITE(out_INSERT_LOAD_STORE_QUEUE_POINTER_CONTEXT_ID   [i],CONTEXT_ID        );
	  }
        if (_param->_have_port_depth and (_param->_rat_scheme == RAT_DEPTH_SAVE))
	  {
	PORT_WRITE(out_INSERT_DEPTH                                 [i],DEPTH             );
	PORT_WRITE(out_INSERT_REGISTER_TRANSLATION_DEPTH            [i],DEPTH             );
          }
	PORT_WRITE(out_INSERT_TYPE                                  [i],TYPE              );
	PORT_WRITE(out_INSERT_OPERATION                             [i],OPERATION         );
	PORT_WRITE(out_INSERT_IMMEDIAT                              [i],IMMEDIAT          );
// 	PORT_WRITE(out_INSERT_EXCEPTION_USE                         [i],EXCEPTION_USE     );
	PORT_WRITE(out_INSERT_EXCEPTION                             [i],EXCEPTION         );
	PORT_WRITE(out_INSERT_NUM_REG_RE_PHY_NEW                    [i],NUM_REG_RE_PHY_NEW);
	PORT_WRITE(out_INSERT_LOAD_STORE_QUEUE_POINTER_TYPE         [i],TYPE              );
	PORT_WRITE(out_INSERT_LOAD_STORE_QUEUE_POINTER_OPERATION    [i],OPERATION         );
      }
      }

    log_end(Rename_unit_Glue,FUNCTION);
  };

}; // end namespace rename_unit_glue
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
