/*
 * $Id: top_test.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [Description ]
 * 
 * Test
 */

#include "Behavioural/Generic/Queue/SelfTest/include/top.h"
#include "Behavioural/include/Allocation.h"

void top::test (void)
{
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
      msgInformation(_("<%s> : Start Simulation ............\n"),name.c_str());
      
      Time * _time = new Time();
      
      /********************************************************
       * Simulation - Begin
       ********************************************************/
      
      // Initialisation
      const  int32_t percent_insert_transaction = 75;
      const  int32_t percent_retire_transaction = 75;
      const uint32_t nb_request = 3*_param->_size_queue;
      
      const uint32_t seed = 0;
      //const uint32_t seed = static_cast<uint32_t>(time(NULL));
      
      srand(seed);
      
      SC_CYCLE(0);
      LABEL("Initialisation");
      
      in_INSERT_VAL -> write(0);
      in_RETIRE_ACK -> write(0);
      
      LABEL("Reset");
      in_NRESET->write(0);
      SC_CYCLE(5);
      in_NRESET->write(1);  
      
      LABEL("Loop of Test");
      
      uint32_t data_in  = 0;
      uint32_t data_out = 0;
      uint32_t nb_elt   = 0;
      
      for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
        {
          LABEL("Iteration %d",iteration);
          
          while (data_out <= nb_request)
            {
              in_INSERT_VAL  -> write((rand()%100)<percent_insert_transaction);
              in_INSERT_DATA -> write(data_in);
              in_RETIRE_ACK  -> write((rand()%100)<percent_retire_transaction);
              
              SC_CYCLE(0); // genMoore
              
              for (uint32_t i=0; i<_param->_nb_port_slot; ++i)
                {
                  TEST(Tcontrol_t, out_SLOT_VAL [i]->read(), (i<nb_elt));
                  if (i<nb_elt)
                    TEST(Tdata_t   , out_SLOT_DATA[i]->read(), data_out+i);
                  
                }
              
              if ( in_INSERT_VAL->read() and out_INSERT_ACK->read())
                {
                  LABEL ("Transaction with interface : INSERT");
                  data_in ++;
                  nb_elt ++;
                }
              if (out_RETIRE_VAL->read() and  in_RETIRE_ACK->read())
                {
                  LABEL ("Transaction with interface : RETIRE");
                  TEST(Tdata_t, out_RETIRE_DATA->read(), data_out);
                  data_out++;
                  nb_elt --;
                }
              
              SC_CYCLE(1);
            }
        }
      
      /********************************************************
       * Simulation - End
       ********************************************************/
      
      TEST_OK ("");
      
      sc_stop();
      delete _time;
      
      msgInformation(_("<%s> : ............ Stop Simulation\n"),name.c_str());
    }
#endif
}
