/*
 * $Id: Victim_Pseudo_LRU.cpp 132 2009-07-11 16:39:35Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Victim/Victim_Pseudo_LRU/include/Victim_Pseudo_LRU.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace victim {
namespace victim_pseudo_lru {

  Victim_Pseudo_LRU::Victim_Pseudo_LRU 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   std::string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::generic::victim::victim_pseudo_lru::Parameters * param ,
   morpheo::behavioural::Tusage_t usage):
    _name   (name)
    ,_param (param)
    ,_usage (usage)
  {
    log_printf(FUNC,Victim_Pseudo_LRU,"Victim_Pseudo_LRU","Begin");

// #if DEBUG_Victim_Pseudo_LRU == true
//     log_printf(INFO,Victim_Pseudo_LRU,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(TRACE,Victim_Pseudo_LRU,"Victim_Pseudo_LRU","Allocation");
    allocation ();

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
        log_printf(TRACE,Victim_Pseudo_LRU,"Victim_Pseudo_LRU","Allocation of statistics");
        
        // Allocation of statistics
        statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {	
        // generate the vhdl
        log_printf(TRACE,Victim_Pseudo_LRU,"Victim_Pseudo_LRU","Generation of VHDL");
        vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {	
    log_printf(TRACE,Victim_Pseudo_LRU,"Victim_Pseudo_LRU","Definition of sc_method");

#ifdef SYSTEMCASS_SPECIFIC
    constant();
#else
    SC_METHOD (constant);
//     dont_initialize ();
#endif

    SC_METHOD (transition);
    dont_initialize ();
    sensitive << (*(in_CLOCK)).pos();

    SC_METHOD (genMealy);
    dont_initialize ();
    sensitive << (*(in_CLOCK)).neg()
	      << (*(in_NRESET));
    for (uint32_t i=0; i<_param->_nb_access; i++)
      if (_param->_size_table>1)
        sensitive << (*(in_ACCESS_ADDRESS[i]));

#ifdef SYSTEMCASS_SPECIFIC
    if (_param->_size_table>1)
      for (uint32_t i=0; i<_param->_nb_access; i++)
	(*(out_ACCESS_VICTIM[i])) (*(in_ACCESS_ADDRESS[i]));
#endif    
      }
#endif
    log_printf(FUNC,Victim_Pseudo_LRU,"Victim_Pseudo_LRU","End");
  };
  
  Victim_Pseudo_LRU::~Victim_Pseudo_LRU (void)
  {
    log_printf(FUNC,Victim_Pseudo_LRU,"~Victim_Pseudo_LRU","Begin");

    deallocation ();


#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      delete _stat;
#endif
    log_printf(FUNC,Victim_Pseudo_LRU,"~Victim_Pseudo_LRU","End");
  };

}; // end namespace victim_pseudo_lru
}; // end namespace victim
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
