/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/@DIRECTORY/include/@COMPONENT.h"

namespace morpheo                    {
namespace behavioural {
@NAMESPACE_BEGIN

#undef  FUNCTION
#define FUNCTION "@COMPONENT::@COMPONENT"
  @COMPONENT::@COMPONENT 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::@NAMESPACE_USE::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
  {
    log_begin(@COMPONENT,FUNCTION);

    _usage = usage_environment(usage);

#ifdef MODELSIM_COSIMULATION
    if (_model.get_type(_param->_type) == MODEL_VHDL)
      {
        _usage = usage_cosimulation(_usage);
      }
#endif

    log_printf(INFO,@COMPONENT,FUNCTION,_("<%s> : Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,@COMPONENT,FUNCTION,_("<%s> : Allocation of statistics"),_name.c_str());

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,@COMPONENT,FUNCTION,_("<%s> : Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC_BODY))
      {
	log_printf(INFO,@COMPONENT,FUNCTION,_("<%s> : Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

// 	log_printf(INFO,@COMPONENT,FUNCTION,_("<%s> : Method - genMoore"),_name.c_str());

// 	SC_METHOD (genMoore);
// 	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // need internal register
	
// # ifdef SYSTEMCASS_SPECIFIC
// 	// List dependency information
// # endif    
	
      }
#endif

    log_end(@COMPONENT,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "@COMPONENT::~@COMPONENT"
  @COMPONENT::~@COMPONENT (void)
  {
    log_begin(@COMPONENT,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,@COMPONENT,FUNCTION,_("<%s> : Deallocation"),_name.c_str());
    deallocation ();

    log_end(@COMPONENT,FUNCTION);
  };

@NAMESPACE_END
}; // end namespace behavioural
}; // end namespace morpheo              
