#ifndef Morpheo_ErrorMorpheo_h
#define Morpheo_ErrorMorpheo_h

/*
 * $Id: ErrorMorpheo.h 138 2010-05-12 17:34:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/ToString.h"
#include "Common/include/Translation.h"
#include "Common/include/Message.h"

#include <iostream>
#include <exception>

namespace morpheo              {

#define ERRORMORPHEO(funcname,msg) ErrorMorpheo(funcname,msg,__LINE__,__FILE__)

  class ErrorMorpheo : public std::exception 
  {
    // -----[ fields ]----------------------------------------------------
  private : std::string _msg;
    
    // -----[ methods ]---------------------------------------------------
  public  :             ErrorMorpheo  ()                throw() {_msg = toString("%s ",MSG_ERROR); _msg+="Exception detected ...";}
  public  :             ErrorMorpheo  (std::string msg) throw() {_msg = toString("%s ",MSG_ERROR); _msg+=msg;}
  public  :             ErrorMorpheo  (std::string funcname,
				       std::string msg     ,
				       int         line    ,
				       std::string file    ) throw() 
    { 
#ifdef DEBUG
      _msg = toString(_("%s at line %d, in file %s"),MSG_ERROR,line,file.c_str());
      _msg = toString(_("%s <%s> %s"),MSG_ERROR,funcname.c_str(),msg.c_str());
#else
      _msg = toString(_("%s %s"),MSG_ERROR,msg.c_str());
#endif
//     msg("%s",_msg.c_str());
    }
  public  :             ~ErrorMorpheo (void)       throw() {}
  public  : const char* what          ()    const  throw() { return ( _msg.c_str() );}

  };

//   class TestMorpheo : public std::exception 
//   {
//     // -----[fields ]----------------------------------------------------
//   private : std::string _msg;
    
//     // -----[methods ]---------------------------------------------------
//   public  :             TestMorpheo   ()                throw() {_msg=_("Test error ...");}
//   public  :             TestMorpheo   (std::string msg) throw() {_msg=msg;}
//   public  :             ~TestMorpheo  (void)            throw() {}
//   public  : const char* what          ()    const       throw() { return ( _msg.c_str() );}
//   };

}; // end namespace morpheo              

#endif
