/*
 * Test_014
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.andi
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r0 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:
        /*
             A (r1)     B (I)  - D (r3 wait)
                                       (r4)     
          1) 0x0f0f0f0f 0x00ff - 0x0000000f 
          1) 0x0f0f0f0f 0xff00 - 0x00000f00 
          */

        /**********/
        /* Test 1 */
        /**********/
	l.movhi r1,     hi(0x0f0f0f0f) /* RA */
	l.ori   r1, r1, lo(0x0f0f0f0f)
	l.movhi r3,     hi(0x0000000f) /* RD wait */
	l.ori   r3, r3, lo(0x0000000f)
        
        l.andi  r4, r1, 0x00ff

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 2 */
        /**********/
	l.movhi r1,     hi(0x0f0f0f0f) /* RA */
	l.ori   r1, r1, lo(0x0f0f0f0f)
	l.movhi r3,     hi(0x00000f00) /* RD wait */
	l.ori   r3, r3, lo(0x00000f00)
        
        l.andi  r4, r1, 0xff00

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* End */
        /**********/

        l.j     _end_ok
        l.nop
