/*
 * Test_042
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.srli
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r0 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:
        /*
             A (r1)     B (r2)     - D (r3 wait)
                                           (r4)     
          1) 0xdeadbeef 0x00000000 - 0xdeadbeef
          2) 0xdeadbeef 0x00000008 - 0x00deadbe
          3) 0xdeadbeef 0x00000010 - 0x0000dead
          4) 0xdeadbeef 0x00000018 - 0x000000de
          5) 0xdeadbeef 0x0000001f - 0x00000001
          6) 0xdeadbeef 0x00000004 - 0x0deadbee 
          7) 0x12345678 0x00000000 - 0x12345678
          8) 0x12345678 0x00000008 - 0x00123456
          9) 0x12345678 0x00000010 - 0x00001234
         10) 0x12345678 0x00000018 - 0x00000012
         11) 0x12345678 0x0000001f - 0x00000000
         12) 0x12345678 0x00000004 - 0x01234567
         */

        /***********/
        /* Test 1  */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r3,     hi(0xdeadbeef) /* RD wait */
	l.ori   r3, r3, lo(0xdeadbeef)
        
        l.srli  r4, r1, 0 

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 2  */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r3,     hi(0x00deadbe) /* RD wait */
	l.ori   r3, r3, lo(0x00deadbe)
        
        l.srli  r4, r1, 8 

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop
        
        /***********/
        /* Test 3  */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r3,     hi(0x0000dead) /* RD wait */
	l.ori   r3, r3, lo(0x0000dead)
        
        l.srli  r4, r1, 16 

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop
        
        /***********/
        /* Test 4  */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r3,     hi(0x000000de) /* RD wait */
	l.ori   r3, r3, lo(0x000000de)
        
        l.srli  r4, r1, 24 

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop
        
        /***********/
        /* Test 5  */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r3,     hi(0x00000001) /* RD wait */
	l.ori   r3, r3, lo(0x00000001)
        
        l.srli  r4, r1, 31 

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop
        
        /***********/
        /* Test 6  */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r3,     hi(0x0deadbee) /* RD wait */
	l.ori   r3, r3, lo(0x0deadbee)
        
        l.srli  r4, r1, 4

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 7  */
        /***********/
	l.movhi r1,     hi(0x12345678) /* RA */
	l.ori   r1, r1, lo(0x12345678)
	l.movhi r3,     hi(0x12345678) /* RD wait */
	l.ori   r3, r3, lo(0x12345678)
        
        l.srli  r4, r1, 0

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 8  */
        /***********/
	l.movhi r1,     hi(0x12345678) /* RA */
	l.ori   r1, r1, lo(0x12345678)
	l.movhi r3,     hi(0x00123456) /* RD wait */
	l.ori   r3, r3, lo(0x00123456)
        
        l.srli  r4, r1, 8

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop
        
        /***********/
        /* Test 9  */
        /***********/
	l.movhi r1,     hi(0x12345678) /* RA */
	l.ori   r1, r1, lo(0x12345678)
	l.movhi r3,     hi(0x00001234) /* RD wait */
	l.ori   r3, r3, lo(0x00001234)
        
        l.srli  r4, r1, 16 

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop
        
        /***********/
        /* Test 10 */
        /***********/
	l.movhi r1,     hi(0x12345678) /* RA */
	l.ori   r1, r1, lo(0x12345678)
	l.movhi r3,     hi(0x00000012) /* RD wait */
	l.ori   r3, r3, lo(0x00000012)
        
        l.srli  r4, r1, 24 

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop
        
        /***********/
        /* Test 11 */
        /***********/
	l.movhi r1,     hi(0x12345678) /* RA */
	l.ori   r1, r1, lo(0x12345678)
	l.movhi r3,     hi(0x00000000) /* RD wait */
	l.ori   r3, r3, lo(0x00000000)
        
        l.srli  r4, r1, 31 

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop
        
        /***********/
        /* Test 12 */
        /***********/
	l.movhi r1,     hi(0x12345678) /* RA */
	l.ori   r1, r1, lo(0x12345678)
	l.movhi r3,     hi(0x01234567) /* RD wait */
	l.ori   r3, r3, lo(0x01234567)
        
        l.srli  r4, r1, 4

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        
        /**********/
        /* End */
        /**********/

        l.j     _end_ok
        l.nop
