#ifdef STATISTICS
/*
 * $Id: RegisterFile_Monolithic_statistics_declaration.cpp 138 2010-05-12 17:34:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/RegisterFile_Monolithic.h"

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {
namespace registerfile_monolithic    {

  void RegisterFile_Monolithic::statistics_declaration (morpheo::behavioural::Parameters_Statistics * param_statistics)
  {
    _stat = new Stat (static_cast<std::string>(_name),
		      "RegisterFile_Monolithic",
		      param_statistics);

    if (_param->_nb_port_read>0)
    _stat_port_read         = _stat->create_counters("port_read",_param->_nb_port_read,"",
                                                     _("Usage of read port %d."),
                                                     _("Percent of usage read port %d."),
                                                     _("Average of usage read port.")
                                                     );

    if (_param->_nb_port_write>0)
    _stat_port_write        = _stat->create_counters("port_write",_param->_nb_port_write,"",
                                                     _("Usage of write port %d."),
                                                     _("Percent of usage write port %d."),
                                                     _("Average of usage write port.")
                                                     );
    if (_param->_nb_port_read_write>0)
    _stat_port_read_write   = _stat->create_counters("port_read_write",_param->_nb_port_read_write,"",
                                                     _("Usage of read_write port."),
                                                     _("Percent of usage read_write port %d."),
                                                     _("Average of usage read_write port.")
                                                     );

    // _stat_nb_read           = _stat->create_variable("nb_read" );
    // _stat_nb_write          = _stat->create_variable("nb_write");

    // _stat->create_expr_average_by_cycle("average_read" , "nb_read" , "", _("Average read by cycle" ));
    // _stat->create_expr_average_by_cycle("average_write", "nb_write", "", _("Average write by cycle"));

    // _stat->create_expr_percent         ("percent_use_read" , "average_read" , toString(_param->_nb_port_read +_param->_nb_port_read_write), _("Percent read by cycle" ));
    // _stat->create_expr_percent         ("percent_use_write", "average_write", toString(_param->_nb_port_write+_param->_nb_port_read_write), _("Percent write by cycle"));

  };

}; // end namespace registerfile_monolithic
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
