#ifdef STATISTICS
/*
 * $Id: Context_State_statistics_allocation.cpp 120 2009-05-26 19:01:47Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Context_State/include/Context_State.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace context_state {


#undef  FUNCTION
#define FUNCTION "Context_State::statistics_allocation"
  void Context_State::statistics_allocation (morpheo::behavioural::Parameters_Statistics * param_statistics)
  {
    log_begin(Context_State,FUNCTION);

    _stat = new Stat (static_cast<std::string>(_name),
		      "Context_State",
		      param_statistics);

    ALLOC1(_stat_nb_cycle_state_ok                     ,counter_t *,_param->_nb_context);
    ALLOC1(_stat_nb_cycle_state_ko_excep               ,counter_t *,_param->_nb_context);
    ALLOC1(_stat_nb_cycle_state_ko_miss_branch         ,counter_t *,_param->_nb_context);
    ALLOC1(_stat_nb_cycle_state_ko_miss_load           ,counter_t *,_param->_nb_context);
    ALLOC1(_stat_nb_cycle_state_ko_miss_load_and_branch,counter_t *,_param->_nb_context);
    ALLOC1(_stat_nb_cycle_state_ko_msync               ,counter_t *,_param->_nb_context);
    ALLOC1(_stat_nb_cycle_state_ko_psync               ,counter_t *,_param->_nb_context);
    ALLOC1(_stat_nb_cycle_state_ko_csync               ,counter_t *,_param->_nb_context);
    ALLOC1(_stat_nb_cycle_state_ko_spr                 ,counter_t *,_param->_nb_context);

    for (uint32_t i=0; i<_param->_nb_context; ++i)
      {
        _stat_nb_cycle_state_ok                      [i] = _stat->create_counter("nb_cycle_state_ok_"                     +toString(i),"",toString(_("Number of cycle in state ok                      (context %d)"),i));
        _stat_nb_cycle_state_ko_excep                [i] = _stat->create_counter("nb_cycle_state_ko_excep_"               +toString(i),"",toString(_("Number of cycle in state ko_excep                (context %d)"),i));
        _stat_nb_cycle_state_ko_miss_branch          [i] = _stat->create_counter("nb_cycle_state_ko_miss_branch_"         +toString(i),"",toString(_("Number of cycle in state ko_miss_branch          (context %d)"),i));
        _stat_nb_cycle_state_ko_miss_load            [i] = _stat->create_counter("nb_cycle_state_ko_miss_load_"           +toString(i),"",toString(_("Number of cycle in state ko_miss_load            (context %d)"),i));
        _stat_nb_cycle_state_ko_miss_load_and_branch [i] = _stat->create_counter("nb_cycle_state_ko_miss_load_and_branch_"+toString(i),"",toString(_("Number of cycle in state ko_miss_load_and_branch (context %d)"),i));
        _stat_nb_cycle_state_ko_msync                [i] = _stat->create_counter("nb_cycle_state_ko_msync_"               +toString(i),"",toString(_("Number of cycle in state ko_msync                (context %d)"),i));
        _stat_nb_cycle_state_ko_psync                [i] = _stat->create_counter("nb_cycle_state_ko_psync_"               +toString(i),"",toString(_("Number of cycle in state ko_psync                (context %d)"),i));
        _stat_nb_cycle_state_ko_csync                [i] = _stat->create_counter("nb_cycle_state_ko_csync_"               +toString(i),"",toString(_("Number of cycle in state ko_csync                (context %d)"),i));
        _stat_nb_cycle_state_ko_spr                  [i] = _stat->create_counter("nb_cycle_state_ko_spr_"                 +toString(i),"",toString(_("Number of cycle in state ko_spr                  (context %d)"),i));


        _stat->create_expr_percent("percent_state_ok_"                     +toString(i),"nb_cycle_state_ok_"                     +toString(i),"cycle",toString(_("Percent of cycle in state ok                      (context %d)"),i));
        _stat->create_expr_percent("percent_state_ko_excep_"               +toString(i),"nb_cycle_state_ko_excep_"               +toString(i),"cycle",toString(_("Percent of cycle in state ko_excep                (context %d)"),i));
        _stat->create_expr_percent("percent_state_ko_miss_branch_"         +toString(i),"nb_cycle_state_ko_miss_branch_"         +toString(i),"cycle",toString(_("Percent of cycle in state ko_miss_branch          (context %d)"),i));
        _stat->create_expr_percent("percent_state_ko_miss_load_"           +toString(i),"nb_cycle_state_ko_miss_load_"           +toString(i),"cycle",toString(_("Percent of cycle in state ko_miss_load            (context %d)"),i));
        _stat->create_expr_percent("percent_state_ko_miss_load_and_branch_"+toString(i),"nb_cycle_state_ko_miss_load_and_branch_"+toString(i),"cycle",toString(_("Percent of cycle in state ko_miss_load_and_branch (context %d)"),i));
        _stat->create_expr_percent("percent_state_ko_msync_"               +toString(i),"nb_cycle_state_ko_msync_"               +toString(i),"cycle",toString(_("Percent of cycle in state ko_msync                (context %d)"),i));
        _stat->create_expr_percent("percent_state_ko_psync_"               +toString(i),"nb_cycle_state_ko_psync_"               +toString(i),"cycle",toString(_("Percent of cycle in state ko_psync                (context %d)"),i));
        _stat->create_expr_percent("percent_state_ko_csync_"               +toString(i),"nb_cycle_state_ko_csync_"               +toString(i),"cycle",toString(_("Percent of cycle in state ko_csync                (context %d)"),i));
        _stat->create_expr_percent("percent_state_ko_spr_"                 +toString(i),"nb_cycle_state_ko_spr_"                 +toString(i),"cycle",toString(_("Percent of cycle in state ko_spr                  (context %d)"),i));
      }

    log_end(Context_State,FUNCTION);
  };

}; // end namespace context_state
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
