#ifndef morpheo_behavioural_core_multi_front_end_front_end_decod_unit_decod_Decod_h
#define morpheo_behavioural_core_multi_front_end_front_end_decod_unit_decod_Decod_h

/*
 * $Id: Decod.h 139 2010-07-30 14:47:27Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod/include/Types.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod/Instruction/include/Instruction.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Behavioural/Generic/Priority/include/Priority.h"

#include <iostream>
#include <list>

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod {


  class Decod 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
  public    : counter_t                      * _stat_sum_inst_decod;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "ifetch_unit" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         ) ***  in_IFETCH_VAL                         ;//[nb_context][nb_inst_fetch]
  public    : SC_OUT(Tcontrol_t         ) *** out_IFETCH_ACK                         ;//[nb_context][nb_inst_fetch]
  public    : SC_IN (Tinstruction_t     ) ***  in_IFETCH_INSTRUCTION                 ;//[nb_context][nb_inst_fetch]
  public    : SC_IN (Tcontext_t         ) ***  in_IFETCH_CONTEXT_ID                  ;//[nb_context][nb_inst_fetch]
  public    : SC_IN (Tgeneral_address_t ) ***  in_IFETCH_ADDRESS                     ;//[nb_context][nb_inst_fetch]
//public    : SC_IN (Tgeneral_address_t ) ***  in_IFETCH_ADDRESS_NEXT                ;//[nb_context][nb_inst_fetch]
//public    : SC_IN (Tinst_ifetch_ptr_t ) ***  in_IFETCH_INST_IFETCH_PTR             ;//[nb_context][nb_inst_fetch]
  public    : SC_IN (Tbranch_state_t    ) ***  in_IFETCH_BRANCH_STATE                ;//[nb_context][nb_inst_fetch]
  public    : SC_IN (Tprediction_ptr_t  ) ***  in_IFETCH_BRANCH_UPDATE_PREDICTION_ID ;//[nb_context][nb_inst_fetch]
  public    : SC_IN (Texception_t       ) ***  in_IFETCH_EXCEPTION                   ;//[nb_context][nb_inst_fetch]										     
    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	     
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_VAL                          ;//[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_ACK                          ;//[nb_inst_decod]
  public    : SC_OUT(Tcontext_t         )  ** out_DECOD_CONTEXT_ID                   ;//[nb_inst_decod]
  public    : SC_OUT(Tdepth_t           )  ** out_DECOD_DEPTH                        ;//[nb_inst_decod]
#ifdef STATISTICS
  public    : SC_OUT(uint32_t           )  ** out_DECOD_INSTRUCTION                  ;//[nb_inst_decod]
#endif
  public    : SC_OUT(Ttype_t            )  ** out_DECOD_TYPE                         ;//[nb_inst_decod]
  public    : SC_OUT(Toperation_t       )  ** out_DECOD_OPERATION                    ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_NO_EXECUTE                   ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_IS_DELAY_SLOT                ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_SAVE_RAT                     ;//[nb_inst_decod]
#ifdef DEBUG
  public    : SC_OUT(Tgeneral_data_t    )  ** out_DECOD_ADDRESS                      ;//[nb_inst_decod]
#endif
  public    : SC_OUT(Tgeneral_data_t    )  ** out_DECOD_ADDRESS_NEXT                 ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_HAS_IMMEDIAT                 ;//[nb_inst_decod]
  public    : SC_OUT(Tgeneral_data_t    )  ** out_DECOD_IMMEDIAT                     ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_READ_RA                      ;//[nb_inst_decod]
  public    : SC_OUT(Tgeneral_address_t )  ** out_DECOD_NUM_REG_RA                   ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_READ_RB                      ;//[nb_inst_decod]
  public    : SC_OUT(Tgeneral_address_t )  ** out_DECOD_NUM_REG_RB                   ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_READ_RC                      ;//[nb_inst_decod]
  public    : SC_OUT(Tspecial_address_t )  ** out_DECOD_NUM_REG_RC                   ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_WRITE_RD                     ;//[nb_inst_decod]
  public    : SC_OUT(Tgeneral_address_t )  ** out_DECOD_NUM_REG_RD                   ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_WRITE_RE                     ;//[nb_inst_decod]
  public    : SC_OUT(Tspecial_address_t )  ** out_DECOD_NUM_REG_RE                   ;//[nb_inst_decod]
  public    : SC_OUT(Texception_t       )  ** out_DECOD_EXCEPTION_USE                ;//[nb_inst_decod]
  public    : SC_OUT(Texception_t       )  ** out_DECOD_EXCEPTION                    ;//[nb_inst_decod]

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_VAL                        ;//[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_ACK                        ;//[nb_inst_decod]
  public    : SC_OUT(Tcontext_t         )  ** out_PREDICT_CONTEXT_ID                 ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_MATCH_INST_IFETCH_PTR      ;//[nb_inst_decod]
  public    : SC_OUT(Tbranch_state_t    )  ** out_PREDICT_BRANCH_STATE               ;//[nb_inst_decod]
  public    : SC_OUT(Tprediction_ptr_t  )  ** out_PREDICT_BRANCH_UPDATE_PREDICTION_ID;//[nb_inst_decod]
  public    : SC_OUT(Tbranch_condition_t)  ** out_PREDICT_BRANCH_CONDITION           ;//[nb_inst_decod]
//public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_BRANCH_STACK_WRITE         ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_BRANCH_DIRECTION           ;//[nb_inst_decod]
  public    : SC_OUT(Tgeneral_data_t    )  ** out_PREDICT_ADDRESS_SRC                ;//[nb_inst_decod]
  public    : SC_OUT(Tgeneral_data_t    )  ** out_PREDICT_ADDRESS_DEST               ;//[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_CAN_CONTINUE               ;//[nb_inst_decod]

    // ~~~~~[ Interface : "context" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_CONTEXT_DECOD_ENABLE               ;//[nb_context]
  public    : SC_IN (Tcontrol_t         )  **  in_CONTEXT_DEPTH_VAL                  ;//[nb_context]
  public    : SC_IN (Tdepth_t           )  **  in_CONTEXT_DEPTH                      ;//[nb_context]
										     
    // ~~~~~[ Interface : "context_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	     
  public    : SC_OUT(Tcontrol_t         )   * out_CONTEXT_EVENT_VAL                  ;
  public    : SC_IN (Tcontrol_t         )   *  in_CONTEXT_EVENT_ACK                  ;
  public    : SC_OUT(Tcontext_t         )   * out_CONTEXT_EVENT_CONTEXT_ID           ;
  public    : SC_OUT(Tdepth_t           )   * out_CONTEXT_EVENT_DEPTH                ;
  public    : SC_OUT(Tevent_type_t      )   * out_CONTEXT_EVENT_TYPE                 ;
  public    : SC_OUT(Tcontrol_t         )   * out_CONTEXT_EVENT_IS_DELAY_SLOT        ;
  public    : SC_OUT(Tgeneral_data_t    )   * out_CONTEXT_EVENT_ADDRESS              ;
  public    : SC_OUT(Tgeneral_data_t    )   * out_CONTEXT_EVENT_ADDRESS_EPCR         ;

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : generic::priority::Priority   * _priority;

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : Tgeneral_data_t               * reg_CONTEXT_ADDRESS_PREVIOUS     ; //[nb_context]
  private   : Tcontrol_t                    * reg_CONTEXT_IS_DELAY_SLOT        ; //[nb_context]
//private   : Tcontrol_t                    * reg_CONTEXT_SAVE_RAT             ; //[nb_context]
  private   : Tcontrol_t                    * internal_CONTEXT_HAVE_TRANSACTION; //[nb_context]
  private   : Tgeneral_data_t               * internal_CONTEXT_ADDRESS_PREVIOUS; //[nb_context]
  private   : Tcontrol_t                    * internal_CONTEXT_IS_DELAY_SLOT   ; //[nb_context]
//private   : Tcontrol_t                    * internal_CONTEXT_SAVE_RAT        ; //[nb_context]

  private   : Tcontrol_t                    * internal_DECOD_VAL               ; //[nb_inst_decod]
    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  private   : decod_instruction_t           * _decod_instruction;
  private   : decod_param_t                ** _decod_param      ; //[nb_context]
  private   : function_decod_t           **** _function_decod   ; //[nb_context][type][opcod]
  private   : function_decod_t           **** _function_custom  ; //[nb_context][type][opcod]
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Decod);
#endif
  public  :          Decod              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Decod             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
  public  : void        genMealy                  (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace decod
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
