/*
 * $Id: Parameters_print.cpp 139 2010-07-30 14:47:27Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {


#undef  FUNCTION
#define FUNCTION "Rename_unit::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_begin(Rename_unit,FUNCTION);

    XML xml ("rename_unit");

    xml.balise_open("rename_unit");
    xml.singleton_begin("nb_front_end                     "); xml.attribut("value",toString(_nb_front_end                     )); xml.singleton_end();
    xml.singleton_begin("nb_inst_insert                   "); xml.attribut("value",toString(_nb_inst_insert                   )); xml.singleton_end();
    xml.singleton_begin("nb_inst_retire                   "); xml.attribut("value",toString(_nb_inst_retire                   )); xml.singleton_end();
    xml.singleton_begin("nb_load_store_queue              "); xml.attribut("value",toString(_nb_load_store_queue              )); xml.singleton_end();
    xml.singleton_begin("rename_select_priority           "); xml.attribut("value",toString(_rename_select_priority           )); xml.singleton_end();
    xml.singleton_begin("rename_select_load_balancing     "); xml.attribut("value",toString(_rename_select_load_balancing     )); xml.singleton_end();
    xml.singleton_begin("rename_select_nb_front_end_select"); xml.attribut("value",toString(_rename_select_nb_front_end_select)); xml.singleton_end();
    xml.singleton_begin("max_branch_speculated            "); xml.attribut("value",toString(_max_branch_speculated            )); xml.singleton_end();
    xml.singleton_begin("size_general_data                "); xml.attribut("value",toString(_size_general_data                )); xml.singleton_end();
    xml.singleton_begin("nb_general_register              "); xml.attribut("value",toString(_nb_general_register              )); xml.singleton_end();
    xml.singleton_begin("nb_special_register              "); xml.attribut("value",toString(_nb_special_register              )); xml.singleton_end();
    xml.singleton_begin("nb_reg_free                      "); xml.attribut("value",toString(_nb_reg_free                      )); xml.singleton_end();
    xml.singleton_begin("nb_bank                          "); xml.attribut("value",toString(_nb_bank                          )); xml.singleton_end();
//     xml.singleton_begin("size_read_counter                "); xml.attribut("value",toString(_size_read_counter                )); xml.singleton_end();

    for (uint32_t i=0;i<_nb_front_end; i++)
      {
        xml. balise_open_begin("component");
        xml.  attribut("type","front_end");
        xml.  attribut("id"  ,toString(i));
        xml. balise_open_end();
        xml.singleton_begin("nb_context                       "); xml.attribut("value",toString(_nb_context                       [i])); xml.singleton_end();
        xml.singleton_begin("nb_inst_decod                    "); xml.attribut("value",toString(_nb_inst_decod                    [i])); xml.singleton_end();
        
        for (uint32_t j=0;j<_nb_context[i]; j++)
          {
            xml. balise_open_begin("component");
            xml.  attribut("type","context");
            xml.  attribut("id"  ,toString(j));
            xml. balise_open_end();

            xml.singleton_begin("link_load_store_unit_with_thread "); xml.attribut("value",toString(_link_load_store_unit_with_thread [i][j])); xml.singleton_end();
            xml.singleton_begin("nb_branch_speculated             "); xml.attribut("value",toString(_nb_branch_speculated             [i][j])); xml.singleton_end();
            
            xml. balise_close();
          }

        xml. balise_close();
      }

    for (uint32_t i=0;i<_nb_load_store_queue; i++)
      {
        xml. balise_open_begin("component");
        xml.  attribut("type","load_store_queue");
        xml.  attribut("id"  ,toString(i));
        xml. balise_open_end();
        
        xml.singleton_begin("size_store_queue                 "); xml.attribut("value",toString(_size_store_queue                 [i])); xml.singleton_end();
        xml.singleton_begin("size_load_queue                  "); xml.attribut("value",toString(_size_load_queue                  [i])); xml.singleton_end();

        xml. balise_close();
      }

    xml.balise_close();

    log_end(Rename_unit,FUNCTION);
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Rename_unit::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::Parameters & x)
  {
    log_begin(Rename_unit,FUNCTION);

    output_stream << x.print(0);
    
    log_end(Rename_unit,FUNCTION);

    return output_stream;
  };

}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
