#ifndef Morpheo_Behavioural_Operation_h
#define Morpheo_Behavioural_Operation_h

/*
 * $Id: Operation.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

namespace morpheo {
namespace behavioural {

#define neg(size,data)             (~(data)+1)
#define sign(size,data)            ((data)>>(size-1))
#define unsigned(size,data)        (data)
#define signed(size,data)          ((sign(size,data)==0)?(data):neg(size,data))
#define ovf(size,op1, op2, res)    ((sign(size,op1) == sign(size,op2))?(sign(size,op1) xor sign(size,res)):0)
#define carry(size,op1, op2, res)  (((res)<(op1)) or ((res)<(op2)))
#define set_flag(data,flag,is_set) (((is_set)==1)?((data)|(flag)):((data)&~(flag)))
#define get_flag(data,flag)	   (((data)&(flag))!=0)
#define concatenation_bool(a,b)    (((a)<<1) | (b))

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
