#ifndef morpheo_behavioural_Parameters_test_h
#define morpheo_behavioural_Parameters_test_h

/*
 * $Id: Parameters_test.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"

namespace morpheo     {
namespace behavioural {

  template <typename T> bool test (uint32_t size) 
  {
    return (size <= (8*sizeof(T)));
  };

  class Parameters_test
  {
  private   : std::string _component;
  protected : std::string _error;
  protected : std::string _warning;
  protected : std::string _information;

  public    : Parameters_test (std::string component) 
    {
      _component = component;
      _error     = "";
      _warning   = "";
    };
  public    : ~Parameters_test (void) {};

  public    : bool        have_error  (void)            { return (_error.length() != 0);};
  public    : void        error       (std::string str) { _error       += MSG_ERROR      ; _error       += " <" + _component + "> " + str;}
  public    : void        warning     (std::string str) { _warning     += MSG_WARNING    ; _warning     += " <" + _component + "> " + str;}
  public    : void        information (std::string str) { _information += MSG_INFORMATION; _information += " <" + _component + "> " + str;}
  public    : std::string print       (void)            { return _error + _warning + _information;};
  };

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
