/*
 * $Id: Component_test_map.cpp 139 2010-07-30 14:47:27Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Component.h"
#include "Common/include/Tabulation.h"

namespace morpheo              {
namespace behavioural          {

#undef  FUNCTION
#define FUNCTION "Component::test_map"
  // bool Component::test_map (bool recursive)
  // {
  //   log_printf(INFO,Behavioural,FUNCTION, "Test port map and interface.");
  //   return test_map (0, recursive);
  // }

  bool Component::test_map (bool recursive)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    // std::string tab  = morpheo::tab(depth);
    std::string name = _entity->get_name();
    bool test_ok = true;

    bool is_behavioural = _list_component->empty ();
    // if (is_behavioural)
    //   {
    //     log_printf(INFO,Interface,FUNCTION, "%s* Component \"%s\" is a behavioural description",tab.c_str(),name.c_str());
    //   }
    // else
    //   {
    //     log_printf(INFO,Interface,FUNCTION, "%s* Component \"%s\" is a structural description",tab.c_str(),name.c_str());
    //   }

    
    // 	log_printf(INFO,Behavioural,FUNCTION, "%s* Test port I/O",tab.c_str());
    
    test_ok &= _entity->test_map(true,is_behavioural);
    
    // 	log_printf(INFO,Behavioural,FUNCTION, "%s* Test all internal component",tab.c_str());
	
    for (std::list<Tcomponent_t *>::iterator i= _list_component->begin();
	 i != _list_component->end();
	 ++i)
      if (((*i)->_instance & INSTANCE_COMPONENT) != 0)
        {
          test_ok &= (*i)->_entity->test_map(false,is_behavioural);
          if (recursive)
            try 
              {
                test_ok &= (*i)->_component->test_map(recursive);
              }
            catch (morpheo::ErrorMorpheo & error)
              {
                // no error propagation, only top level
              }
        }
    
    log_printf(FUNC,Behavioural,FUNCTION,"End");
    
    if (test_ok == false)
      throw (ERRORMORPHEO (FUNCTION,_("A lot of port is not connected.\n")));

    return test_ok;
  };

// #undef  FUNCTION
// #define FUNCTION "Component::test_equi"
//   bool Component::test_equi (bool recursive)
//   {
//     log_printf(INFO,Behavioural,FUNCTION, "Test port equi and interface.");
//     return test_equi (0, recursive);
//   }

//   bool Component::test_equi (uint32_t depth, bool recursive)
//   {
//     log_printf(FUNC,Behavioural,FUNCTION,"Begin");

//     std::string tab  = tab(depth);
//     std::string name = _entity->get_name();
//     bool test_ok = true;

//     test_ok &= _entity->test_equi(depth+1);

//     for (std::list<Tcomponent_t *>::iterator i= _list_component->begin();
// 	 i != _list_component->end();
// 	 ++i)
//       {
// 	test_ok &= (*i)->_entity->test_equi(depth+1);
// 	if (recursive)
// 	  try 
// 	    {
// 	      test_ok &= (*i)->_component->test_equi(depth+1,recursive);
// 	    }
// 	  catch (morpheo::ErrorMorpheo & error)
// 	    {
// 	      // no error propagation, only top level
// 	    }
//       }
    
//     log_printf(FUNC,Behavioural,FUNCTION,"End");
    
//     if (test_ok == false)
//       throw (ERRORMORPHEO (FUNCTION,_("A lot of port is not connected.\n")));

//     return test_ok;
//   };


}; // end namespace behavioural          
}; // end namespace morpheo              
