/********************************************
 * files               : asm_014_cmov.s
 * authors             : Rosiere Mathieu
 * date                : 2006/06/20
 ********************************************
 * input               : -
 * output              : 1 test OK
 *                       0 test KO
 ********************************************
 * test                :
 * warning             : instruction ok 
 *                         l.addi
 *                         l.and
 *                         l.jal
 *                         l.jr
 *			   l.lwz
 *                         l.or
 *                         l.ori
 *			   l.sfeq
 *			   l.sw
 ********************************************
 */
	.file	"asm_014_cmov.s"
	.section .text
	.align	4

	.global _asm_014_cmov
_asm_014_cmov :	
	/* save context */
	l.addi	r1,r1,-16
	l.sw	0 (r1),r20
	l.sw	4 (r1),r21
	l.sw	8 (r1),r22
	l.sw	12(r1),r23	
	/* Return is KO (default)*/
	l.and   r11,r0,r0

	l.and	r20,r0,r0
	l.movhi	r21,0x5555
	l.ori	r21,r21,0x5555
	l.movhi	r22,0xaaaa
	l.ori	r22,r22,0xaaaa

	/* set flag 1 */
	l.sfeq	r0,r0
	l.cmov	r20,r21,r0

	/* set flag 0 */
	l.sfne	r0,r0
	l.cmov	r23,r0,r22

	l.or	r20,r20,r23
	
	l.sfeqi	r20,-1
	l.bnf	_asm_014_cmov_ko
	l.nop	0
	
_asm_014_cmov_ok :	
	l.addi	r11,r0,1
_asm_014_cmov_ko :
	
	/* load context */
	l.lwz	r23,12(r1)
	l.lwz	r22,8 (r1)
	l.lwz	r21,4 (r1)
	l.lwz	r20,0 (r1)
	l.jr	r9
	l.addi	r1,r1,16
	