#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_write_unit_write_unit_execute_queue_Wrapper_Execute_queue_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_write_unit_write_unit_execute_queue_Wrapper_Execute_queue_h
/*
 * $Id: Wrapper_Execute_queue.h 136 2009-10-20 18:52:15Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "systemc.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue/include/Parameters.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue/include/Types.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/Environment.h"

#ifdef MODELSIM_COSIMULATION

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace execute_queue {

  class Wrapper_Execute_queue : public sc_foreign_module
  {
  protected : const Parameters * _param;

    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK             *  in_CLOCK ;
  public    : SC_IN   (Tcontrol_t) *  in_NRESET;

    // -----[ Interface "Execute_queue_in" ]------------------------------
  public    : SC_IN (Tcontrol_t     ) *  in_EXECUTE_QUEUE_IN_VAL           ;
  public    : SC_OUT(Tcontrol_t     ) * out_EXECUTE_QUEUE_IN_ACK           ;
  public    : SC_IN (Tcontext_t     ) *  in_EXECUTE_QUEUE_IN_CONTEXT_ID    ;
  public    : SC_IN (Tcontext_t     ) *  in_EXECUTE_QUEUE_IN_FRONT_END_ID  ;
  public    : SC_IN (Tcontext_t     ) *  in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID ;
  public    : SC_IN (Tpacket_t      ) *  in_EXECUTE_QUEUE_IN_PACKET_ID     ;
//public    : SC_IN (Toperation_t   ) *  in_EXECUTE_QUEUE_IN_OPERATION     ;
//public    : SC_IN (Ttype_t        ) *  in_EXECUTE_QUEUE_IN_TYPE          ;
  public    : SC_IN (Tcontrol_t     ) *  in_EXECUTE_QUEUE_IN_CANCEL        ;
  public    : SC_IN (Tspecial_data_t) *  in_EXECUTE_QUEUE_IN_FLAGS         ;
  public    : SC_IN (Texception_t   ) *  in_EXECUTE_QUEUE_IN_EXCEPTION     ;
  public    : SC_IN (Tcontrol_t     ) *  in_EXECUTE_QUEUE_IN_NO_SEQUENCE   ;
  public    : SC_IN (Taddress_t     ) *  in_EXECUTE_QUEUE_IN_ADDRESS       ;
  public    : SC_IN (Tgeneral_data_t) *  in_EXECUTE_QUEUE_IN_DATA          ;

    // -----[ Interface "Execute_queue_out" ]-----------------------------
  public    : SC_OUT(Tcontrol_t     ) * out_EXECUTE_QUEUE_OUT_VAL          ;
  public    : SC_IN (Tcontrol_t     ) *  in_EXECUTE_QUEUE_OUT_ACK          ;
  public    : SC_OUT(Tcontext_t     ) * out_EXECUTE_QUEUE_OUT_CONTEXT_ID   ;
  public    : SC_OUT(Tcontext_t     ) * out_EXECUTE_QUEUE_OUT_FRONT_END_ID ;
  public    : SC_OUT(Tcontext_t     ) * out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID;
  public    : SC_OUT(Tpacket_t      ) * out_EXECUTE_QUEUE_OUT_PACKET_ID    ;
//public    : SC_OUT(Toperation_t   ) * out_EXECUTE_QUEUE_OUT_OPERATION    ;
//public    : SC_OUT(Ttype_t        ) * out_EXECUTE_QUEUE_OUT_TYPE         ;
  public    : SC_OUT(Tcontrol_t     ) * out_EXECUTE_QUEUE_OUT_CANCEL       ;
  public    : SC_OUT(Tspecial_data_t) * out_EXECUTE_QUEUE_OUT_FLAGS        ;
  public    : SC_OUT(Texception_t   ) * out_EXECUTE_QUEUE_OUT_EXCEPTION    ;
  public    : SC_OUT(Tcontrol_t     ) * out_EXECUTE_QUEUE_OUT_NO_SEQUENCE  ;
  public    : SC_OUT(Taddress_t     ) * out_EXECUTE_QUEUE_OUT_ADDRESS      ;
  public    : SC_OUT(Tgeneral_data_t) * out_EXECUTE_QUEUE_OUT_DATA         ;

    // -----[ Methods ]---------------------------------------------------
  public  :  Wrapper_Execute_queue             
  (sc_module_name name_entity,
   std::string    name_architecture,
   std::string    name_library,
   const Parameters *   param
   ) :
    sc_foreign_module (name_entity, (toString(name_library+"."+toString(name_entity)+"("+name_architecture+")").c_str())),
    _param (param)
    {
      // caller affect interface signal

      ALLOC0_FOREIGN_SIGNAL_IN ( in_CLOCK                          ,""                 ,"clock"        ,Tcontrol_t        ,1                              );
      ALLOC0_FOREIGN_SIGNAL_IN ( in_NRESET                         ,""                 ,"nreset"       ,Tcontrol_t        ,1                              );

      ALLOC0_FOREIGN_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_VAL           ,"execute_queue_in" ,"val"          ,Tcontrol_t        ,1                              );         
      ALLOC0_FOREIGN_SIGNAL_OUT(out_EXECUTE_QUEUE_IN_ACK           ,"execute_queue_in" ,"ack"          ,Tcontrol_t        ,1                              );
      ALLOC0_FOREIGN_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_CONTEXT_ID    ,"execute_queue_in" ,"context_id"   ,Tcontext_t        ,_param->_size_context_id       );
      ALLOC0_FOREIGN_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_FRONT_END_ID  ,"execute_queue_in" ,"front_end_id" ,Tcontext_t        ,_param->_size_front_end_id     );
      ALLOC0_FOREIGN_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID ,"execute_queue_in" ,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id    );
      ALLOC0_FOREIGN_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_PACKET_ID     ,"execute_queue_in" ,"packet_id"    ,Tpacket_t         ,_param->_size_rob_ptr        );
//    ALLOC0_FOREIGN_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_OPERATION     ,"execute_queue_in" ,"operation"    ,Toperation_t      ,_param->_size_operation        );
//    ALLOC0_FOREIGN_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_TYPE          ,"execute_queue_in" ,"type"         ,Ttype_t           ,_param->_size_type             );
      ALLOC0_FOREIGN_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_CANCEL        ,"execute_queue_in" ,"cancel"       ,Tcontrol_t        ,1                              );
      ALLOC0_FOREIGN_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_FLAGS         ,"execute_queue_in" ,"flags"        ,Tspecial_data_t   ,_param->_size_special_data     );
      ALLOC0_FOREIGN_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_EXCEPTION     ,"execute_queue_in" ,"exception"    ,Texception_t      ,_param->_size_exception        );
      ALLOC0_FOREIGN_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_NO_SEQUENCE   ,"execute_queue_in" ,"no_sequence"  ,Tcontrol_t        ,1                              );
      ALLOC0_FOREIGN_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_ADDRESS       ,"execute_queue_in" ,"address"      ,Taddress_t        ,_param->_size_instruction_address);
      ALLOC0_FOREIGN_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_DATA          ,"execute_queue_in" ,"data"         ,Tgeneral_data_t   ,_param->_size_general_data     );

      ALLOC0_FOREIGN_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_VAL          ,"execute_queue_out","val"          ,Tcontrol_t        ,1                              );         
      ALLOC0_FOREIGN_SIGNAL_IN ( in_EXECUTE_QUEUE_OUT_ACK          ,"execute_queue_out","ack"          ,Tcontrol_t        ,1                              );         
      ALLOC0_FOREIGN_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_CONTEXT_ID   ,"execute_queue_out","context_id"   ,Tcontext_t        ,_param->_size_context_id   );
      ALLOC0_FOREIGN_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_FRONT_END_ID ,"execute_queue_out","front_end_id" ,Tcontext_t        ,_param->_size_front_end_id );
      ALLOC0_FOREIGN_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID,"execute_queue_out","ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id);
      ALLOC0_FOREIGN_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_PACKET_ID    ,"execute_queue_out","packet_id"    ,Tpacket_t         ,_param->_size_rob_ptr    );
//    ALLOC0_FOREIGN_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_OPERATION    ,"execute_queue_out","operation"    ,Toperation_t      ,_param->_size_operation    );
//    ALLOC0_FOREIGN_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_TYPE         ,"execute_queue_out","type"         ,Ttype_t           ,_param->_size_type         );
      ALLOC0_FOREIGN_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_CANCEL       ,"execute_queue_out","cancel"       ,Tcontrol_t        ,1                          );
      ALLOC0_FOREIGN_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_FLAGS        ,"execute_queue_out","flags"        ,Tspecial_data_t   ,_param->_size_special_data );
      ALLOC0_FOREIGN_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_EXCEPTION    ,"execute_queue_out","exception"    ,Texception_t      ,_param->_size_exception    );
      ALLOC0_FOREIGN_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_NO_SEQUENCE  ,"execute_queue_out","no_sequence"  ,Tcontrol_t        ,1                          );
      ALLOC0_FOREIGN_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_ADDRESS      ,"execute_queue_out","address"      ,Taddress_t        ,_param->_size_instruction_address);
      ALLOC0_FOREIGN_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_DATA         ,"execute_queue_out","data"         ,Tgeneral_data_t   ,_param->_size_general_data );

      elaborate_foreign_module((toString(name_library+"."+toString(name_entity)+"("+name_architecture+")").c_str()));
    }

  public  : ~Wrapper_Execute_queue (void)
    {
      DELETE0_FOREIGN_SIGNAL( in_CLOCK                          ,1                              );
      DELETE0_FOREIGN_SIGNAL( in_NRESET                         ,1                              );

      DELETE0_FOREIGN_SIGNAL( in_EXECUTE_QUEUE_IN_VAL           ,1                              );         
      DELETE0_FOREIGN_SIGNAL(out_EXECUTE_QUEUE_IN_ACK           ,1                              );
      DELETE0_FOREIGN_SIGNAL( in_EXECUTE_QUEUE_IN_CONTEXT_ID    ,_param->_size_context_id       );
      DELETE0_FOREIGN_SIGNAL( in_EXECUTE_QUEUE_IN_FRONT_END_ID  ,_param->_size_front_end_id     );
      DELETE0_FOREIGN_SIGNAL( in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID ,_param->_size_ooo_engine_id    );
      DELETE0_FOREIGN_SIGNAL( in_EXECUTE_QUEUE_IN_PACKET_ID     ,_param->_size_rob_ptr        );
//    DELETE0_FOREIGN_SIGNAL( in_EXECUTE_QUEUE_IN_OPERATION     ,_param->_size_operation        );
//    DELETE0_FOREIGN_SIGNAL( in_EXECUTE_QUEUE_IN_TYPE          ,_param->_size_type             );
      DELETE0_FOREIGN_SIGNAL( in_EXECUTE_QUEUE_IN_CANCEL        ,1                              );
      DELETE0_FOREIGN_SIGNAL( in_EXECUTE_QUEUE_IN_FLAGS         ,_param->_size_special_data     );
      DELETE0_FOREIGN_SIGNAL( in_EXECUTE_QUEUE_IN_EXCEPTION     ,_param->_size_exception        );
      DELETE0_FOREIGN_SIGNAL( in_EXECUTE_QUEUE_IN_NO_SEQUENCE   ,1                              );
      DELETE0_FOREIGN_SIGNAL( in_EXECUTE_QUEUE_IN_ADDRESS       ,_param->_size_instruction_address);
      DELETE0_FOREIGN_SIGNAL( in_EXECUTE_QUEUE_IN_DATA          ,_param->_size_general_data     );

      DELETE0_FOREIGN_SIGNAL(out_EXECUTE_QUEUE_OUT_VAL          ,1                              );         
      DELETE0_FOREIGN_SIGNAL( in_EXECUTE_QUEUE_OUT_ACK          ,1                              );         
      DELETE0_FOREIGN_SIGNAL(out_EXECUTE_QUEUE_OUT_CONTEXT_ID   ,_param->_size_context_id   );
      DELETE0_FOREIGN_SIGNAL(out_EXECUTE_QUEUE_OUT_FRONT_END_ID ,_param->_size_front_end_id );
      DELETE0_FOREIGN_SIGNAL(out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID,_param->_size_ooo_engine_id);
      DELETE0_FOREIGN_SIGNAL(out_EXECUTE_QUEUE_OUT_PACKET_ID    ,_param->_size_rob_ptr    );
//    DELETE0_FOREIGN_SIGNAL(out_EXECUTE_QUEUE_OUT_OPERATION    ,_param->_size_operation    );
//    DELETE0_FOREIGN_SIGNAL(out_EXECUTE_QUEUE_OUT_TYPE         ,_param->_size_type         );
      DELETE0_FOREIGN_SIGNAL(out_EXECUTE_QUEUE_OUT_CANCEL       ,1                          );
      DELETE0_FOREIGN_SIGNAL(out_EXECUTE_QUEUE_OUT_FLAGS        ,_param->_size_special_data );
      DELETE0_FOREIGN_SIGNAL(out_EXECUTE_QUEUE_OUT_EXCEPTION    ,_param->_size_exception    );
      DELETE0_FOREIGN_SIGNAL(out_EXECUTE_QUEUE_OUT_NO_SEQUENCE  ,1                          );
      DELETE0_FOREIGN_SIGNAL(out_EXECUTE_QUEUE_OUT_ADDRESS      ,_param->_size_instruction_address);
      DELETE0_FOREIGN_SIGNAL(out_EXECUTE_QUEUE_OUT_DATA         ,_param->_size_general_data );
    }
  };

}; // end namespace execute_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
#endif
