#ifdef VHDL
/*
 * $Id: Multiplier_vhdl_xilinx_body.cpp 116 2009-04-30 13:51:41Z moulu $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Multiplier/include/Multiplier.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace multiplier {

#undef  FUNCTION
#define FUNCTION "Multiplier::vhdl_xilinx_body"
  void Multiplier::vhdl_xilinx_body (Vhdl * & vhdl)
  {

    log_begin(Multiplier,FUNCTION);
    vhdl->set_body (0,"ins_mult_gen_v9_0 : mult_gen_v9_0");
    vhdl->set_body (1,"generic map (");
    vhdl->set_body (2,"  c_xdevicefamily => \"virtex4\",  -- specifies target Xilinx FPGA name");
    vhdl->set_body (2,"  c_a_width       => "+toString(_param->_size_data)+",         -- width of A port");
    vhdl->set_body (2,"  c_a_type        => "+toString(_param->_sign)+",          -- datatype of A port");
    vhdl->set_body (2,"  c_b_width       => "+toString(_param->_size_data)+",         -- width of B port");
    vhdl->set_body (2,"  c_b_type        => "+toString(_param->_sign)+",          -- datatype of B port");
    vhdl->set_body (2,"  c_out_high      => "+toString((_param->_size_data*2)-1)+",         -- MSB of P output port (N-1 downto 0 convention)");
    vhdl->set_body (2,"  c_mult_type     => 1,          -- Type of multiplier to implement");
    vhdl->set_body (2,"  c_opt_goal      => 1,          -- Optimization of multiplier");
    vhdl->set_body (2,"  c_has_ce        => 1,          -- Use clock enable on all registers");
    vhdl->set_body (2,"  c_pipe_stages   => "+toString(_param->_latency)+")          -- Number of register stages required");
    
    vhdl->set_body (1,"port map (");
    vhdl->set_body (2,"clk =>  in_CLOCK               ,");
    vhdl->set_body (2,"a   =>  in_MULTIPLIER_DATA_IN_0,");
    vhdl->set_body (2,"b   =>  in_MULTIPLIER_DATA_IN_1,");
    vhdl->set_body (2,"ce  =>  in_MULTIPLIER_NSTALL   ,");
    vhdl->set_body (2,"p   => sig_MULTIPLIER_DATA_OUT);");

    vhdl->set_body (0,"out_MULTIPLIER_DATA_LSB_OUT <= sig_MULTIPLIER_DATA_OUT("+toString(_param->_size_data-1)+" downto 0);");
    vhdl->set_body (0,"out_MULTIPLIER_DATA_MSB_OUT <= sig_MULTIPLIER_DATA_OUT("+toString((_param->_size_data*2)-1)+" downto "+toString(_param->_size_data)+");");

    log_end(Multiplier,FUNCTION);
  };

}; // end namespace multiplier
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
