#ifndef Morpheo_Time_h
#define Morpheo_Time_h

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <string>
#include <iostream>
#include <sys/time.h>
#include "Common/include/Systemc.h"
#include "Common/include/Message.h"

namespace morpheo {

class Time 
{
#ifdef SYSTEMC
private : const bool systemc;
private : double     nb_cycles_begin;
#endif
private : timeval    time_begin;
// private : timeval time_end;
  
public  : Time (bool systemc=true)
#ifdef SYSTEMC
  :
  systemc (systemc)
#endif
  { 
#ifdef SYSTEMC
    nb_cycles_begin = simulation_cycle();
#endif
    gettimeofday(&time_begin,NULL);
  };
  
public  : ~Time ()
  {
    std::cout << *this;
  };

public  : friend std::ostream& operator<< (std::ostream& output,
					   const Time & x)
  {
    timeval time_end;
    
    gettimeofday(&time_end,NULL);
    
#ifdef SYSTEMC
    if (x.systemc)
      {
        double nb_cycles_end = simulation_cycle();
        double average       = static_cast<double>(nb_cycles_end-x.nb_cycles_begin+1) / static_cast<double>(time_end.tv_sec-x.time_begin.tv_sec+1);
        
        output << "Timing : " << nb_cycles_end << " cycles \t(" << average << " cycles/s)" << std::endl;
      }
    else
#endif
      {
        double average       = static_cast<double>(time_end.tv_sec-x.time_begin.tv_sec+1);
        
        output << "Timing : " << average << " s" << std::endl;
      }

    return output;
  }
};

}; // end namespace morpheo

#endif
