#include "../include/Cache_OneLevel.h"

namespace environment {
namespace cache {
namespace cache_onelevel {

  uint32_t Cache_OneLevel::hit_cache (uint32_t trdid, Address address)
  {
    uint32_t num_associativity;
    for (num_associativity = 0; num_associativity < param->associativity; num_associativity ++)
      // Hit if :
      //  * in the line
      //  * in a way associative
      //  -> there are the same tag 
      //               the same trdid
      //               is valid
      if ( (tag [address.familly][num_associativity].address == address.tag) && 
	   (tag [address.familly][num_associativity].valid   == true       ) &&
	   (tag [address.familly][num_associativity].trdid   == trdid      ) )
	break;
    
    return num_associativity;
  }

};
};
};
