/*
 * $Id: Instance_fromFile.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Configuration/include/Instance.h"
#include "Common/include/FromString.h"
#include <fstream>

namespace morpheo {
namespace behavioural {
namespace configuration {

  using namespace XMLUtils;

#undef  FUNCTION
#define FUNCTION "Instance::fromFile"
  void Instance::fromFile (std::string filename)
  {
    log_begin(Configuration,FUNCTION);

    msg_printf(INFORMATION,_("Read file \"%s\"."),filename.c_str());

    std::ifstream file (filename.c_str());

    // Test the file open
    if (!file)
      throw ERRORMORPHEO(FUNCTION,toString(_("Error opening \"%s\" file.\n"),filename.c_str()));

    // 1) FILL _array
    XML_t * _xml = new FileXMLLight<char,ClassicReferenceCounter>(file);

    // Test root node : Root name, must not a singleton, have none attribute
    testNodeName   (_xml,"core");
    testSingleton  (_xml,false);

    attributes_t attributes = _xml->getAttributes();
    _name = getAttribute(_xml,attributes,"name" );

    fromXMLLight (_xml,
                  "",
                  _list_parameters,
                  _list_links,
                  _list_components);
    
    delete _xml;
    
    // 2) TEST/CREATE Parameters
    fromInternalStructure();
    
    log_end(Configuration,FUNCTION);
  };

}; // end namespace configuration
}; // end namespace behavioural
}; // end namespace morpheo              
