-------------------------------------------------------------------------------
-- File    : ./Functionnal_unit_0.vhdl
-- Date    : Fri Mar 13 16:20:01 2009
-- Version : 0.2.111 - Castor
-- Comment : it's a autogenerated file, don't modify
-------------------------------------------------------------------------------


library ieee;
  use ieee.numeric_bit.all;       
  use ieee.numeric_std.all;       
  use ieee.std_logic_1164.all;    
  use ieee.std_logic_arith.all;   
  use ieee.std_logic_misc.all;    
--use ieee.std_logic_signed.all;  
  use ieee.std_logic_unsigned.all;
--use ieee.std_logic_textio.all;  


library work;
use work.Functionnal_unit_0_Pack.all;
use work.Functionnal_unit_0_shifter_Pack.all;

Library XilinxCoreLib;
use XilinxCoreLib.c_compare_v9_0_comp.all;
use XilinxCoreLib.mult_gen_v9_0_comp.all;

entity Functionnal_unit_0 is
	port (
	in_CLOCK	: in     std_logic;
	in_NRESET	: in     std_logic;
	in_EXECUTE_IN_VAL	: in     std_logic;
	out_EXECUTE_IN_ACK	: out    std_logic;
	in_EXECUTE_IN_OOO_ENGINE_ID	: in     std_logic;
	in_EXECUTE_IN_PACKET_ID	: in     std_logic_vector(7 downto 0);
	in_EXECUTE_IN_OPERATION	: in     std_logic_vector(6 downto 0);
	in_EXECUTE_IN_TYPE	: in     std_logic_vector(4 downto 0);
	in_EXECUTE_IN_STORE_QUEUE_PTR_WRITE	: in     std_logic_vector(1 downto 0);
	in_EXECUTE_IN_HAS_IMMEDIAT	: in     std_logic;
	in_EXECUTE_IN_IMMEDIAT	: in     std_logic_vector(31 downto 0);
	in_EXECUTE_IN_DATA_RA	: in     std_logic_vector(31 downto 0);
	in_EXECUTE_IN_DATA_RB	: in     std_logic_vector(31 downto 0);
	in_EXECUTE_IN_DATA_RC	: in     std_logic_vector(1 downto 0);
	in_EXECUTE_IN_WRITE_RD	: in     std_logic;
	in_EXECUTE_IN_NUM_REG_RD	: in     std_logic_vector(4 downto 0);
	in_EXECUTE_IN_WRITE_RE	: in     std_logic;
	in_EXECUTE_IN_NUM_REG_RE	: in     std_logic_vector(3 downto 0);
	out_EXECUTE_OUT_VAL	: out    std_logic;
	in_EXECUTE_OUT_ACK	: in     std_logic;
	out_EXECUTE_OUT_OOO_ENGINE_ID	: out    std_logic;
	out_EXECUTE_OUT_PACKET_ID	: out    std_logic_vector(7 downto 0);
	out_EXECUTE_OUT_WRITE_RD	: out    std_logic;
	out_EXECUTE_OUT_NUM_REG_RD	: out    std_logic_vector(4 downto 0);
	out_EXECUTE_OUT_DATA_RD	: out    std_logic_vector(31 downto 0);
	out_EXECUTE_OUT_WRITE_RE	: out    std_logic;
	out_EXECUTE_OUT_NUM_REG_RE	: out    std_logic_vector(3 downto 0);
	out_EXECUTE_OUT_DATA_RE	: out    std_logic_vector(1 downto 0);
	out_EXECUTE_OUT_EXCEPTION	: out    std_logic_vector(4 downto 0);
	out_EXECUTE_OUT_NO_SEQUENCE	: out    std_logic;
	out_EXECUTE_OUT_ADDRESS	: out    std_logic_vector(29 downto 0)
	     );
end Functionnal_unit_0;

architecture behavioural of Functionnal_unit_0 is
	type Tmac	is array (1 downto 0) of std_logic_vector(31 downto 0);

	signal sig_EXECUTE_IN_ACK	: std_logic;
	signal reg_EXECUTE_IN_VAL	: std_logic;
	signal reg_EXECUTE_IN_OOO_ENGINE_ID	: std_logic;
	signal reg_EXECUTE_IN_PACKET_ID	: std_logic_vector(7 downto 0);
	signal reg_EXECUTE_IN_OPERATION	: std_logic_vector(6 downto 0);
	signal reg_EXECUTE_IN_TYPE	: std_logic_vector(4 downto 0);
	signal reg_EXECUTE_IN_HAS_IMMEDIAT	: std_logic;
	signal reg_EXECUTE_IN_IMMEDIAT	: std_logic_vector(31 downto 0);
	signal reg_EXECUTE_IN_DATA_RA	: std_logic_vector(31 downto 0);
	signal reg_EXECUTE_IN_DATA_RB	: std_logic_vector(31 downto 0);
	signal reg_EXECUTE_IN_DATA_RC	: std_logic_vector(1 downto 0);
	signal reg_EXECUTE_IN_WRITE_RD	: std_logic;
	signal reg_EXECUTE_IN_NUM_REG_RD	: std_logic_vector(4 downto 0);
	signal reg_EXECUTE_IN_WRITE_RE	: std_logic;
	signal reg_EXECUTE_IN_NUM_REG_RE	: std_logic_vector(3 downto 0);
	signal sig_B_OPERAND	: std_logic_vector(31 downto 0);
	signal sig_IS_ARITH	: std_logic;
	signal sig_IS_LOGIC	: std_logic;
	signal sig_CIN_ARITH	: std_logic;
	signal sig_ARITH_B_OPERAND	: std_logic_vector(31 downto 0);
	signal sig_RES_ARITH	: std_logic_vector(32 downto 0);
	signal sig_A_AND_B	: std_logic_vector(31 downto 0);
	signal sig_A_OR_B	: std_logic_vector(31 downto 0);
	signal sig_A_XOR_B	: std_logic_vector(31 downto 0);
	signal sig_RES_LOGIC	: std_logic_vector(31 downto 0);
	signal sig_RES_ALU	: std_logic_vector(31 downto 0);
	signal sig_OVR_ALU	: std_logic;
	signal sig_COUT_ALU	: std_logic;
	signal sig_RES_MOVE	: std_logic_vector(31 downto 0);
	signal sig_CMOV	: std_logic_vector(31 downto 0);
	signal sig_MOVHI	: std_logic_vector(31 downto 0);
	signal sig_RES_BRANCH	: std_logic_vector(31 downto 0);
	signal sig_ADDR_BRANCH	: std_logic_vector(29 downto 0);
	signal sig_NOSQ_BRANCH	: std_logic;
	signal sig_RES_SHIFTER	: std_logic_vector(31 downto 0);
	signal sig_EXT_BYTE_S	: std_logic_vector(31 downto 0);
	signal sig_EXT_BYTE_Z	: std_logic_vector(31 downto 0);
	signal sig_EXT_HALF_WORD_S	: std_logic_vector(31 downto 0);
	signal sig_EXT_HALF_WORD_Z	: std_logic_vector(31 downto 0);
	signal sig_EXT_WORD_S	: std_logic_vector(31 downto 0);
	signal sig_EXT_WORD_Z	: std_logic_vector(31 downto 0);
	signal sig_EXT_S	: std_logic_vector(31 downto 0);
	signal sig_EXT_Z	: std_logic_vector(31 downto 0);
	signal sig_RES_EXTEND	: std_logic_vector(31 downto 0);
	signal sig_FF1	: std_logic_vector(5 downto 0);
	signal sig_FL1	: std_logic_vector(5 downto 0);
	signal sig_RES_FIND	: std_logic_vector(31 downto 0);
	signal sig_SPR_IS_HERE	: std_logic;
	signal sig_MFSPR	: std_logic_vector(31 downto 0);
	signal sig_MTSPR	: std_logic_vector(31 downto 0);
	signal sig_RES_SPECIAL	: std_logic_vector(31 downto 0);
	signal sig_EXECUTE_OUT_VAL	: std_logic;
	signal sig_UPDATE	: std_logic;
	signal reg_EXECUTE_OUT_VAL	: std_logic;
	signal reg_EXECUTE_OUT_OOO_ENGINE_ID	: std_logic;
	signal sig_EXECUTE_OUT_OOO_ENGINE_ID	: std_logic;
	signal reg_EXECUTE_OUT_PACKET_ID	: std_logic_vector(7 downto 0);
	signal sig_EXECUTE_OUT_PACKET_ID	: std_logic_vector(7 downto 0);
	signal reg_EXECUTE_OUT_WRITE_RD	: std_logic;
	signal sig_EXECUTE_OUT_WRITE_RD	: std_logic;
	signal reg_EXECUTE_OUT_NUM_REG_RD	: std_logic_vector(4 downto 0);
	signal sig_EXECUTE_OUT_NUM_REG_RD	: std_logic_vector(4 downto 0);
	signal reg_EXECUTE_OUT_DATA_RD	: std_logic_vector(31 downto 0);
	signal sig_EXECUTE_OUT_DATA_RD	: std_logic_vector(31 downto 0);
	signal reg_EXECUTE_OUT_WRITE_RE	: std_logic;
	signal sig_EXECUTE_OUT_WRITE_RE	: std_logic;
	signal reg_EXECUTE_OUT_NUM_REG_RE	: std_logic_vector(3 downto 0);
	signal sig_EXECUTE_OUT_NUM_REG_RE	: std_logic_vector(3 downto 0);
	signal reg_EXECUTE_OUT_DATA_RE	: std_logic_vector(1 downto 0);
	signal sig_EXECUTE_OUT_DATA_RE	: std_logic_vector(1 downto 0);
	signal reg_EXECUTE_OUT_EXCEPTION	: std_logic_vector(4 downto 0);
	signal sig_EXECUTE_OUT_EXCEPTION	: std_logic_vector(4 downto 0);
	signal reg_EXECUTE_OUT_NO_SEQUENCE	: std_logic;
	signal sig_EXECUTE_OUT_NO_SEQUENCE	: std_logic;
	signal reg_EXECUTE_OUT_ADDRESS	: std_logic_vector(29 downto 0);
	signal sig_EXECUTE_OUT_ADDRESS	: std_logic_vector(29 downto 0);
	signal reg_MACLO             	: Tmac;
	signal reg_MACHI             	: Tmac;

        signal sig_VAL_5		: std_logic;
        signal sig_VAL_0		: std_logic;
        signal sig_NUM_REG_RE_0		: std_logic_vector(3 downto 0);
        signal sig_WRITE_RE_0		: std_logic;
        signal sig_NUM_REG_RD_0		: std_logic_vector(4 downto 0);
        signal sig_WRITE_RD_0		: std_logic;
        signal sig_TYPE_0		: std_logic_vector(4 downto 0);
        signal sig_PACKET_ID_0		: std_logic_vector(7 downto 0);
        signal sig_OOO_ENGINE_ID_0	: std_logic;

	signal sig_IS_LESS	: std_logic;
	signal sig_A_COMPARE	: std_logic_vector(31 downto 0);
	signal sig_B_COMPARE	: std_logic_vector(31 downto 0);
	signal sig_A_GT_B_S	: std_logic;
	signal sig_A_GT_B_U	: std_logic;
	signal sig_A_EQ_B	: std_logic;
	signal sig_A_GT_B	: std_logic;
	signal sig_A_GE_B	: std_logic;
	signal sig_A_NE_B	: std_logic;
	signal sig_IS_SIGNED	: std_logic;
	signal sig_FLAG_F	: std_logic;
	signal sig_BUSY		: std_logic;

	signal sig_FULL_RES_MUL 	: std_logic_vector (63 downto 0);
	signal sig_FULL_RES_MULU	: std_logic_vector (63 downto 0);
	signal sig_FULL_RES_MULS	: std_logic_vector (63 downto 0);
	signal sig_RES_MUL      	: std_logic_vector (31 downto 0);
	signal sig_COUT_MUL     	: std_logic;
	signal sig_OVR_MUL      	: std_logic;


	type TFQUEUE	is array (5 downto 0) of std_logic_vector(25 downto 0);
	-- OOO_ENGINE_ID(1) + PACKET_ID(8) + TYPE(5) + WRITE_RD(1) +
        -- NUM_REG_RD(5) + WRITE_RE(1) + NUM_REG_RE(4) + VALID(1) = 26 BITS
	signal reg_FUNCTIONAL_QUEUE            	: TFQUEUE;



	alias reg_OOO_ENGINE_ID_5	: std_logic	is reg_FUNCTIONAL_QUEUE(5)(25);
	alias reg_OOO_ENGINE_ID_4	: std_logic	is reg_FUNCTIONAL_QUEUE(4)(25);
	alias reg_OOO_ENGINE_ID_3	: std_logic	is reg_FUNCTIONAL_QUEUE(3)(25);
	alias reg_OOO_ENGINE_ID_2	: std_logic	is reg_FUNCTIONAL_QUEUE(2)(25);
	alias reg_OOO_ENGINE_ID_1	: std_logic	is reg_FUNCTIONAL_QUEUE(1)(25);
	alias reg_OOO_ENGINE_ID_0	: std_logic	is reg_FUNCTIONAL_QUEUE(0)(25);
	alias reg_PACKET_ID_5   	: std_logic_vector(7 downto 0)	is reg_FUNCTIONAL_QUEUE(5)(24 downto 17);
	alias reg_PACKET_ID_4   	: std_logic_vector(7 downto 0)	is reg_FUNCTIONAL_QUEUE(4)(24 downto 17);
	alias reg_PACKET_ID_3   	: std_logic_vector(7 downto 0)	is reg_FUNCTIONAL_QUEUE(3)(24 downto 17);
	alias reg_PACKET_ID_2   	: std_logic_vector(7 downto 0)	is reg_FUNCTIONAL_QUEUE(2)(24 downto 17);
	alias reg_PACKET_ID_1   	: std_logic_vector(7 downto 0)	is reg_FUNCTIONAL_QUEUE(1)(24 downto 17);
	alias reg_PACKET_ID_0   	: std_logic_vector(7 downto 0)	is reg_FUNCTIONAL_QUEUE(0)(24 downto 17);
	alias reg_TYPE_5        	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(5)(16 downto 12);
	alias reg_TYPE_4        	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(4)(16 downto 12);
	alias reg_TYPE_3        	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(3)(16 downto 12);
	alias reg_TYPE_2        	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(2)(16 downto 12);
	alias reg_TYPE_1        	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(1)(16 downto 12);
	alias reg_TYPE_0        	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(0)(16 downto 12);
	alias reg_WRITE_RD_5    	: std_logic	is reg_FUNCTIONAL_QUEUE(5)(11);
	alias reg_WRITE_RD_4    	: std_logic	is reg_FUNCTIONAL_QUEUE(4)(11);
	alias reg_WRITE_RD_3    	: std_logic	is reg_FUNCTIONAL_QUEUE(3)(11);
	alias reg_WRITE_RD_2    	: std_logic	is reg_FUNCTIONAL_QUEUE(2)(11);
	alias reg_WRITE_RD_1    	: std_logic	is reg_FUNCTIONAL_QUEUE(1)(11);
	alias reg_WRITE_RD_0    	: std_logic	is reg_FUNCTIONAL_QUEUE(0)(11);
	alias reg_NUM_REG_RD_5  	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(5)(10 downto 6);
	alias reg_NUM_REG_RD_4  	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(4)(10 downto 6);
	alias reg_NUM_REG_RD_3  	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(3)(10 downto 6);
	alias reg_NUM_REG_RD_2  	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(2)(10 downto 6);
	alias reg_NUM_REG_RD_1  	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(1)(10 downto 6);
	alias reg_NUM_REG_RD_0  	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(0)(10 downto 6);
	alias reg_WRITE_RE_5    	: std_logic	is reg_FUNCTIONAL_QUEUE(5)(5);
	alias reg_WRITE_RE_4    	: std_logic	is reg_FUNCTIONAL_QUEUE(4)(5);
	alias reg_WRITE_RE_3    	: std_logic	is reg_FUNCTIONAL_QUEUE(3)(5);
	alias reg_WRITE_RE_2    	: std_logic	is reg_FUNCTIONAL_QUEUE(2)(5);
	alias reg_WRITE_RE_1    	: std_logic	is reg_FUNCTIONAL_QUEUE(1)(5);
	alias reg_WRITE_RE_0    	: std_logic	is reg_FUNCTIONAL_QUEUE(0)(5);
	alias reg_NUM_REG_RE_5  	: std_logic_vector(3 downto 0)	is reg_FUNCTIONAL_QUEUE(5)(4 downto 1);
	alias reg_NUM_REG_RE_4  	: std_logic_vector(3 downto 0)	is reg_FUNCTIONAL_QUEUE(4)(4 downto 1);
	alias reg_NUM_REG_RE_3  	: std_logic_vector(3 downto 0)	is reg_FUNCTIONAL_QUEUE(3)(4 downto 1);
	alias reg_NUM_REG_RE_2  	: std_logic_vector(3 downto 0)	is reg_FUNCTIONAL_QUEUE(2)(4 downto 1);
	alias reg_NUM_REG_RE_1  	: std_logic_vector(3 downto 0)	is reg_FUNCTIONAL_QUEUE(1)(4 downto 1);
	alias reg_NUM_REG_RE_0  	: std_logic_vector(3 downto 0)	is reg_FUNCTIONAL_QUEUE(0)(4 downto 1);
	alias reg_VAL_5         	: std_logic	is reg_FUNCTIONAL_QUEUE(5)(0);
	alias reg_VAL_4         	: std_logic	is reg_FUNCTIONAL_QUEUE(4)(0);
	alias reg_VAL_3         	: std_logic	is reg_FUNCTIONAL_QUEUE(3)(0);
	alias reg_VAL_2         	: std_logic	is reg_FUNCTIONAL_QUEUE(2)(0);
	alias reg_VAL_1         	: std_logic	is reg_FUNCTIONAL_QUEUE(1)(0);
	alias reg_VAL_0         	: std_logic	is reg_FUNCTIONAL_QUEUE(0)(0);

begin
	
	-- 
	-- -----------------------------------
	-- -- Registers                       
	-- -----------------------------------
	-- 

	process (in_CLOCK)
	begin
          if in_CLOCK'event and in_CLOCK = '1' then
            if (in_NRESET = '0') then
              reg_EXECUTE_IN_VAL <= '0';
              reg_EXECUTE_OUT_VAL <= '0';
              reg_FUNCTIONAL_QUEUE(0) <= (others => '0');
              reg_FUNCTIONAL_QUEUE(1) <= (others => '0');
              reg_FUNCTIONAL_QUEUE(2) <= (others => '0');
              reg_FUNCTIONAL_QUEUE(3) <= (others => '0');
              reg_FUNCTIONAL_QUEUE(4) <= (others => '0');
              reg_FUNCTIONAL_QUEUE(5) <= (others => '0');
            else
              -- Input
              if (sig_EXECUTE_IN_ACK = '1') then
                reg_EXECUTE_IN_VAL           <= in_EXECUTE_IN_VAL;
                reg_EXECUTE_IN_NUM_REG_RE    <= in_EXECUTE_IN_NUM_REG_RE;
                reg_EXECUTE_IN_WRITE_RE      <= in_EXECUTE_IN_WRITE_RE;
                reg_EXECUTE_IN_NUM_REG_RD    <= in_EXECUTE_IN_NUM_REG_RD;
                reg_EXECUTE_IN_WRITE_RD      <= in_EXECUTE_IN_WRITE_RD;
                reg_EXECUTE_IN_DATA_RC       <= in_EXECUTE_IN_DATA_RC;
                reg_EXECUTE_IN_DATA_RB       <= in_EXECUTE_IN_DATA_RB;
                reg_EXECUTE_IN_DATA_RA       <= in_EXECUTE_IN_DATA_RA;
                reg_EXECUTE_IN_IMMEDIAT      <= in_EXECUTE_IN_IMMEDIAT;
                reg_EXECUTE_IN_HAS_IMMEDIAT  <= in_EXECUTE_IN_HAS_IMMEDIAT;
                reg_EXECUTE_IN_TYPE          <= in_EXECUTE_IN_TYPE;
                reg_EXECUTE_IN_OPERATION     <= in_EXECUTE_IN_OPERATION;
                reg_EXECUTE_IN_PACKET_ID     <= in_EXECUTE_IN_PACKET_ID;
                reg_EXECUTE_IN_OOO_ENGINE_ID <= in_EXECUTE_IN_OOO_ENGINE_ID;

                -- Pipeline
                if (in_EXECUTE_IN_TYPE = "00100") then
                  reg_VAL_5           <= in_EXECUTE_IN_VAL;
                  reg_NUM_REG_RE_5    <= in_EXECUTE_IN_NUM_REG_RE;
                  reg_WRITE_RE_5      <= in_EXECUTE_IN_WRITE_RE;
                  reg_NUM_REG_RD_5    <= in_EXECUTE_IN_NUM_REG_RD;
                  reg_WRITE_RD_5      <= in_EXECUTE_IN_WRITE_RD;
                  reg_TYPE_5          <= in_EXECUTE_IN_TYPE;
                  reg_PACKET_ID_5     <= in_EXECUTE_IN_PACKET_ID;
                  reg_OOO_ENGINE_ID_5 <= in_EXECUTE_IN_OOO_ENGINE_ID;

                  reg_VAL_0           <= reg_VAL_1;
                  reg_NUM_REG_RE_0    <= reg_NUM_REG_RE_1;
                  reg_WRITE_RE_0      <= reg_WRITE_RE_1;
                  reg_NUM_REG_RD_0    <= reg_NUM_REG_RD_1;
                  reg_WRITE_RD_0      <= reg_WRITE_RD_1;
                  reg_TYPE_0          <= reg_TYPE_1;
                  reg_PACKET_ID_0     <= reg_PACKET_ID_1;
                  reg_OOO_ENGINE_ID_0 <= reg_OOO_ENGINE_ID_1;

                else
                  reg_VAL_0           <= in_EXECUTE_IN_VAL;
                  reg_NUM_REG_RE_0    <= in_EXECUTE_IN_NUM_REG_RE;
                  reg_WRITE_RE_0      <= in_EXECUTE_IN_WRITE_RE;
                  reg_NUM_REG_RD_0    <= in_EXECUTE_IN_NUM_REG_RD;
                  reg_WRITE_RD_0      <= in_EXECUTE_IN_WRITE_RD;
                  reg_TYPE_0          <= in_EXECUTE_IN_TYPE;
                  reg_PACKET_ID_0     <= in_EXECUTE_IN_PACKET_ID;
                  reg_OOO_ENGINE_ID_0 <= in_EXECUTE_IN_OOO_ENGINE_ID;
                end if;
              end if;
              if (sig_UPDATE = '1') then

                reg_VAL_1           <= reg_VAL_2;
                reg_NUM_REG_RE_1    <= reg_NUM_REG_RE_2;
                reg_WRITE_RE_1      <= reg_WRITE_RE_2;
                reg_NUM_REG_RD_1    <= reg_NUM_REG_RD_2;
                reg_WRITE_RD_1      <= reg_WRITE_RD_2;
                reg_TYPE_1          <= reg_TYPE_2;
                reg_PACKET_ID_1     <= reg_PACKET_ID_2;
                reg_OOO_ENGINE_ID_1 <= reg_OOO_ENGINE_ID_2;

                reg_VAL_2           <= reg_VAL_3;
                reg_NUM_REG_RE_2    <= reg_NUM_REG_RE_3;
                reg_WRITE_RE_2      <= reg_WRITE_RE_3;
                reg_NUM_REG_RD_2    <= reg_NUM_REG_RD_3;
                reg_WRITE_RD_2      <= reg_WRITE_RD_3;
                reg_TYPE_2          <= reg_TYPE_3;
                reg_PACKET_ID_2     <= reg_PACKET_ID_3;
                reg_OOO_ENGINE_ID_2 <= reg_OOO_ENGINE_ID_3;

                reg_VAL_3           <= reg_VAL_4;
                reg_NUM_REG_RE_3    <= reg_NUM_REG_RE_4;
                reg_WRITE_RE_3      <= reg_WRITE_RE_4;
                reg_NUM_REG_RD_3    <= reg_NUM_REG_RD_4;
                reg_WRITE_RD_3      <= reg_WRITE_RD_4;
                reg_TYPE_3          <= reg_TYPE_4;
                reg_PACKET_ID_3     <= reg_PACKET_ID_4;
                reg_OOO_ENGINE_ID_3 <= reg_OOO_ENGINE_ID_4;

                reg_VAL_4           <= reg_VAL_5;
                reg_NUM_REG_RE_4    <= reg_NUM_REG_RE_5;
                reg_WRITE_RE_4      <= reg_WRITE_RE_5;
                reg_NUM_REG_RD_4    <= reg_NUM_REG_RD_5;
                reg_WRITE_RD_4      <= reg_WRITE_RD_5;
                reg_TYPE_4          <= reg_TYPE_5;
                reg_PACKET_ID_4     <= reg_PACKET_ID_5;
                reg_OOO_ENGINE_ID_4 <= reg_OOO_ENGINE_ID_5;

                -- Output
                reg_EXECUTE_OUT_VAL <= reg_VAL_0;
                reg_EXECUTE_OUT_OOO_ENGINE_ID <= sig_EXECUTE_OUT_OOO_ENGINE_ID;
                reg_EXECUTE_OUT_PACKET_ID <= sig_EXECUTE_OUT_PACKET_ID;
                reg_EXECUTE_OUT_WRITE_RD <=  sig_EXECUTE_OUT_WRITE_RD;
                reg_EXECUTE_OUT_NUM_REG_RD <= sig_EXECUTE_OUT_NUM_REG_RD;
                reg_EXECUTE_OUT_DATA_RD <= sig_EXECUTE_OUT_DATA_RD;
                reg_EXECUTE_OUT_WRITE_RE <= sig_EXECUTE_OUT_WRITE_RE;
                reg_EXECUTE_OUT_NUM_REG_RE <= sig_EXECUTE_OUT_NUM_REG_RE;
                reg_EXECUTE_OUT_DATA_RE <= sig_EXECUTE_OUT_DATA_RE;
                reg_EXECUTE_OUT_EXCEPTION <= sig_EXECUTE_OUT_EXCEPTION;
                reg_EXECUTE_OUT_NO_SEQUENCE <= sig_EXECUTE_OUT_NO_SEQUENCE;
                reg_EXECUTE_OUT_ADDRESS <= sig_EXECUTE_OUT_ADDRESS;
              end if;
            end if;
          end if;
	end process;
	
	-- 
	-- -----------------------------------
	-- -- Insides                         
	-- -----------------------------------
	-- 
	
--	sig_VAL_0 <= in_EXECUTE_IN_VAL when (sig_EXECUTE_IN_ACK = '1' and in_EXECUTE_IN_TYPE /= "00100") else
--		reg_VAL_1;
--	sig_NUM_REG_RE_0 <= in_EXECUTE_IN_NUM_REG_RE when (sig_EXECUTE_IN_ACK = '1' and in_EXECUTE_IN_TYPE /= "00100") else
--		reg_NUM_REG_RE_1;
--	sig_WRITE_RE_0 <= in_EXECUTE_IN_WRITE_RE when (sig_EXECUTE_IN_ACK = '1' and in_EXECUTE_IN_TYPE /= "00100") else
--		reg_WRITE_RE_1;
--	sig_NUM_REG_RD_0 <= in_EXECUTE_IN_NUM_REG_RD when (sig_EXECUTE_IN_ACK = '1' and in_EXECUTE_IN_TYPE /= "00100") else
--		reg_NUM_REG_RD_1;
--	sig_WRITE_RD_0 <= in_EXECUTE_IN_WRITE_RD when (sig_EXECUTE_IN_ACK = '1' and in_EXECUTE_IN_TYPE /= "00100") else
--		reg_WRITE_RD_1;
--	sig_TYPE_0 <= in_EXECUTE_IN_TYPE when (sig_EXECUTE_IN_ACK = '1' and in_EXECUTE_IN_TYPE /= "00100") else
--		reg_TYPE_1;
--	sig_PACKET_ID_0 <= in_EXECUTE_IN_PACKET_ID when (sig_EXECUTE_IN_ACK = '1' and in_EXECUTE_IN_TYPE /= "00100") else
--		reg_PACKET_ID_1;
--	sig_OOO_ENGINE_ID_0 <= in_EXECUTE_IN_OOO_ENGINE_ID when (sig_EXECUTE_IN_ACK = '1' and in_EXECUTE_IN_TYPE /= "00100") else
--		reg_OOO_ENGINE_ID_1;

--	sig_VAL_5 <= reg_EXECUTE_IN_VAL when (reg_EXECUTE_IN_TYPE = "00100") else
--		'0';

	sig_B_OPERAND <= reg_EXECUTE_IN_IMMEDIAT when (reg_EXECUTE_IN_HAS_IMMEDIAT = '1') else
		reg_EXECUTE_IN_DATA_RB;
	-- 
	-- ALU
	-- 
	sig_IS_ARITH <= reg_EXECUTE_IN_OPERATION(0) or reg_EXECUTE_IN_OPERATION(1) or reg_EXECUTE_IN_OPERATION(2);
	sig_IS_LOGIC <= reg_EXECUTE_IN_OPERATION(3) or reg_EXECUTE_IN_OPERATION(4) or reg_EXECUTE_IN_OPERATION(5);
	sig_CIN_ARITH <= reg_EXECUTE_IN_DATA_RC(1) and reg_EXECUTE_IN_OPERATION(1);
	sig_ARITH_B_OPERAND <= ((not sig_B_OPERAND) + 1) when (reg_EXECUTE_IN_OPERATION(2) = '1') else
		sig_B_OPERAND;
	sig_RES_ARITH <= ('0' & reg_EXECUTE_IN_DATA_RA) + ('0' & sig_ARITH_B_OPERAND) + ("000000000000000000000000000000" & sig_CIN_ARITH);
	
	sig_A_AND_B <= reg_EXECUTE_IN_DATA_RA and sig_B_OPERAND;
	sig_A_OR_B <= reg_EXECUTE_IN_DATA_RA or sig_B_OPERAND;
	sig_A_XOR_B <= reg_EXECUTE_IN_DATA_RA xor sig_B_OPERAND;
	
	with reg_EXECUTE_IN_OPERATION select
	sig_RES_LOGIC <=
		sig_A_AND_B when "0001000",
		sig_A_OR_B  when "0010000",
		sig_A_XOR_B when "0100000",
		"00000000000000000000000000000000" when others;
	sig_RES_ALU <=
		sig_RES_ARITH (31 downto 0) when (sig_IS_ARITH = '1') else
		sig_RES_LOGIC when (sig_IS_LOGIC = '1') else
		"00000000000000000000000000000000";
	
	-- In ISA l.sub doesn't change carry flag.
	sig_COUT_ALU <= (sig_RES_ARITH(32) and (reg_EXECUTE_IN_OPERATION(0) or reg_EXECUTE_IN_OPERATION(1))) or (reg_EXECUTE_IN_OPERATION(2) and reg_EXECUTE_IN_DATA_RC(1));
	sig_OVR_ALU <= ((sig_ARITH_B_OPERAND(31) and reg_EXECUTE_IN_DATA_RA(31) and not sig_RES_ARITH(31)) or (not sig_ARITH_B_OPERAND(31) and not reg_EXECUTE_IN_DATA_RA(31) and sig_RES_ARITH(31))) and sig_IS_ARITH;
	
	-- 
	-- MOVE
	-- 
	sig_MOVHI <= reg_EXECUTE_IN_IMMEDIAT(15 downto 0) & "0000000000000000";
	sig_CMOV <=
		reg_EXECUTE_IN_DATA_RA when (reg_EXECUTE_IN_DATA_RC(0) = '1') else
		reg_EXECUTE_IN_DATA_RB;
	sig_RES_MOVE <=
		sig_MOVHI when (reg_EXECUTE_IN_OPERATION(0) = '1') else
		sig_CMOV when (reg_EXECUTE_IN_OPERATION(1) = '1') else
		"00000000000000000000000000000000";
	
	-- 
	-- TEST
	-- 
	sig_IS_LESS <= reg_EXECUTE_IN_OPERATION(3);
	sig_A_COMPARE <=
		sig_B_OPERAND when (sig_IS_LESS = '1') else
		reg_EXECUTE_IN_DATA_RA;

	sig_B_COMPARE <=
		reg_EXECUTE_IN_DATA_RA when (sig_IS_LESS = '1') else
		sig_B_OPERAND;

	a_gt_b_s : c_compare_v9_0
	  generic map (
	    c_width      => 32,
	    c_data_type  => 0,                -- 0 = signed, 1 = unsigned
	    c_has_a_eq_b => 0,
	    c_has_a_gt_b => 1)
	  port map (
	    a => sig_A_COMPARE,
	    b => sig_B_COMPARE,
	    a_gt_b => sig_A_GT_B_S);

	a_gt_b_u : c_compare_v9_0
	  generic map (
	    c_width      => 32,
	    c_data_type  => 1,                -- 0 = signed, 1 = unsigned
	    c_has_a_eq_b => 0,
	    c_has_a_gt_b => 1)
	  port map (
	    a => sig_A_COMPARE,
	    b => sig_B_COMPARE,
	    a_gt_b => sig_A_GT_B_U);

	a_eq_b : c_compare_v9_0
	  generic map (                       -- sign doesn't matter for
                                              -- equality test
	    c_width      => 32,
	    c_has_a_eq_b => 1,
	    c_has_a_gt_b => 0)
	  port map (
	    a => sig_A_COMPARE,
	    b => sig_B_COMPARE,
	    a_eq_b => sig_A_EQ_B);

	sig_IS_SIGNED <= reg_EXECUTE_IN_OPERATION(6);
	sig_A_GT_B <=
		sig_A_GT_B_S when (sig_IS_SIGNED = '1') else
		sig_A_GT_B_U;
	sig_A_GE_B <= sig_A_GT_B or sig_A_EQ_B;
	sig_A_NE_B <= not sig_A_EQ_B;
	
	sig_FLAG_F <=
		(sig_A_EQ_B and reg_EXECUTE_IN_OPERATION(4)) or
		(sig_A_NE_B and reg_EXECUTE_IN_OPERATION(5)) or
		(sig_A_GE_B and reg_EXECUTE_IN_OPERATION(0)) or
		(sig_A_GT_B and reg_EXECUTE_IN_OPERATION(1));
	
	-- 
	-- MULT
	-- 
	signed_multiplier : mult_gen_v9_0
	  generic map (
            c_xdevicefamily => "virtex4",  -- specifies target Xilinx FPGA name
            c_a_width       => 32,         -- width of A port
            c_a_type        => 0,          -- datatype of A port
            c_b_width       => 32,         -- width of B port
            c_b_type        => 0,          -- datatype of B port
            c_out_high      => 63,         -- MSB of P output port (N-1 downto 0 convention)
            c_mult_type     => 1,          -- Type of multiplier to implement
            c_opt_goal      => 1,          -- Optimization of multiplier
            c_has_ce        => 1,          -- Use clock enable on all registers
            c_pipe_stages   => 6           -- Number of register stages required
            )
	  port map (
            clk => in_CLOCK,
            a   => reg_EXECUTE_IN_DATA_RA,
            b   => sig_B_OPERAND,
            ce  => sig_UPDATE,
            p   => sig_FULL_RES_MULS
            );

	unsigned_multiplier : mult_gen_v9_0
	  generic map (
            c_xdevicefamily => "virtex4",  -- specifies target Xilinx FPGA name
            c_a_width       => 32,         -- width of A port
            c_a_type        => 1,          -- datatype of A port
            c_b_width       => 32,         -- width of B port
            c_b_type        => 1,          -- datatype of B port
            c_out_high      => 63,         -- MSB of P output port (N-1 downto 0 convention)
            c_mult_type     => 1,          -- Type of multiplier to implement
            c_opt_goal      => 1,          -- Optimization of multiplier
            c_has_ce        => 1,          -- Use clock enable on all registers
            c_pipe_stages   => 6           -- Number of register stages required
            )
	  port map (
            clk => in_CLOCK,
            a   => reg_EXECUTE_IN_DATA_RA,
            b   => sig_B_OPERAND,
            ce  => sig_UPDATE,
            p   => sig_FULL_RES_MULU
            );

	sig_FULL_RES_MUL <=
		sig_FULL_RES_MULS when (reg_EXECUTE_IN_OPERATION(0) = '1') else
		sig_FULL_RES_MULU;

        sig_RES_MUL <= sig_FULL_RES_MUL (31 downto 0);

        sig_COUT_MUL <= sig_FULL_RES_MUL(63) or sig_FULL_RES_MUL(62) or sig_FULL_RES_MUL(61) or sig_FULL_RES_MUL(60) or
                        sig_FULL_RES_MUL(59) or sig_FULL_RES_MUL(58) or sig_FULL_RES_MUL(57) or sig_FULL_RES_MUL(56) or
                        sig_FULL_RES_MUL(55) or sig_FULL_RES_MUL(54) or sig_FULL_RES_MUL(53) or sig_FULL_RES_MUL(52) or
                        sig_FULL_RES_MUL(51) or sig_FULL_RES_MUL(50) or sig_FULL_RES_MUL(49) or sig_FULL_RES_MUL(48) or
                        sig_FULL_RES_MUL(47) or sig_FULL_RES_MUL(46) or sig_FULL_RES_MUL(45) or sig_FULL_RES_MUL(44) or
                        sig_FULL_RES_MUL(43) or sig_FULL_RES_MUL(42) or sig_FULL_RES_MUL(41) or sig_FULL_RES_MUL(40) or
                        sig_FULL_RES_MUL(39) or sig_FULL_RES_MUL(38) or sig_FULL_RES_MUL(37) or sig_FULL_RES_MUL(36) or
                        sig_FULL_RES_MUL(35) or sig_FULL_RES_MUL(34) or sig_FULL_RES_MUL(33) or sig_FULL_RES_MUL(32);

        sig_OVR_MUL <= sig_COUT_MUL;

	-- 
	-- BRANCH
	-- 
	sig_NOSQ_BRANCH <= (reg_EXECUTE_IN_DATA_RC(0) and reg_EXECUTE_IN_OPERATION(2)) or (not reg_EXECUTE_IN_DATA_RC(0) and reg_EXECUTE_IN_OPERATION(1)) or reg_EXECUTE_IN_OPERATION(3);
	sig_RES_BRANCH <=
		reg_EXECUTE_IN_IMMEDIAT(29 downto 0) & "00"when (reg_EXECUTE_IN_OPERATION(3) = '1') else
		"00000000000000000000000000000000";
	sig_ADDR_BRANCH <=
		reg_EXECUTE_IN_DATA_RB(31 downto 2) when (reg_EXECUTE_IN_OPERATION(3) = '1') else
		reg_EXECUTE_IN_IMMEDIAT(29 downto 0);
	
	-- 
	-- SHIFTER
	-- 
	-- Instance shifter
	instance_Functionnal_unit_0_shifter : Functionnal_unit_0_shifter
	port map (
		  in_SHIFTER_0_DATA      	=>	reg_EXECUTE_IN_DATA_RA
		, in_SHIFTER_0_SHIFT     	=>	sig_B_OPERAND(4 downto 0)
		, in_SHIFTER_0_DIRECTION 	=>	reg_EXECUTE_IN_OPERATION(0)
		, in_SHIFTER_0_TYPE      	=>	reg_EXECUTE_IN_OPERATION(1)
		, in_SHIFTER_0_CARRY     	=>	reg_EXECUTE_IN_OPERATION(2)
		,out_SHIFTER_0_DATA      	=>	sig_RES_SHIFTER
	);
	
	
	-- 
	-- EXTEND
	-- 
	sig_EXT_BYTE_S <=
		"111111111111111111111111" & reg_EXECUTE_IN_DATA_RA (7 downto 0) when (reg_EXECUTE_IN_DATA_RA (7) = '1') else
		"000000000000000000000000" & reg_EXECUTE_IN_DATA_RA (7 downto 0);
	
	sig_EXT_BYTE_Z <=
		"000000000000000000000000" & reg_EXECUTE_IN_DATA_RA (7 downto 0);
	
	sig_EXT_HALF_WORD_S <=
		"1111111111111111" & reg_EXECUTE_IN_DATA_RA (15 downto 0) when (reg_EXECUTE_IN_DATA_RA (15) = '1') else
		"0000000000000000" & reg_EXECUTE_IN_DATA_RA (15 downto 0);
	
	sig_EXT_HALF_WORD_Z <=
		"0000000000000000" & reg_EXECUTE_IN_DATA_RA (15 downto 0);
	
	sig_EXT_WORD_S <=
		"" & reg_EXECUTE_IN_DATA_RA (31 downto 0) when (reg_EXECUTE_IN_DATA_RA (31) = '1') else
		"" & reg_EXECUTE_IN_DATA_RA (31 downto 0);
	
	sig_EXT_WORD_Z <=
		"" & reg_EXECUTE_IN_DATA_RA (31 downto 0);
	
	sig_EXT_S <=
		sig_EXT_BYTE_S      when (reg_EXECUTE_IN_IMMEDIAT = 8)  else
		sig_EXT_HALF_WORD_S when (reg_EXECUTE_IN_IMMEDIAT = 16) else
		sig_EXT_WORD_S;
	
	sig_EXT_Z <=
		sig_EXT_BYTE_Z      when (reg_EXECUTE_IN_IMMEDIAT = 8)  else
		sig_EXT_HALF_WORD_Z when (reg_EXECUTE_IN_IMMEDIAT = 16) else
		sig_EXT_WORD_Z;
	
	sig_RES_EXTEND <=
		sig_EXT_Z      when (reg_EXECUTE_IN_OPERATION(0) = '1')  else
		sig_EXT_S;
	
	
	-- 
	-- FIND
	-- 
	sig_FF1 <=
		"000001" 	when (reg_EXECUTE_IN_DATA_RA (0) = '1') 	else
		"000010" 	when (reg_EXECUTE_IN_DATA_RA (1) = '1') 	else
		"000011" 	when (reg_EXECUTE_IN_DATA_RA (2) = '1') 	else
		"000100" 	when (reg_EXECUTE_IN_DATA_RA (3) = '1') 	else
		"000101" 	when (reg_EXECUTE_IN_DATA_RA (4) = '1') 	else
		"000110" 	when (reg_EXECUTE_IN_DATA_RA (5) = '1') 	else
		"000111" 	when (reg_EXECUTE_IN_DATA_RA (6) = '1') 	else
		"001000" 	when (reg_EXECUTE_IN_DATA_RA (7) = '1') 	else
		"001001" 	when (reg_EXECUTE_IN_DATA_RA (8) = '1') 	else
		"001010" 	when (reg_EXECUTE_IN_DATA_RA (9) = '1') 	else
		"001011" 	when (reg_EXECUTE_IN_DATA_RA (10) = '1') 	else
		"001100" 	when (reg_EXECUTE_IN_DATA_RA (11) = '1') 	else
		"001101" 	when (reg_EXECUTE_IN_DATA_RA (12) = '1') 	else
		"001110" 	when (reg_EXECUTE_IN_DATA_RA (13) = '1') 	else
		"001111" 	when (reg_EXECUTE_IN_DATA_RA (14) = '1') 	else
		"010000" 	when (reg_EXECUTE_IN_DATA_RA (15) = '1') 	else
		"010001" 	when (reg_EXECUTE_IN_DATA_RA (16) = '1') 	else
		"010010" 	when (reg_EXECUTE_IN_DATA_RA (17) = '1') 	else
		"010011" 	when (reg_EXECUTE_IN_DATA_RA (18) = '1') 	else
		"010100" 	when (reg_EXECUTE_IN_DATA_RA (19) = '1') 	else
		"010101" 	when (reg_EXECUTE_IN_DATA_RA (20) = '1') 	else
		"010110" 	when (reg_EXECUTE_IN_DATA_RA (21) = '1') 	else
		"010111" 	when (reg_EXECUTE_IN_DATA_RA (22) = '1') 	else
		"011000" 	when (reg_EXECUTE_IN_DATA_RA (23) = '1') 	else
		"011001" 	when (reg_EXECUTE_IN_DATA_RA (24) = '1') 	else
		"011010" 	when (reg_EXECUTE_IN_DATA_RA (25) = '1') 	else
		"011011" 	when (reg_EXECUTE_IN_DATA_RA (26) = '1') 	else
		"011100" 	when (reg_EXECUTE_IN_DATA_RA (27) = '1') 	else
		"011101" 	when (reg_EXECUTE_IN_DATA_RA (28) = '1') 	else
		"011110" 	when (reg_EXECUTE_IN_DATA_RA (29) = '1') 	else
		"011111" 	when (reg_EXECUTE_IN_DATA_RA (30) = '1') 	else
		"100000" 	when (reg_EXECUTE_IN_DATA_RA (31) = '1') 	else
		"000000";
	
	sig_FL1 <=
		"100000" 	when (reg_EXECUTE_IN_DATA_RA (31) = '1') 	else
		"011111" 	when (reg_EXECUTE_IN_DATA_RA (30) = '1') 	else
		"011110" 	when (reg_EXECUTE_IN_DATA_RA (29) = '1') 	else
		"011101" 	when (reg_EXECUTE_IN_DATA_RA (28) = '1') 	else
		"011100" 	when (reg_EXECUTE_IN_DATA_RA (27) = '1') 	else
		"011011" 	when (reg_EXECUTE_IN_DATA_RA (26) = '1') 	else
		"011010" 	when (reg_EXECUTE_IN_DATA_RA (25) = '1') 	else
		"011001" 	when (reg_EXECUTE_IN_DATA_RA (24) = '1') 	else
		"011000" 	when (reg_EXECUTE_IN_DATA_RA (23) = '1') 	else
		"010111" 	when (reg_EXECUTE_IN_DATA_RA (22) = '1') 	else
		"010110" 	when (reg_EXECUTE_IN_DATA_RA (21) = '1') 	else
		"010101" 	when (reg_EXECUTE_IN_DATA_RA (20) = '1') 	else
		"010100" 	when (reg_EXECUTE_IN_DATA_RA (19) = '1') 	else
		"010011" 	when (reg_EXECUTE_IN_DATA_RA (18) = '1') 	else
		"010010" 	when (reg_EXECUTE_IN_DATA_RA (17) = '1') 	else
		"010001" 	when (reg_EXECUTE_IN_DATA_RA (16) = '1') 	else
		"010000" 	when (reg_EXECUTE_IN_DATA_RA (15) = '1') 	else
		"001111" 	when (reg_EXECUTE_IN_DATA_RA (14) = '1') 	else
		"001110" 	when (reg_EXECUTE_IN_DATA_RA (13) = '1') 	else
		"001101" 	when (reg_EXECUTE_IN_DATA_RA (12) = '1') 	else
		"001100" 	when (reg_EXECUTE_IN_DATA_RA (11) = '1') 	else
		"001011" 	when (reg_EXECUTE_IN_DATA_RA (10) = '1') 	else
		"001010" 	when (reg_EXECUTE_IN_DATA_RA (9) = '1') 	else
		"001001" 	when (reg_EXECUTE_IN_DATA_RA (8) = '1') 	else
		"001000" 	when (reg_EXECUTE_IN_DATA_RA (7) = '1') 	else
		"000111" 	when (reg_EXECUTE_IN_DATA_RA (6) = '1') 	else
		"000110" 	when (reg_EXECUTE_IN_DATA_RA (5) = '1') 	else
		"000101" 	when (reg_EXECUTE_IN_DATA_RA (4) = '1') 	else
		"000100" 	when (reg_EXECUTE_IN_DATA_RA (3) = '1') 	else
		"000011" 	when (reg_EXECUTE_IN_DATA_RA (2) = '1') 	else
		"000010" 	when (reg_EXECUTE_IN_DATA_RA (1) = '1') 	else
		"000001" 	when (reg_EXECUTE_IN_DATA_RA (0) = '1') 	else
		"000000";
	
	sig_RES_FIND <=
		"00000000000000000000000000"&sig_FF1      when (reg_EXECUTE_IN_OPERATION(0) = '1')  else
		"00000000000000000000000000"&sig_FL1;
	
	
	-- 
	-- SPECIAL
	-- 
	sig_SPR_IS_HERE <=
		'1' when (sig_A_OR_B(15 downto 0) = "00101") else
		'0';
	-- MFSPR
	sig_MFSPR <=
		reg_MACLO(0) when (sig_SPR_IS_HERE = '1' and sig_A_OR_B(10 downto 0) = "00000000001") else
		reg_MACHI(0) when (sig_SPR_IS_HERE = '1' and sig_A_OR_B(10 downto 0) = "00000000010") else
		"00000000000000000000000000000000";
	
	
	-- MTSPR
	process (in_CLOCK)
	begin
		if in_CLOCK'event and in_CLOCK = '1' then
			if (sig_SPR_IS_HERE = '1') then
				if (sig_A_OR_B(10 downto 0) = "00000000001") then
					reg_MACLO(0) <= reg_EXECUTE_IN_DATA_RB;
				end if;
				if (sig_A_OR_B(10 downto 0) = "00000000010") then
					reg_MACHI(0) <= reg_EXECUTE_IN_DATA_RB;
				end if;
			end if;
		end if;
	end process;
	
	sig_RES_SPECIAL <=
		sig_MFSPR when (reg_EXECUTE_IN_OPERATION = "0000001")  else
		reg_EXECUTE_IN_DATA_RB when (reg_EXECUTE_IN_OPERATION = "0000010")  else
		"00000000000000000000000000000000";
	
	-- 
	-- TRANSACTION
	-- 
	sig_BUSY <=
--		reg_FUNCTIONAL_QUEUE(34)(0) when in_EXECUTE_IN_OPERATION = "" else
		reg_VAL_5  when in_EXECUTE_IN_TYPE = "00100" else
		reg_VAL_0;
	sig_EXECUTE_OUT_VAL <= reg_EXECUTE_OUT_VAL;
	sig_UPDATE <= not reg_EXECUTE_OUT_VAL or in_EXECUTE_OUT_ACK;
	sig_EXECUTE_IN_ACK <= not sig_BUSY or sig_UPDATE;
	
	-- 
	-- -----------------------------------
	-- -- Output Buffer Signals
	-- -----------------------------------
	-- 
	
	sig_EXECUTE_OUT_OOO_ENGINE_ID <= reg_OOO_ENGINE_ID_0;
	sig_EXECUTE_OUT_PACKET_ID <= reg_PACKET_ID_0;
	sig_EXECUTE_OUT_WRITE_RD <=  reg_WRITE_RD_0;
	sig_EXECUTE_OUT_NUM_REG_RD <= reg_NUM_REG_RD_0;
	with reg_TYPE_0 select
	sig_EXECUTE_OUT_DATA_RD <=
		sig_RES_ALU when "00000",
		sig_RES_MOVE when "00010",
		sig_RES_BRANCH when "01010",
		sig_RES_SHIFTER when "00001",
		sig_RES_EXTEND when "00110",
		sig_RES_FIND when "00111",
		sig_RES_MUL when "00100",
		sig_RES_SPECIAL when "01000",
		"00000000000000000000000000000000" when others;
	sig_EXECUTE_OUT_WRITE_RE <= reg_WRITE_RE_0;
	sig_EXECUTE_OUT_NUM_REG_RE <= reg_NUM_REG_RE_0;
	with reg_TYPE_0 select
	sig_EXECUTE_OUT_DATA_RE <=
		sig_COUT_ALU & sig_OVR_ALU when "00000",
		sig_COUT_MUL & sig_OVR_MUL when "00100",
		'0' & sig_FLAG_F when "00011",
		"00" when others;
	sig_EXECUTE_OUT_EXCEPTION <=
		"01011" when (reg_TYPE_0 = "00000" and sig_OVR_ALU = '1') else
		"01011" when (reg_TYPE_0 = "00100" and sig_OVR_MUL = '1') else
--		"10011" when (reg_TYPE_1 = "01000" and reg_OPERATION_1 = "0000001" and sig_SPR_IS_HERE = '0') else
--		"10100" when (reg_TYPE_1 = "01000" and reg_OPERATION_1 = "0000010" and sig_SPR_IS_HERE = '0') else
		"00000";
	with reg_TYPE_0 select
	sig_EXECUTE_OUT_NO_SEQUENCE <=
		sig_NOSQ_BRANCH when "01010",
		'0'when others;
	with reg_TYPE_0 select
	sig_EXECUTE_OUT_ADDRESS <=
		sig_ADDR_BRANCH when "01010",
		sig_A_OR_B(29 downto 0) when "01000",
		"000000000000000000000000000000" when others;
	
	-- 
	-- -----------------------------------
	-- -- Outputs                          
	-- -----------------------------------
	-- 
	
	out_EXECUTE_OUT_OOO_ENGINE_ID <= reg_EXECUTE_OUT_OOO_ENGINE_ID;
	out_EXECUTE_OUT_PACKET_ID <= reg_EXECUTE_OUT_PACKET_ID;
	out_EXECUTE_OUT_WRITE_RD <=  reg_EXECUTE_OUT_WRITE_RD;
	out_EXECUTE_OUT_NUM_REG_RD <= reg_EXECUTE_OUT_NUM_REG_RD;
	out_EXECUTE_OUT_DATA_RD <= reg_EXECUTE_OUT_DATA_RD;
	out_EXECUTE_OUT_WRITE_RE <= reg_EXECUTE_OUT_WRITE_RE;
	out_EXECUTE_OUT_NUM_REG_RE <= reg_EXECUTE_OUT_NUM_REG_RE;
	out_EXECUTE_OUT_DATA_RE <= reg_EXECUTE_OUT_DATA_RE;
	out_EXECUTE_OUT_EXCEPTION <= reg_EXECUTE_OUT_EXCEPTION;
	out_EXECUTE_OUT_NO_SEQUENCE <= reg_EXECUTE_OUT_NO_SEQUENCE;
	out_EXECUTE_OUT_ADDRESS <= reg_EXECUTE_OUT_ADDRESS;
	out_EXECUTE_OUT_VAL <= sig_EXECUTE_OUT_VAL;
	out_EXECUTE_IN_ACK <= sig_EXECUTE_IN_ACK;

end behavioural;

