#ifdef VHDL
/*
 * $Id: Functionnal_unit_vhdl_declaration.cpp 116 2009-04-30 13:51:41Z moulu $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Functionnal_unit/include/Functionnal_unit.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace functionnal_unit {


#undef  FUNCTION
#define FUNCTION "Functionnal_unit::vhdl_declaration"
  void Functionnal_unit::vhdl_declaration (Vhdl * & vhdl)
  {
    log_printf(FUNC,Functionnal_unit,FUNCTION,"Begin");
    vhdl->set_signal ("sig_EXECUTE_IN_ACK",1);

    vhdl->set_signal ("reg_BUSY_IN",1);

    if(_param->_have_port_context_id)
      vhdl->set_signal ("reg_EXECUTE_IN_CONTEXT_ID", _param->_size_context_id);
    if(_param->_have_port_front_end_id)
      vhdl->set_signal ("reg_EXECUTE_IN_FRONT_END_ID", _param->_size_front_end_id);
    if(_param->_have_port_ooo_engine_id)
      vhdl->set_signal ("reg_EXECUTE_IN_OOO_ENGINE_ID", _param->_size_ooo_engine_id);
    if(_param->_have_port_rob_ptr)
      vhdl->set_signal ("reg_EXECUTE_IN_PACKET_ID",  _param->_size_rob_ptr);
    vhdl->set_signal ("reg_EXECUTE_IN_OPERATION", _param->_size_operation);
    vhdl->set_signal ("reg_EXECUTE_IN_TYPE", _param->_size_type);
    vhdl->set_signal ("reg_EXECUTE_IN_HAS_IMMEDIAT", 1);
    vhdl->set_signal ("reg_EXECUTE_IN_IMMEDIAT", _param->_size_general_data);
    vhdl->set_signal ("reg_EXECUTE_IN_DATA_RA", _param->_size_general_data);
    vhdl->set_signal ("reg_EXECUTE_IN_DATA_RB", _param->_size_general_data);
    vhdl->set_signal ("reg_EXECUTE_IN_DATA_RC", _param->_size_special_data);
    vhdl->set_signal ("reg_EXECUTE_IN_WRITE_RD", 1);
    vhdl->set_signal ("reg_EXECUTE_IN_NUM_REG_RD", _param->_size_general_register);
    vhdl->set_signal ("reg_EXECUTE_IN_WRITE_RE", 1);
    vhdl->set_signal ("reg_EXECUTE_IN_NUM_REG_RE", _param->_size_special_register);

    vhdl->set_signal ("sig_B_OPERAND",_param->_size_general_data);

    vhdl->set_signal ("sig_IS_ARITH",1);
    vhdl->set_signal ("sig_IS_LOGIC",1);
    vhdl->set_signal ("sig_CIN_ARITH",1);
    vhdl->set_signal ("sig_ARITH_B_OPERAND",_param->_size_general_data);
    vhdl->set_signal ("sig_RES_ARITH",_param->_size_general_data+1);
    vhdl->set_signal ("sig_A_AND_B",_param->_size_general_data);
    vhdl->set_signal ("sig_A_OR_B",_param->_size_general_data);
    vhdl->set_signal ("sig_A_XOR_B",_param->_size_general_data);
    vhdl->set_signal ("sig_RES_LOGIC",_param->_size_general_data);
    vhdl->set_signal ("sig_RES_ALU",_param->_size_general_data);
    vhdl->set_signal ("sig_OVR_ALU",1);
    vhdl->set_signal ("sig_COUT_ALU",1);

    vhdl->set_signal ("sig_RES_MOVE",_param->_size_general_data);
    vhdl->set_signal ("sig_CMOV",_param->_size_general_data);
    vhdl->set_signal ("sig_MOVHI",_param->_size_general_data);

    vhdl->set_signal ("sig_RES_BRANCH",_param->_size_general_data);
    vhdl->set_signal ("sig_ADDR_BRANCH",_param->_size_instruction_address);
    vhdl->set_signal ("sig_NOSQ_BRANCH",1);

    vhdl->set_signal ("sig_RES_SHIFTER",_param->_size_general_data);

    vhdl->set_signal ("sig_EXT_BYTE_S",_param->_size_general_data);
    vhdl->set_signal ("sig_EXT_BYTE_Z",_param->_size_general_data);
    vhdl->set_signal ("sig_EXT_HALF_WORD_S",_param->_size_general_data);
    vhdl->set_signal ("sig_EXT_HALF_WORD_Z",_param->_size_general_data);
    vhdl->set_signal ("sig_EXT_WORD_S",_param->_size_general_data);
    vhdl->set_signal ("sig_EXT_WORD_Z",_param->_size_general_data);
    vhdl->set_signal ("sig_EXT_S",_param->_size_general_data);
    vhdl->set_signal ("sig_EXT_Z",_param->_size_general_data);
    vhdl->set_signal ("sig_RES_EXTEND",_param->_size_general_data);

    vhdl->set_signal ("sig_FF1",log2(_param->_size_general_data)+1);
    vhdl->set_signal ("sig_FL1",log2(_param->_size_general_data)+1);
    vhdl->set_signal ("sig_RES_FIND",_param->_size_general_data);

    vhdl->set_signal ("sig_SPR_IS_HERE",1);
    vhdl->set_signal ("sig_MFSPR",_param->_size_spr);
    vhdl->set_signal ("sig_MTSPR",_param->_size_spr);

    vhdl->set_signal ("sig_RES_SPECIAL",_param->_size_general_data);


    vhdl->set_signal ("sig_EXECUTE_OUT_VAL", 1);
    vhdl->set_signal ("sig_EXECUTE_OUT_UPDATE", 1);

    vhdl->set_signal ("reg_BUSY_OUT",1);

    if(_param->_have_port_context_id){
      vhdl->set_signal ("reg_EXECUTE_OUT_CONTEXT_ID", _param->_size_context_id);
      vhdl->set_signal ("sig_EXECUTE_OUT_CONTEXT_ID", _param->_size_context_id);}
    if(_param->_have_port_front_end_id){
      vhdl->set_signal ("reg_EXECUTE_OUT_FRONT_END_ID", _param->_size_front_end_id);
      vhdl->set_signal ("sig_EXECUTE_OUT_FRONT_END_ID", _param->_size_front_end_id);}
    if(_param->_have_port_ooo_engine_id){
      vhdl->set_signal ("reg_EXECUTE_OUT_OOO_ENGINE_ID", _param->_size_ooo_engine_id);
      vhdl->set_signal ("sig_EXECUTE_OUT_OOO_ENGINE_ID", _param->_size_ooo_engine_id);}
    if(_param->_have_port_rob_ptr){
      vhdl->set_signal ("reg_EXECUTE_OUT_PACKET_ID",  _param->_size_rob_ptr);
      vhdl->set_signal ("sig_EXECUTE_OUT_PACKET_ID",  _param->_size_rob_ptr);}
    vhdl->set_signal ("reg_EXECUTE_OUT_WRITE_RD", 1);
    vhdl->set_signal ("sig_EXECUTE_OUT_WRITE_RD", 1);
    vhdl->set_signal ("reg_EXECUTE_OUT_NUM_REG_RD", _param->_size_general_register);
    vhdl->set_signal ("sig_EXECUTE_OUT_NUM_REG_RD", _param->_size_general_register);
    vhdl->set_signal ("reg_EXECUTE_OUT_DATA_RD", _param->_size_general_data);
    vhdl->set_signal ("sig_EXECUTE_OUT_DATA_RD", _param->_size_general_data);
    vhdl->set_signal ("reg_EXECUTE_OUT_WRITE_RE", 1);
    vhdl->set_signal ("sig_EXECUTE_OUT_WRITE_RE", 1);
    vhdl->set_signal ("reg_EXECUTE_OUT_NUM_REG_RE", _param->_size_special_register);
    vhdl->set_signal ("sig_EXECUTE_OUT_NUM_REG_RE", _param->_size_special_register);
    vhdl->set_signal ("reg_EXECUTE_OUT_DATA_RE", _param->_size_special_data);
    vhdl->set_signal ("sig_EXECUTE_OUT_DATA_RE", _param->_size_special_data);
    vhdl->set_signal ("reg_EXECUTE_OUT_EXCEPTION", _param->_size_exception);
    vhdl->set_signal ("sig_EXECUTE_OUT_EXCEPTION", _param->_size_exception);
    vhdl->set_signal ("reg_EXECUTE_OUT_NO_SEQUENCE", 1);
    vhdl->set_signal ("sig_EXECUTE_OUT_NO_SEQUENCE", 1);
    vhdl->set_signal ("reg_EXECUTE_OUT_ADDRESS", _param->_size_instruction_address);
    vhdl->set_signal ("sig_EXECUTE_OUT_ADDRESS", _param->_size_instruction_address);

    vhdl->set_type    ("Tmac","array ("+toString(_param->_nb_context)+" downto 0) of "+std_logic(_param->_size_spr));
    vhdl->set_signal  ("reg_MACLO             ", "Tmac");
    vhdl->set_signal  ("reg_MACHI             ", "Tmac");

    log_printf(FUNC,Functionnal_unit,FUNCTION,"End");
  };

}; // end namespace functionnal_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
