#ifdef SYSTEMC
/*
 * $Id: Execute_queue_genMoore.cpp 136 2009-10-20 18:52:15Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue/include/Execute_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace execute_queue {


#undef  FUNCTION
#define FUNCTION "Execute_queue::genMoore"
  void Execute_queue::genMoore (void)
  {
    log_begin(Execute_queue,FUNCTION);
    log_function(Execute_queue,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET))
      {
    // -----[ Interface "execute_queue_in" ]--------------------------------
    {
      internal_EXECUTE_QUEUE_IN_ACK = _queue->size() < _param->_size_queue;
    }

    // -----[ Interface "execute_queue_out" ]--------------------------------
    {
      internal_EXECUTE_QUEUE_OUT_VAL = (not _queue->empty());
      
      if (internal_EXECUTE_QUEUE_OUT_VAL)
	{
	  if (_param->_have_port_context_id)
      	  PORT_WRITE(out_EXECUTE_QUEUE_OUT_CONTEXT_ID   , _queue->front()->_context_id   );
	  if (_param->_have_port_front_end_id)
      	  PORT_WRITE(out_EXECUTE_QUEUE_OUT_FRONT_END_ID , _queue->front()->_front_end_id );
	  if (_param->_have_port_ooo_engine_id)
      	  PORT_WRITE(out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID, _queue->front()->_ooo_engine_id);
	  if (_param->_have_port_rob_ptr)
      	  PORT_WRITE(out_EXECUTE_QUEUE_OUT_PACKET_ID    , _queue->front()->_packet_id    );
//    	  PORT_WRITE(out_EXECUTE_QUEUE_OUT_OPERATION    , _queue->front()->_operation    );
//    	  PORT_WRITE(out_EXECUTE_QUEUE_OUT_TYPE         , _queue->front()->_type         );
      	  PORT_WRITE(out_EXECUTE_QUEUE_OUT_CANCEL       , _queue->front()->_cancel       );
      	  PORT_WRITE(out_EXECUTE_QUEUE_OUT_FLAGS        , _queue->front()->_flags        );
      	  PORT_WRITE(out_EXECUTE_QUEUE_OUT_EXCEPTION    , _queue->front()->_exception    );
      	  PORT_WRITE(out_EXECUTE_QUEUE_OUT_NO_SEQUENCE  , _queue->front()->_no_sequence  );
      	  PORT_WRITE(out_EXECUTE_QUEUE_OUT_ADDRESS      , _queue->front()->_address      );
      	  PORT_WRITE(out_EXECUTE_QUEUE_OUT_DATA         , _queue->front()->_data         );
	}
    }
      }
    else
      {
        // Reset
      internal_EXECUTE_QUEUE_IN_ACK  = 0;
      internal_EXECUTE_QUEUE_OUT_VAL = 0;
      }

    // Write output
    PORT_WRITE(out_EXECUTE_QUEUE_IN_ACK , internal_EXECUTE_QUEUE_IN_ACK);
    PORT_WRITE(out_EXECUTE_QUEUE_OUT_VAL, internal_EXECUTE_QUEUE_OUT_VAL);

    log_end(Execute_queue,FUNCTION);
  };

}; // end namespace execute_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
