/*
 * $Id: test.cpp 131 2009-07-08 18:40:08Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"


void test (string name,
	   morpheo::behavioural::core::multi_execute_loop::execute_loop::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  _model.set_model(MODEL_SYSTEMC,true);

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Execute_loop * _Execute_loop = new Execute_loop 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  sc_signal<Tcontrol_t        >  **  in_EXECUTE_LOOP_IN_VAL                  ;
  sc_signal<Tcontrol_t        >  ** out_EXECUTE_LOOP_IN_ACK                  ;
  sc_signal<Tcontext_t        >  **  in_EXECUTE_LOOP_IN_CONTEXT_ID           ;
  sc_signal<Tcontext_t        >  **  in_EXECUTE_LOOP_IN_FRONT_END_ID         ;
  sc_signal<Tcontext_t        >  **  in_EXECUTE_LOOP_IN_OOO_ENGINE_ID        ;
  sc_signal<Tpacket_t         >  **  in_EXECUTE_LOOP_IN_PACKET_ID            ;
  sc_signal<Toperation_t      >  **  in_EXECUTE_LOOP_IN_OPERATION            ;
  sc_signal<Ttype_t           >  **  in_EXECUTE_LOOP_IN_TYPE                 ;
  sc_signal<Tlsq_ptr_t        >  **  in_EXECUTE_LOOP_IN_STORE_QUEUE_PTR_WRITE;
  sc_signal<Tlsq_ptr_t        >  **  in_EXECUTE_LOOP_IN_STORE_QUEUE_PTR_READ ;
  sc_signal<Tcontrol_t        >  **  in_EXECUTE_LOOP_IN_STORE_QUEUE_EMPTY    ;
  sc_signal<Tlsq_ptr_t        >  **  in_EXECUTE_LOOP_IN_LOAD_QUEUE_PTR_WRITE ;
  sc_signal<Tcontrol_t        >  **  in_EXECUTE_LOOP_IN_HAS_IMMEDIAT         ;
  sc_signal<Tgeneral_data_t   >  **  in_EXECUTE_LOOP_IN_IMMEDIAT             ;
  sc_signal<Tcontrol_t        >  **  in_EXECUTE_LOOP_IN_READ_RA              ;
  sc_signal<Tgeneral_address_t>  **  in_EXECUTE_LOOP_IN_NUM_REG_RA           ;
  sc_signal<Tcontrol_t        >  **  in_EXECUTE_LOOP_IN_READ_RB              ;
  sc_signal<Tgeneral_address_t>  **  in_EXECUTE_LOOP_IN_NUM_REG_RB           ;
  sc_signal<Tcontrol_t        >  **  in_EXECUTE_LOOP_IN_READ_RC              ;
  sc_signal<Tspecial_address_t>  **  in_EXECUTE_LOOP_IN_NUM_REG_RC           ;
  sc_signal<Tcontrol_t        >  **  in_EXECUTE_LOOP_IN_WRITE_RD             ;
  sc_signal<Tgeneral_address_t>  **  in_EXECUTE_LOOP_IN_NUM_REG_RD           ;
  sc_signal<Tcontrol_t        >  **  in_EXECUTE_LOOP_IN_WRITE_RE             ;
  sc_signal<Tspecial_address_t>  **  in_EXECUTE_LOOP_IN_NUM_REG_RE           ;
  sc_signal<Tcontrol_t        >  ** out_EXECUTE_LOOP_OUT_VAL                 ;
  sc_signal<Tcontrol_t        >  **  in_EXECUTE_LOOP_OUT_ACK                 ;
  sc_signal<Tcontext_t        >  ** out_EXECUTE_LOOP_OUT_CONTEXT_ID          ;
  sc_signal<Tcontext_t        >  ** out_EXECUTE_LOOP_OUT_FRONT_END_ID        ;
  sc_signal<Tcontext_t        >  ** out_EXECUTE_LOOP_OUT_OOO_ENGINE_ID       ;
  sc_signal<Tpacket_t         >  ** out_EXECUTE_LOOP_OUT_PACKET_ID           ;
//sc_signal<Toperation_t      >  ** out_EXECUTE_LOOP_OUT_OPERATION           ;
//sc_signal<Ttype_t           >  ** out_EXECUTE_LOOP_OUT_TYPE                ;
  sc_signal<Tspecial_data_t   >  ** out_EXECUTE_LOOP_OUT_FLAGS               ;
  sc_signal<Texception_t      >  ** out_EXECUTE_LOOP_OUT_EXCEPTION           ;
  sc_signal<Tcontrol_t        >  ** out_EXECUTE_LOOP_OUT_NO_SEQUENCE         ;
  sc_signal<Taddress_t        >  ** out_EXECUTE_LOOP_OUT_ADDRESS             ;
  sc_signal<Tgeneral_data_t   >  ** out_EXECUTE_LOOP_OUT_DATA                ;
  sc_signal<Tcontrol_t        > *** out_DCACHE_REQ_VAL                       ;
  sc_signal<Tcontrol_t        > ***  in_DCACHE_REQ_ACK                       ;
  sc_signal<Tcontext_t        > *** out_DCACHE_REQ_CONTEXT_ID                ;
  sc_signal<Tpacket_t         > *** out_DCACHE_REQ_PACKET_ID                 ;
  sc_signal<Tdcache_address_t > *** out_DCACHE_REQ_ADDRESS                   ;
  sc_signal<Tdcache_type_t    > *** out_DCACHE_REQ_TYPE                      ;
  sc_signal<Tdcache_data_t    > *** out_DCACHE_REQ_WDATA                     ;
  sc_signal<Tcontrol_t        > ***  in_DCACHE_RSP_VAL                       ;
  sc_signal<Tcontrol_t        > *** out_DCACHE_RSP_ACK                       ;
  sc_signal<Tcontext_t        > ***  in_DCACHE_RSP_CONTEXT_ID                ;
  sc_signal<Tpacket_t         > ***  in_DCACHE_RSP_PACKET_ID                 ;
  sc_signal<Tdcache_data_t    > ***  in_DCACHE_RSP_RDATA                     ;
  sc_signal<Tdcache_error_t   > ***  in_DCACHE_RSP_ERROR                     ; 
  sc_signal<Tcontrol_t        > ***  in_INSERT_ROB_VAL                       ;
  sc_signal<Tcontrol_t        > *** out_INSERT_ROB_ACK                       ;
  sc_signal<Tcontrol_t        > ***  in_INSERT_ROB_RD_USE                    ;
  sc_signal<Tgeneral_address_t> ***  in_INSERT_ROB_RD_NUM_REG                ;
  sc_signal<Tcontrol_t        > ***  in_INSERT_ROB_RE_USE                    ;
  sc_signal<Tspecial_address_t> ***  in_INSERT_ROB_RE_NUM_REG                ;
//sc_signal<Tcontrol_t        > ***  in_RETIRE_ROB_VAL                       ;
//sc_signal<Tcontrol_t        > *** out_RETIRE_ROB_ACK                       ;
//sc_signal<Tcontrol_t        > ***  in_RETIRE_ROB_RD_OLD_USE                ; 
//sc_signal<Tgeneral_address_t> ***  in_RETIRE_ROB_RD_OLD_NUM_REG            ;
//sc_signal<Tcontrol_t        > ***  in_RETIRE_ROB_RD_NEW_USE                ;
//sc_signal<Tgeneral_address_t> ***  in_RETIRE_ROB_RD_NEW_NUM_REG            ;
//sc_signal<Tcontrol_t        > ***  in_RETIRE_ROB_RE_OLD_USE                ; 
//sc_signal<Tspecial_address_t> ***  in_RETIRE_ROB_RE_OLD_NUM_REG            ;
//sc_signal<Tcontrol_t        > ***  in_RETIRE_ROB_RE_NEW_USE                ;
//sc_signal<Tspecial_address_t> ***  in_RETIRE_ROB_RE_NEW_NUM_REG            ;
  
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_VAL                  ," in_EXECUTE_LOOP_IN_VAL                  ",Tcontrol_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_IN_ACK                  ,"out_EXECUTE_LOOP_IN_ACK                  ",Tcontrol_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_CONTEXT_ID           ," in_EXECUTE_LOOP_IN_CONTEXT_ID           ",Tcontext_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_FRONT_END_ID         ," in_EXECUTE_LOOP_IN_FRONT_END_ID         ",Tcontext_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_OOO_ENGINE_ID        ," in_EXECUTE_LOOP_IN_OOO_ENGINE_ID        ",Tcontext_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_PACKET_ID            ," in_EXECUTE_LOOP_IN_PACKET_ID            ",Tpacket_t         ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_OPERATION            ," in_EXECUTE_LOOP_IN_OPERATION            ",Toperation_t      ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_TYPE                 ," in_EXECUTE_LOOP_IN_TYPE                 ",Ttype_t           ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_STORE_QUEUE_PTR_WRITE," in_EXECUTE_LOOP_IN_STORE_QUEUE_PTR_WRITE",Tlsq_ptr_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_STORE_QUEUE_PTR_READ ," in_EXECUTE_LOOP_IN_STORE_QUEUE_PTR_READ ",Tlsq_ptr_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_STORE_QUEUE_EMPTY    ," in_EXECUTE_LOOP_IN_STORE_QUEUE_EMPTY    ",Tcontrol_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_LOAD_QUEUE_PTR_WRITE ," in_EXECUTE_LOOP_IN_LOAD_QUEUE_PTR_WRITE ",Tlsq_ptr_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_HAS_IMMEDIAT         ," in_EXECUTE_LOOP_IN_HAS_IMMEDIAT         ",Tcontrol_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_IMMEDIAT             ," in_EXECUTE_LOOP_IN_IMMEDIAT             ",Tgeneral_data_t   ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_READ_RA              ," in_EXECUTE_LOOP_IN_READ_RA              ",Tcontrol_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_NUM_REG_RA           ," in_EXECUTE_LOOP_IN_NUM_REG_RA           ",Tgeneral_address_t,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_READ_RB              ," in_EXECUTE_LOOP_IN_READ_RB              ",Tcontrol_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_NUM_REG_RB           ," in_EXECUTE_LOOP_IN_NUM_REG_RB           ",Tgeneral_address_t,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_READ_RC              ," in_EXECUTE_LOOP_IN_READ_RC              ",Tcontrol_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_NUM_REG_RC           ," in_EXECUTE_LOOP_IN_NUM_REG_RC           ",Tspecial_address_t,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_WRITE_RD             ," in_EXECUTE_LOOP_IN_WRITE_RD             ",Tcontrol_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_NUM_REG_RD           ," in_EXECUTE_LOOP_IN_NUM_REG_RD           ",Tgeneral_address_t,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_WRITE_RE             ," in_EXECUTE_LOOP_IN_WRITE_RE             ",Tcontrol_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_NUM_REG_RE           ," in_EXECUTE_LOOP_IN_NUM_REG_RE           ",Tspecial_address_t,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_VAL                 ,"out_EXECUTE_LOOP_OUT_VAL                 ",Tcontrol_t        ,_param->_nb_write_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_OUT_ACK                 ," in_EXECUTE_LOOP_OUT_ACK                 ",Tcontrol_t        ,_param->_nb_write_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_CONTEXT_ID          ,"out_EXECUTE_LOOP_OUT_CONTEXT_ID          ",Tcontext_t        ,_param->_nb_write_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_FRONT_END_ID        ,"out_EXECUTE_LOOP_OUT_FRONT_END_ID        ",Tcontext_t        ,_param->_nb_write_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_OOO_ENGINE_ID       ,"out_EXECUTE_LOOP_OUT_OOO_ENGINE_ID       ",Tcontext_t        ,_param->_nb_write_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_PACKET_ID           ,"out_EXECUTE_LOOP_OUT_PACKET_ID           ",Tpacket_t         ,_param->_nb_write_unit);
//ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_OPERATION           ,"out_EXECUTE_LOOP_OUT_OPERATION           ",Toperation_t      ,_param->_nb_write_unit);
//ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_TYPE                ,"out_EXECUTE_LOOP_OUT_TYPE                ",Ttype_t           ,_param->_nb_write_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_FLAGS               ,"out_EXECUTE_LOOP_OUT_FLAGS               ",Tspecial_data_t   ,_param->_nb_write_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_EXCEPTION           ,"out_EXECUTE_LOOP_OUT_EXCEPTION           ",Texception_t      ,_param->_nb_write_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_NO_SEQUENCE         ,"out_EXECUTE_LOOP_OUT_NO_SEQUENCE         ",Tcontrol_t        ,_param->_nb_write_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_ADDRESS             ,"out_EXECUTE_LOOP_OUT_ADDRESS             ",Taddress_t        ,_param->_nb_write_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_DATA                ,"out_EXECUTE_LOOP_OUT_DATA                ",Tgeneral_data_t   ,_param->_nb_write_unit);
  ALLOC2_SC_SIGNAL(out_DCACHE_REQ_VAL                       ,"out_DCACHE_REQ_VAL                       ",Tcontrol_t        ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  ALLOC2_SC_SIGNAL( in_DCACHE_REQ_ACK                       ," in_DCACHE_REQ_ACK                       ",Tcontrol_t        ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  ALLOC2_SC_SIGNAL(out_DCACHE_REQ_CONTEXT_ID                ,"out_DCACHE_REQ_CONTEXT_ID                ",Tcontext_t        ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  ALLOC2_SC_SIGNAL(out_DCACHE_REQ_PACKET_ID                 ,"out_DCACHE_REQ_PACKET_ID                 ",Tpacket_t         ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  ALLOC2_SC_SIGNAL(out_DCACHE_REQ_ADDRESS                   ,"out_DCACHE_REQ_ADDRESS                   ",Tdcache_address_t ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  ALLOC2_SC_SIGNAL(out_DCACHE_REQ_TYPE                      ,"out_DCACHE_REQ_TYPE                      ",Tdcache_type_t    ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  ALLOC2_SC_SIGNAL(out_DCACHE_REQ_WDATA                     ,"out_DCACHE_REQ_WDATA                     ",Tdcache_data_t    ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  ALLOC2_SC_SIGNAL( in_DCACHE_RSP_VAL                       ," in_DCACHE_RSP_VAL                       ",Tcontrol_t        ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  ALLOC2_SC_SIGNAL(out_DCACHE_RSP_ACK                       ,"out_DCACHE_RSP_ACK                       ",Tcontrol_t        ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  ALLOC2_SC_SIGNAL( in_DCACHE_RSP_CONTEXT_ID                ," in_DCACHE_RSP_CONTEXT_ID                ",Tcontext_t        ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  ALLOC2_SC_SIGNAL( in_DCACHE_RSP_PACKET_ID                 ," in_DCACHE_RSP_PACKET_ID                 ",Tpacket_t         ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  ALLOC2_SC_SIGNAL( in_DCACHE_RSP_RDATA                     ," in_DCACHE_RSP_RDATA                     ",Tdcache_data_t    ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  ALLOC2_SC_SIGNAL( in_DCACHE_RSP_ERROR                     ," in_DCACHE_RSP_ERROR                     ",Tdcache_error_t   ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]); 
  ALLOC2_SC_SIGNAL( in_INSERT_ROB_VAL                       ," in_INSERT_ROB_VAL                       ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[it1]);
  ALLOC2_SC_SIGNAL(out_INSERT_ROB_ACK                       ,"out_INSERT_ROB_ACK                       ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_ROB_RD_USE                    ," in_INSERT_ROB_RD_USE                    ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_ROB_RD_NUM_REG                ," in_INSERT_ROB_RD_NUM_REG                ",Tgeneral_address_t,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_ROB_RE_USE                    ," in_INSERT_ROB_RE_USE                    ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_ROB_RE_NUM_REG                ," in_INSERT_ROB_RE_NUM_REG                ",Tspecial_address_t,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[it1]);
//   ALLOC2_SC_SIGNAL( in_RETIRE_ROB_VAL                       ," in_RETIRE_ROB_VAL                       ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
//   ALLOC2_SC_SIGNAL(out_RETIRE_ROB_ACK                       ,"out_RETIRE_ROB_ACK                       ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
//   ALLOC2_SC_SIGNAL( in_RETIRE_ROB_RD_OLD_USE                ," in_RETIRE_ROB_RD_OLD_USE                ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]); 
//   ALLOC2_SC_SIGNAL( in_RETIRE_ROB_RD_OLD_NUM_REG            ," in_RETIRE_ROB_RD_OLD_NUM_REG            ",Tgeneral_address_t,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
//   ALLOC2_SC_SIGNAL( in_RETIRE_ROB_RD_NEW_USE                ," in_RETIRE_ROB_RD_NEW_USE                ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
//   ALLOC2_SC_SIGNAL( in_RETIRE_ROB_RD_NEW_NUM_REG            ," in_RETIRE_ROB_RD_NEW_NUM_REG            ",Tgeneral_address_t,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
//   ALLOC2_SC_SIGNAL( in_RETIRE_ROB_RE_OLD_USE                ," in_RETIRE_ROB_RE_OLD_USE                ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]); 
//   ALLOC2_SC_SIGNAL( in_RETIRE_ROB_RE_OLD_NUM_REG            ," in_RETIRE_ROB_RE_OLD_NUM_REG            ",Tspecial_address_t,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
//   ALLOC2_SC_SIGNAL( in_RETIRE_ROB_RE_NEW_USE                ," in_RETIRE_ROB_RE_NEW_USE                ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
//   ALLOC2_SC_SIGNAL( in_RETIRE_ROB_RE_NEW_NUM_REG            ," in_RETIRE_ROB_RE_NEW_NUM_REG            ",Tspecial_address_t,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Execute_loop.\n"),name.c_str());

  (*(_Execute_loop->in_CLOCK))        (*(in_CLOCK));
  (*(_Execute_loop->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_VAL                  ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_IN_ACK                  ,_param->_nb_read_unit);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_CONTEXT_ID           ,_param->_nb_read_unit);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_FRONT_END_ID         ,_param->_nb_read_unit);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_OOO_ENGINE_ID        ,_param->_nb_read_unit);
  if (_param->_have_port_rob_ptr  )
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_PACKET_ID            ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_OPERATION            ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_TYPE                 ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_STORE_QUEUE_PTR_WRITE,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_STORE_QUEUE_PTR_READ ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_STORE_QUEUE_EMPTY    ,_param->_nb_read_unit);
  if (_param->_have_port_load_queue_ptr)
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_LOAD_QUEUE_PTR_WRITE ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_HAS_IMMEDIAT         ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_IMMEDIAT             ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_READ_RA              ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_NUM_REG_RA           ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_READ_RB              ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_NUM_REG_RB           ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_READ_RC              ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_NUM_REG_RC           ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_WRITE_RD             ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_NUM_REG_RD           ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_WRITE_RE             ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_NUM_REG_RE           ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_VAL                 ,_param->_nb_write_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_OUT_ACK                 ,_param->_nb_write_unit);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_CONTEXT_ID          ,_param->_nb_write_unit);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_FRONT_END_ID        ,_param->_nb_write_unit);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_OOO_ENGINE_ID       ,_param->_nb_write_unit);
  if (_param->_have_port_rob_ptr  )
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_PACKET_ID           ,_param->_nb_write_unit);
//INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_OPERATION           ,_param->_nb_write_unit);
//INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_TYPE                ,_param->_nb_write_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_FLAGS               ,_param->_nb_write_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_EXCEPTION           ,_param->_nb_write_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_NO_SEQUENCE         ,_param->_nb_write_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_ADDRESS             ,_param->_nb_write_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_DATA                ,_param->_nb_write_unit);
  INSTANCE2_SC_SIGNAL(_Execute_loop,out_DCACHE_REQ_VAL                       ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_DCACHE_REQ_ACK                       ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  if (_param->_have_port_dcache_context_id)
  INSTANCE2_SC_SIGNAL(_Execute_loop,out_DCACHE_REQ_CONTEXT_ID                ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop,out_DCACHE_REQ_PACKET_ID                 ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop,out_DCACHE_REQ_ADDRESS                   ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop,out_DCACHE_REQ_TYPE                      ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop,out_DCACHE_REQ_WDATA                     ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_DCACHE_RSP_VAL                       ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop,out_DCACHE_RSP_ACK                       ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  if (_param->_have_port_dcache_context_id)
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_DCACHE_RSP_CONTEXT_ID                ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_DCACHE_RSP_PACKET_ID                 ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_DCACHE_RSP_RDATA                     ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_DCACHE_RSP_ERROR                     ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]); 
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_INSERT_ROB_VAL                       ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop,out_INSERT_ROB_ACK                       ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_INSERT_ROB_RD_USE                    ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_INSERT_ROB_RD_NUM_REG                ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_INSERT_ROB_RE_USE                    ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_INSERT_ROB_RE_NUM_REG                ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[it1]);
//   INSTANCE2_SC_SIGNAL(_Execute_loop, in_RETIRE_ROB_VAL                       ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
//   INSTANCE2_SC_SIGNAL(_Execute_loop,out_RETIRE_ROB_ACK                       ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
//   INSTANCE2_SC_SIGNAL(_Execute_loop, in_RETIRE_ROB_RD_OLD_USE                ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]); 
//   INSTANCE2_SC_SIGNAL(_Execute_loop, in_RETIRE_ROB_RD_OLD_NUM_REG            ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
//   INSTANCE2_SC_SIGNAL(_Execute_loop, in_RETIRE_ROB_RD_NEW_USE                ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
//   INSTANCE2_SC_SIGNAL(_Execute_loop, in_RETIRE_ROB_RD_NEW_NUM_REG            ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
//   INSTANCE2_SC_SIGNAL(_Execute_loop, in_RETIRE_ROB_RE_OLD_USE                ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]); 
//   INSTANCE2_SC_SIGNAL(_Execute_loop, in_RETIRE_ROB_RE_OLD_NUM_REG            ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
//   INSTANCE2_SC_SIGNAL(_Execute_loop, in_RETIRE_ROB_RE_NEW_USE                ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
//   INSTANCE2_SC_SIGNAL(_Execute_loop, in_RETIRE_ROB_RE_NEW_NUM_REG            ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_VAL                  ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL(out_EXECUTE_LOOP_IN_ACK                  ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_CONTEXT_ID           ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_FRONT_END_ID         ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_OOO_ENGINE_ID        ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_PACKET_ID            ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_OPERATION            ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_TYPE                 ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_STORE_QUEUE_PTR_WRITE,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_STORE_QUEUE_PTR_READ ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_STORE_QUEUE_EMPTY    ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_LOAD_QUEUE_PTR_WRITE ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_HAS_IMMEDIAT         ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_IMMEDIAT             ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_READ_RA              ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_NUM_REG_RA           ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_READ_RB              ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_NUM_REG_RB           ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_READ_RC              ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_NUM_REG_RC           ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_WRITE_RD             ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_NUM_REG_RD           ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_WRITE_RE             ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_IN_NUM_REG_RE           ,_param->_nb_read_unit);
  DELETE1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_VAL                 ,_param->_nb_write_unit);
  DELETE1_SC_SIGNAL( in_EXECUTE_LOOP_OUT_ACK                 ,_param->_nb_write_unit);
  DELETE1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_CONTEXT_ID          ,_param->_nb_write_unit);
  DELETE1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_FRONT_END_ID        ,_param->_nb_write_unit);
  DELETE1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_OOO_ENGINE_ID       ,_param->_nb_write_unit);
  DELETE1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_PACKET_ID           ,_param->_nb_write_unit);
//DELETE1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_OPERATION           ,_param->_nb_write_unit);
//DELETE1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_TYPE                ,_param->_nb_write_unit);
  DELETE1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_FLAGS               ,_param->_nb_write_unit);
  DELETE1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_EXCEPTION           ,_param->_nb_write_unit);
  DELETE1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_NO_SEQUENCE         ,_param->_nb_write_unit);
  DELETE1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_ADDRESS             ,_param->_nb_write_unit);
  DELETE1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_DATA                ,_param->_nb_write_unit);
  DELETE2_SC_SIGNAL(out_DCACHE_REQ_VAL                       ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  DELETE2_SC_SIGNAL( in_DCACHE_REQ_ACK                       ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  DELETE2_SC_SIGNAL(out_DCACHE_REQ_CONTEXT_ID                ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  DELETE2_SC_SIGNAL(out_DCACHE_REQ_PACKET_ID                 ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  DELETE2_SC_SIGNAL(out_DCACHE_REQ_ADDRESS                   ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  DELETE2_SC_SIGNAL(out_DCACHE_REQ_TYPE                      ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  DELETE2_SC_SIGNAL(out_DCACHE_REQ_WDATA                     ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  DELETE2_SC_SIGNAL( in_DCACHE_RSP_VAL                       ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  DELETE2_SC_SIGNAL(out_DCACHE_RSP_ACK                       ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  DELETE2_SC_SIGNAL( in_DCACHE_RSP_CONTEXT_ID                ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  DELETE2_SC_SIGNAL( in_DCACHE_RSP_PACKET_ID                 ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  DELETE2_SC_SIGNAL( in_DCACHE_RSP_RDATA                     ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);
  DELETE2_SC_SIGNAL( in_DCACHE_RSP_ERROR                     ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]); 
  DELETE2_SC_SIGNAL( in_INSERT_ROB_VAL                       ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_ROB_ACK                       ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_ROB_RD_USE                    ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_ROB_RD_NUM_REG                ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_ROB_RE_USE                    ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_ROB_RE_NUM_REG                ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[it1]);
//   DELETE2_SC_SIGNAL( in_RETIRE_ROB_VAL                       ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
//   DELETE2_SC_SIGNAL(out_RETIRE_ROB_ACK                       ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
//   DELETE2_SC_SIGNAL( in_RETIRE_ROB_RD_OLD_USE                ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]); 
//   DELETE2_SC_SIGNAL( in_RETIRE_ROB_RD_OLD_NUM_REG            ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
//   DELETE2_SC_SIGNAL( in_RETIRE_ROB_RD_NEW_USE                ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
//   DELETE2_SC_SIGNAL( in_RETIRE_ROB_RD_NEW_NUM_REG            ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
//   DELETE2_SC_SIGNAL( in_RETIRE_ROB_RE_OLD_USE                ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]); 
//   DELETE2_SC_SIGNAL( in_RETIRE_ROB_RE_OLD_NUM_REG            ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
//   DELETE2_SC_SIGNAL( in_RETIRE_ROB_RE_NEW_USE                ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);
//   DELETE2_SC_SIGNAL( in_RETIRE_ROB_RE_NEW_NUM_REG            ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[it1]);

#endif

  delete _Execute_loop;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
