#ifdef VHDL
/*
 * $Id: Decod_vhdl_declaration.cpp 137 2010-02-16 12:35:48Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod/include/Decod.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod {


#undef  FUNCTION
#define FUNCTION "Decod::vhdl_declaration"
  void Decod::vhdl_declaration (Vhdl * & vhdl)
  {
    log_printf(FUNC,Decod,FUNCTION,"Begin");

    vhdl->set_signal ("internal_CONTEXT_EVENT_VAL",1);

    for(uint32_t x = 0;x < _param->_nb_context;x++){
      vhdl->set_signal ("internal_CONTEXT_"+toString(x)+"_HAVE_TRANSACTION",1);
      vhdl->set_signal ("reg_CONTEXT_"+toString(x)+"_IS_DELAY_SLOT",1);
      vhdl->set_signal ("internal_CONTEXT_"+toString(x)+"_IS_DELAY_SLOT",1);
      vhdl->set_signal ("internal_CONTEXT_"+toString(x)+"_ADDRESS_PREVIOUS",_param->_size_instruction_address);
      vhdl->set_signal ("reg_CONTEXT_"+toString(x)+"_ADDRESS_PREVIOUS",_param->_size_instruction_address);
      vhdl->set_signal ("internal_HAVE_DECOD_BRANCH_"+toString(x),1);
      vhdl->set_signal ("internal_CAN_CONTINUE_"+toString(x),1);
      for (uint32_t y = 0; y < _param->_nb_inst_fetch[x]; y++) vhdl->set_signal ("internal_IFETCH_"+toString(x)+"_"+toString(y)+"_ACK",1);
    }

    for(uint32_t i = 0;i < _param->_nb_inst_decod;i++){
      vhdl->set_signal ("internal_DECOD_"+toString(i)+"_VAL",1);
      vhdl->set_signal ("internal_PREDICT_"+toString(i)+"_VAL",1);
      vhdl->set_signal ("internal_DECOD_BRANCH_"+toString(i)+"_VAL",1);
      vhdl->set_signal ("internal_DECOD_CONTEXT_EVENT_"+toString(i)+"_VAL",1);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i),_param->_size_instruction);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_TYPE    ",_param->_size_type);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_OPERATION    ",_param->_size_operation);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_NO_EXECUTE    ",1);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_IS_DELAY_SLOT    ",1);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS    ",_param->_size_instruction_address);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT    ",_param->_size_instruction_address);
      vhdl->set_signal ("internal_DECOD_IN_INSTRUCTION_"+toString(i)+"_ADDRESS_NEXT    ",_param->_size_instruction_address);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_HAS_IMMEDIAT    ",1);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_IMMEDIAT    ",_param->_size_general_data);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RA    ",1);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RA    ",_param->_size_general_register_logic);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RB    ",1);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RB    ",_param->_size_general_register_logic);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_READ_RC    ",1);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RC    ",_param->_size_special_register_logic);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RD    ",1);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RD    ",_param->_size_general_register_logic);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_WRITE_RE    ",1);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_NUM_REG_RE    ",_param->_size_special_register_logic);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION_USE    ",_param->_size_exception_use);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_EXCEPTION    ",_param->_size_exception_decod);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_BRANCH_CONDITION    ",_param->_size_branch_condition);
      //vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_BRANCH_STACK_WRITE    ",1);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_BRANCH_DIRECTION    ",1);
      vhdl->set_signal ("internal_DECOD_INSTRUCTION_"+toString(i)+"_EVENT_TYPE    ",_param->_size_event_type);
    }

    log_printf(FUNC,Decod,FUNCTION,"End");
  };

}; // end namespace decod
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
