/*
 * $Id: test.cpp 128 2009-06-26 08:43:23Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Special_Register_unit/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::special_register_unit::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Special_Register_unit * _Special_Register_unit = new Special_Register_unit 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  sc_signal<Tcontrol_t    >   **  in_SPR_ACCESS_VAL         ;
  sc_signal<Tcontrol_t    >   ** out_SPR_ACCESS_ACK         ;
  sc_signal<Tcontext_t    >   **  in_SPR_ACCESS_FRONT_END_ID;
  sc_signal<Tcontext_t    >   **  in_SPR_ACCESS_CONTEXT_ID  ;
  sc_signal<Tcontrol_t    >   **  in_SPR_ACCESS_WEN         ;
  sc_signal<Tspr_address_t>   **  in_SPR_ACCESS_NUM_GROUP   ;
  sc_signal<Tspr_address_t>   **  in_SPR_ACCESS_NUM_REG     ;
  sc_signal<Tspr_t        >   **  in_SPR_ACCESS_WDATA       ;
  sc_signal<Tspr_t        >   ** out_SPR_ACCESS_RDATA       ;
  sc_signal<Tcontrol_t    >   ** out_SPR_ACCESS_INVALID     ;

  sc_signal<Tspr_t        >  *** out_SPR_READ_SR            ;

  sc_signal<Tcontrol_t    >  ***  in_SPR_COMMIT_VAL         ;
  sc_signal<Tcontrol_t    >  *** out_SPR_COMMIT_ACK         ;
  sc_signal<Tcontrol_t    >  ***  in_SPR_COMMIT_SR_F_VAL    ;
  sc_signal<Tcontrol_t    >  ***  in_SPR_COMMIT_SR_F        ;
  sc_signal<Tcontrol_t    >  ***  in_SPR_COMMIT_SR_CY_VAL   ;
  sc_signal<Tcontrol_t    >  ***  in_SPR_COMMIT_SR_CY       ;
  sc_signal<Tcontrol_t    >  ***  in_SPR_COMMIT_SR_OV_VAL   ;
  sc_signal<Tcontrol_t    >  ***  in_SPR_COMMIT_SR_OV       ;

  sc_signal<Tcontrol_t    >  ***  in_SPR_EVENT_VAL          ;
  sc_signal<Tcontrol_t    >  *** out_SPR_EVENT_ACK          ;
  sc_signal<Tspr_t        >  ***  in_SPR_EVENT_EPCR         ;
  sc_signal<Tcontrol_t    >  ***  in_SPR_EVENT_EEAR_WEN     ;
  sc_signal<Tspr_t        >  ***  in_SPR_EVENT_EEAR         ;
  sc_signal<Tcontrol_t    >  ***  in_SPR_EVENT_SR_DSX       ;
  sc_signal<Tcontrol_t    >  ***  in_SPR_EVENT_SR_TO_ESR    ;

  ALLOC1_SC_SIGNAL( in_SPR_ACCESS_VAL         ," in_SPR_ACCESS_VAL         ",Tcontrol_t    ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_SPR_ACCESS_ACK         ,"out_SPR_ACCESS_ACK         ",Tcontrol_t    ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_SPR_ACCESS_FRONT_END_ID," in_SPR_ACCESS_FRONT_END_ID",Tcontext_t    ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_SPR_ACCESS_CONTEXT_ID  ," in_SPR_ACCESS_CONTEXT_ID  ",Tcontext_t    ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_SPR_ACCESS_WEN         ," in_SPR_ACCESS_WEN         ",Tcontrol_t    ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_SPR_ACCESS_NUM_GROUP   ," in_SPR_ACCESS_NUM_GROUP   ",Tspr_address_t,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_SPR_ACCESS_NUM_REG     ," in_SPR_ACCESS_NUM_REG     ",Tspr_address_t,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_SPR_ACCESS_WDATA       ," in_SPR_ACCESS_WDATA       ",Tspr_t        ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_SPR_ACCESS_RDATA       ,"out_SPR_ACCESS_RDATA       ",Tspr_t        ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_SPR_ACCESS_INVALID     ,"out_SPR_ACCESS_INVALID     ",Tcontrol_t    ,_param->_nb_inst_reexecute);
  ALLOC2_SC_SIGNAL(out_SPR_READ_SR            ,"out_SPR_READ_SR            ",Tspr_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_SPR_COMMIT_VAL         ," in_SPR_COMMIT_VAL         ",Tcontrol_t    ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL(out_SPR_COMMIT_ACK         ,"out_SPR_COMMIT_ACK         ",Tcontrol_t    ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_SPR_COMMIT_SR_F_VAL    ," in_SPR_COMMIT_SR_F_VAL    ",Tcontrol_t    ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_SPR_COMMIT_SR_F        ," in_SPR_COMMIT_SR_F        ",Tcontrol_t    ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_SPR_COMMIT_SR_CY_VAL   ," in_SPR_COMMIT_SR_CY_VAL   ",Tcontrol_t    ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_SPR_COMMIT_SR_CY       ," in_SPR_COMMIT_SR_CY       ",Tcontrol_t    ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_SPR_COMMIT_SR_OV_VAL   ," in_SPR_COMMIT_SR_OV_VAL   ",Tcontrol_t    ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_SPR_COMMIT_SR_OV       ," in_SPR_COMMIT_SR_OV       ",Tcontrol_t    ,_param->_nb_front_end,_param->_nb_context[it1]);

  ALLOC2_SC_SIGNAL( in_SPR_EVENT_VAL          ," in_SPR_EVENT_VAL          ",Tcontrol_t    ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL(out_SPR_EVENT_ACK          ,"out_SPR_EVENT_ACK          ",Tcontrol_t    ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_SPR_EVENT_EPCR         ," in_SPR_EVENT_EPCR         ",Tspr_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_SPR_EVENT_EEAR_WEN     ," in_SPR_EVENT_EEAR_WEN     ",Tcontrol_t    ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_SPR_EVENT_EEAR         ," in_SPR_EVENT_EEAR         ",Tspr_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_SPR_EVENT_SR_DSX       ," in_SPR_EVENT_SR_DSX       ",Tcontrol_t    ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_SPR_EVENT_SR_TO_ESR    ," in_SPR_EVENT_SR_TO_ESR    ",Tcontrol_t    ,_param->_nb_front_end,_param->_nb_context[it1]);

  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Special_Register_unit.\n"),name.c_str());

  (*(_Special_Register_unit->in_CLOCK))        (*(in_CLOCK));
  (*(_Special_Register_unit->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Special_Register_unit, in_SPR_ACCESS_VAL          ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Special_Register_unit,out_SPR_ACCESS_ACK          ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Special_Register_unit, in_SPR_ACCESS_WEN          ,_param->_nb_inst_reexecute);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Special_Register_unit, in_SPR_ACCESS_FRONT_END_ID ,_param->_nb_inst_reexecute);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Special_Register_unit, in_SPR_ACCESS_CONTEXT_ID   ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Special_Register_unit, in_SPR_ACCESS_NUM_GROUP    ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Special_Register_unit, in_SPR_ACCESS_NUM_REG      ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Special_Register_unit, in_SPR_ACCESS_WDATA        ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Special_Register_unit,out_SPR_ACCESS_RDATA        ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Special_Register_unit,out_SPR_ACCESS_INVALID      ,_param->_nb_inst_reexecute);

  INSTANCE2_SC_SIGNAL(_Special_Register_unit,out_SPR_READ_SR             ,_param->_nb_front_end, _param->_nb_context[it1]);

  INSTANCE2_SC_SIGNAL(_Special_Register_unit, in_SPR_COMMIT_VAL          ,_param->_nb_front_end, _param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Special_Register_unit,out_SPR_COMMIT_ACK          ,_param->_nb_front_end, _param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Special_Register_unit, in_SPR_COMMIT_SR_F_VAL     ,_param->_nb_front_end, _param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Special_Register_unit, in_SPR_COMMIT_SR_F         ,_param->_nb_front_end, _param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Special_Register_unit, in_SPR_COMMIT_SR_CY_VAL    ,_param->_nb_front_end, _param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Special_Register_unit, in_SPR_COMMIT_SR_CY        ,_param->_nb_front_end, _param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Special_Register_unit, in_SPR_COMMIT_SR_OV_VAL    ,_param->_nb_front_end, _param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Special_Register_unit, in_SPR_COMMIT_SR_OV        ,_param->_nb_front_end, _param->_nb_context[it1]);

  INSTANCE2_SC_SIGNAL(_Special_Register_unit, in_SPR_EVENT_VAL           ,_param->_nb_front_end, _param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Special_Register_unit,out_SPR_EVENT_ACK           ,_param->_nb_front_end, _param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Special_Register_unit, in_SPR_EVENT_EPCR          ,_param->_nb_front_end, _param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Special_Register_unit, in_SPR_EVENT_EEAR_WEN      ,_param->_nb_front_end, _param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Special_Register_unit, in_SPR_EVENT_EEAR          ,_param->_nb_front_end, _param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Special_Register_unit, in_SPR_EVENT_SR_DSX        ,_param->_nb_front_end, _param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Special_Register_unit, in_SPR_EVENT_SR_TO_ESR     ,_param->_nb_front_end, _param->_nb_context[it1]);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();
  
  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  const  int32_t percent_transaction_spr_access = 75;
  const  int32_t percent_transaction_spr_commit = 75;
  const  int32_t percent_transaction_spr_event  = 75;

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  Tspr_t sr   [_param->_nb_front_end][_param->_max_nb_context];
  Tspr_t dccr [_param->_nb_front_end][_param->_max_nb_context];

  for (uint32_t i=0; i<_param->_nb_front_end; i++)
    for (uint32_t j=0; j<_param->_nb_context[i]; j++)
      {
	sr    [i][j] = 0x00008001;
	dccr  [i][j] = 0x0;
	TEST(Tspr_t, out_SPR_READ_SR [i][j]->read(), sr [i][j]);
      }

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      Tcontext_t front_end = rand()%_param->_nb_front_end;
      Tcontext_t context   = rand()%_param->_nb_context[front_end];
      uint32_t   port      = rand()%_param->_nb_inst_reexecute;
      uint32_t   config    = rand()%3;
      Tcontrol_t wen       = rand()%2;
      Tspr_t     wdata     = rand();
      {
	in_SPR_ACCESS_VAL          [port]->write((rand()%100)<percent_transaction_spr_access);
	in_SPR_ACCESS_FRONT_END_ID [port]->write(front_end);
	in_SPR_ACCESS_CONTEXT_ID   [port]->write(context);

	switch (config)
	  {
	  case 0 :
	    wen = 0;
	    in_SPR_ACCESS_NUM_GROUP    [port]->write(0);
	    in_SPR_ACCESS_NUM_REG      [port]->write(17);
	    break;
	  case 1 :
	    in_SPR_ACCESS_NUM_GROUP    [port]->write(3);
	    in_SPR_ACCESS_NUM_REG      [port]->write(0);
	    break;
	  case 2 :
	    in_SPR_ACCESS_NUM_GROUP    [port]->write(5);
	    in_SPR_ACCESS_NUM_REG      [port]->write(1);
	    break;
	  }
	
	in_SPR_ACCESS_WEN          [port]->write(wen);
	in_SPR_ACCESS_WDATA        [port]->write(wdata);
      }

      {
	in_SPR_COMMIT_VAL       [front_end][context]->write((rand()%100)<percent_transaction_spr_commit);
	in_SPR_COMMIT_SR_F_VAL  [front_end][context]->write((rand()%100)<percent_transaction_spr_commit);
	in_SPR_COMMIT_SR_CY_VAL [front_end][context]->write((rand()%100)<percent_transaction_spr_commit);
	in_SPR_COMMIT_SR_OV_VAL [front_end][context]->write((rand()%100)<percent_transaction_spr_commit);
	in_SPR_COMMIT_SR_F      [front_end][context]->write(rand()%2);
	in_SPR_COMMIT_SR_CY     [front_end][context]->write(rand()%2);
	in_SPR_COMMIT_SR_OV     [front_end][context]->write(rand()%2);
      }

      {
        in_SPR_EVENT_VAL        [front_end][context]->write((rand()%100)<percent_transaction_spr_event);
        in_SPR_EVENT_EPCR       [front_end][context]->write(rand());
        in_SPR_EVENT_EEAR_WEN   [front_end][context]->write(rand()%2);
        in_SPR_EVENT_EEAR       [front_end][context]->write(rand());
        in_SPR_EVENT_SR_DSX     [front_end][context]->write(rand()%2);
        in_SPR_EVENT_SR_TO_ESR  [front_end][context]->write(rand()%2);
      }

      SC_START(0);

      if (in_SPR_ACCESS_VAL [port]->read() and out_SPR_ACCESS_ACK [port]->read())
	{
	  LABEL("SPR_ACCESS [%d] - Transaction accepted.",port);
	  LABEL(" * front_end : %d"  ,(unsigned int)front_end);
	  LABEL(" * context   : %d"  ,(unsigned int)context  );
	  LABEL(" * config    : %d"  ,(unsigned int)config   );
	  LABEL(" * wen       : %d"  ,(unsigned int)wen      );
	  LABEL(" * wdata     : %d"  ,(unsigned int)wdata&0xff );
	  
	switch (config)
	  {
	  case 0 :
	    TEST(Tspr_t    ,out_SPR_ACCESS_RDATA   [port]->read(),sr[front_end][context]);
	    TEST(Tcontrol_t,out_SPR_ACCESS_INVALID [port]->read(),0);
	    break;
	  case 1 :
	    if (sr[front_end][context] & 1)
	      {
		TEST(Tspr_t    ,out_SPR_ACCESS_RDATA   [port]->read(),dccr[front_end][context]&0xff);
		TEST(Tcontrol_t,out_SPR_ACCESS_INVALID [port]->read(),0);

		if (wen)
		  dccr[front_end][context] = wdata;
	      }
	    else
	      TEST(Tcontrol_t,out_SPR_ACCESS_INVALID [port]->read(),1);
	    break;
	  case 2 :
	    TEST(Tcontrol_t,out_SPR_ACCESS_INVALID [port]->read(),1);
	    break;
	  }
	}

      if (in_SPR_COMMIT_VAL [front_end][context]->read() and out_SPR_COMMIT_ACK [front_end][context]->read())
	{
	  LABEL("SPR_COMMIT [%d][%d] - Transaction accepted.",front_end,context);
	  LABEL(" * cy_val   : %d",in_SPR_COMMIT_SR_CY_VAL [front_end][context]->read());
	  LABEL(" * cy       : %d",in_SPR_COMMIT_SR_CY     [front_end][context]->read());
	  LABEL(" * ov_val   : %d",in_SPR_COMMIT_SR_OV_VAL [front_end][context]->read());
	  LABEL(" * ov       : %d",in_SPR_COMMIT_SR_OV     [front_end][context]->read());
	  LABEL(" * f_val    : %d",in_SPR_COMMIT_SR_F_VAL  [front_end][context]->read());
	  LABEL(" * f        : %d",in_SPR_COMMIT_SR_F      [front_end][context]->read());
	  LABEL(" * sr (old) : 0x%d",sr[front_end][context]);
	  if (in_SPR_COMMIT_SR_CY_VAL [front_end][context]->read())
	    CHANGE_FLAG(sr[front_end][context], 10, in_SPR_COMMIT_SR_CY [front_end][context]->read());

	  if (in_SPR_COMMIT_SR_OV_VAL [front_end][context]->read())
	    CHANGE_FLAG(sr[front_end][context], 11, in_SPR_COMMIT_SR_OV [front_end][context]->read());

	  if (in_SPR_COMMIT_SR_F_VAL [front_end][context]->read())
	    CHANGE_FLAG(sr[front_end][context], 9, in_SPR_COMMIT_SR_F [front_end][context]->read());
	  LABEL(" * sr (new) : 0x%d",sr[front_end][context]);
	}

      if (in_SPR_EVENT_VAL [front_end][context]->read() and out_SPR_EVENT_ACK [front_end][context]->read())
	{
	  LABEL("SPR_EVENT  [%d][%d] - Transaction accepted.",front_end,context);

          CHANGE_FLAG(sr[front_end][context], 13, in_SPR_EVENT_SR_DSX [front_end][context]->read());
        }

      SC_START(1);

      for (uint32_t i=0; i<_param->_nb_front_end; i++)
	for (uint32_t j=0; j<_param->_nb_context[i]; j++)
	  TEST(Tspr_t, out_SPR_READ_SR [i][j]->read(), sr [i][j]);

      in_SPR_ACCESS_VAL [port]->write(0);
      in_SPR_COMMIT_VAL  [front_end][context]->write(0);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE1_SC_SIGNAL( in_SPR_ACCESS_VAL          ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_SPR_ACCESS_ACK          ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_SPR_ACCESS_WEN          ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_SPR_ACCESS_CONTEXT_ID   ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_SPR_ACCESS_FRONT_END_ID ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_SPR_ACCESS_NUM_GROUP    ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_SPR_ACCESS_NUM_REG      ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_SPR_ACCESS_WDATA        ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_SPR_ACCESS_RDATA        ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_SPR_ACCESS_INVALID      ,_param->_nb_inst_reexecute);
  
  DELETE2_SC_SIGNAL(out_SPR_READ_SR             ,_param->_nb_front_end, _param->_nb_context[it1]);
  
  DELETE2_SC_SIGNAL( in_SPR_COMMIT_VAL          ,_param->_nb_front_end, _param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_SPR_COMMIT_ACK          ,_param->_nb_front_end, _param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_SPR_COMMIT_SR_F_VAL     ,_param->_nb_front_end, _param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_SPR_COMMIT_SR_F         ,_param->_nb_front_end, _param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_SPR_COMMIT_SR_CY_VAL    ,_param->_nb_front_end, _param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_SPR_COMMIT_SR_CY        ,_param->_nb_front_end, _param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_SPR_COMMIT_SR_OV_VAL    ,_param->_nb_front_end, _param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_SPR_COMMIT_SR_OV        ,_param->_nb_front_end, _param->_nb_context[it1]);

  DELETE2_SC_SIGNAL( in_SPR_EVENT_VAL           ,_param->_nb_front_end, _param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_SPR_EVENT_ACK           ,_param->_nb_front_end, _param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_SPR_EVENT_EPCR          ,_param->_nb_front_end, _param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_SPR_EVENT_EEAR_WEN      ,_param->_nb_front_end, _param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_SPR_EVENT_EEAR          ,_param->_nb_front_end, _param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_SPR_EVENT_SR_DSX        ,_param->_nb_front_end, _param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_SPR_EVENT_SR_TO_ESR     ,_param->_nb_front_end, _param->_nb_context[it1]);
    }
#endif

  delete _Special_Register_unit;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
