/*
 * $Id: test.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Generic/Comparator/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/BitManipulation.h"

void test (string name,
	   morpheo::behavioural::generic::comparator::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

  if (setlocale (LC_ALL, "") == NULL)
    msg(_("setlocale ko.\n"));

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Comparator * _Comparator = new Comparator 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  sc_signal<Tdata_t   > *  in_COMPARE_DATA_0;
  sc_signal<Tdata_t   > *  in_COMPARE_DATA_1;
  sc_signal<Tcontrol_t> * out_COMPARE_TEST  ;

  ALLOC0_SC_SIGNAL( in_COMPARE_DATA_0," in_COMPARE_DATA_0",Tdata_t   );
  ALLOC0_SC_SIGNAL( in_COMPARE_DATA_1," in_COMPARE_DATA_1",Tdata_t   );
  ALLOC0_SC_SIGNAL(out_COMPARE_TEST  ,"out_COMPARE_TEST  ",Tcontrol_t);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Comparator.\n"),name.c_str());

  (*(_Comparator->in_CLOCK))        (*(in_CLOCK));
  (*(_Comparator->in_NRESET))       (*(in_NRESET));

  INSTANCE0_SC_SIGNAL(_Comparator, in_COMPARE_DATA_0);
  INSTANCE0_SC_SIGNAL(_Comparator, in_COMPARE_DATA_1);
  INSTANCE0_SC_SIGNAL(_Comparator,out_COMPARE_TEST  );
  
  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      uint64_t data0 = range<uint64_t>(rand(),_param->_size_data);
      uint64_t data1 = range<uint64_t>(rand(),_param->_size_data);

      in_COMPARE_DATA_0->write(static_cast<Tdata_t>(data0));
      in_COMPARE_DATA_1->write(static_cast<Tdata_t>(data1));
      
      SC_START(0);
      
      Tcontrol_t test = false;
      switch (_param->_size_data)
        {
        case 8 :
          {
            if (_param->_is_signed)
              switch (_param->_type)
                {
                case COMPARATOR_EQUAL            : test = static_cast< int8_t>(data0) == static_cast< int8_t>(data1); break;
                case COMPARATOR_NOT_EQUAL        : test = static_cast< int8_t>(data0) != static_cast< int8_t>(data1); break;
                case COMPARATOR_GREATER          : test = static_cast< int8_t>(data0) >  static_cast< int8_t>(data1); break;
                case COMPARATOR_GREATER_OR_EQUAL : test = static_cast< int8_t>(data0) >= static_cast< int8_t>(data1); break;
                case COMPARATOR_LESS             : test = static_cast< int8_t>(data0) <  static_cast< int8_t>(data1); break;
                case COMPARATOR_LESS_OR_EQUAL    : test = static_cast< int8_t>(data0) <= static_cast< int8_t>(data1); break;
                }
            else
              switch (_param->_type)
                {
                case COMPARATOR_EQUAL            : test = static_cast<uint8_t>(data0) == static_cast<uint8_t>(data1); break;
                case COMPARATOR_NOT_EQUAL        : test = static_cast<uint8_t>(data0) != static_cast<uint8_t>(data1); break;
                case COMPARATOR_GREATER          : test = static_cast<uint8_t>(data0) >  static_cast<uint8_t>(data1); break;
                case COMPARATOR_GREATER_OR_EQUAL : test = static_cast<uint8_t>(data0) >= static_cast<uint8_t>(data1); break;
                case COMPARATOR_LESS             : test = static_cast<uint8_t>(data0) <  static_cast<uint8_t>(data1); break;
                case COMPARATOR_LESS_OR_EQUAL    : test = static_cast<uint8_t>(data0) <= static_cast<uint8_t>(data1); break;
                }
            break;
          }
        case 16 :
          {
            if (_param->_is_signed)
              switch (_param->_type)
                {
                case COMPARATOR_EQUAL            : test = static_cast< int16_t>(data0) == static_cast< int16_t>(data1); break;
                case COMPARATOR_NOT_EQUAL        : test = static_cast< int16_t>(data0) != static_cast< int16_t>(data1); break;
                case COMPARATOR_GREATER          : test = static_cast< int16_t>(data0) >  static_cast< int16_t>(data1); break;
                case COMPARATOR_GREATER_OR_EQUAL : test = static_cast< int16_t>(data0) >= static_cast< int16_t>(data1); break;
                case COMPARATOR_LESS             : test = static_cast< int16_t>(data0) <  static_cast< int16_t>(data1); break;
                case COMPARATOR_LESS_OR_EQUAL    : test = static_cast< int16_t>(data0) <= static_cast< int16_t>(data1); break;
                }
            else
              switch (_param->_type)
                {
                case COMPARATOR_EQUAL            : test = static_cast<uint16_t>(data0) == static_cast<uint16_t>(data1); break;
                case COMPARATOR_NOT_EQUAL        : test = static_cast<uint16_t>(data0) != static_cast<uint16_t>(data1); break;
                case COMPARATOR_GREATER          : test = static_cast<uint16_t>(data0) >  static_cast<uint16_t>(data1); break;
                case COMPARATOR_GREATER_OR_EQUAL : test = static_cast<uint16_t>(data0) >= static_cast<uint16_t>(data1); break;
                case COMPARATOR_LESS             : test = static_cast<uint16_t>(data0) <  static_cast<uint16_t>(data1); break;
                case COMPARATOR_LESS_OR_EQUAL    : test = static_cast<uint16_t>(data0) <= static_cast<uint16_t>(data1); break;
                }
            break;
          }
        case 32 :
          {
            if (_param->_is_signed)
              switch (_param->_type)
                {
                case COMPARATOR_EQUAL            : test = static_cast< int32_t>(data0) == static_cast< int32_t>(data1); break;
                case COMPARATOR_NOT_EQUAL        : test = static_cast< int32_t>(data0) != static_cast< int32_t>(data1); break;
                case COMPARATOR_GREATER          : test = static_cast< int32_t>(data0) >  static_cast< int32_t>(data1); break;
                case COMPARATOR_GREATER_OR_EQUAL : test = static_cast< int32_t>(data0) >= static_cast< int32_t>(data1); break;
                case COMPARATOR_LESS             : test = static_cast< int32_t>(data0) <  static_cast< int32_t>(data1); break;
                case COMPARATOR_LESS_OR_EQUAL    : test = static_cast< int32_t>(data0) <= static_cast< int32_t>(data1); break;
                }
            else
              switch (_param->_type)
                {
                case COMPARATOR_EQUAL            : test = static_cast<uint32_t>(data0) == static_cast<uint32_t>(data1); break;
                case COMPARATOR_NOT_EQUAL        : test = static_cast<uint32_t>(data0) != static_cast<uint32_t>(data1); break;
                case COMPARATOR_GREATER          : test = static_cast<uint32_t>(data0) >  static_cast<uint32_t>(data1); break;
                case COMPARATOR_GREATER_OR_EQUAL : test = static_cast<uint32_t>(data0) >= static_cast<uint32_t>(data1); break;
                case COMPARATOR_LESS             : test = static_cast<uint32_t>(data0) <  static_cast<uint32_t>(data1); break;
                case COMPARATOR_LESS_OR_EQUAL    : test = static_cast<uint32_t>(data0) <= static_cast<uint32_t>(data1); break;
                }
            break;
          }
        case 64 :
          {
            if (_param->_is_signed)
              switch (_param->_type)
                {
                case COMPARATOR_EQUAL            : test = static_cast< int64_t>(data0) == static_cast< int64_t>(data1); break;
                case COMPARATOR_NOT_EQUAL        : test = static_cast< int64_t>(data0) != static_cast< int64_t>(data1); break;
                case COMPARATOR_GREATER          : test = static_cast< int64_t>(data0) >  static_cast< int64_t>(data1); break;
                case COMPARATOR_GREATER_OR_EQUAL : test = static_cast< int64_t>(data0) >= static_cast< int64_t>(data1); break;
                case COMPARATOR_LESS             : test = static_cast< int64_t>(data0) <  static_cast< int64_t>(data1); break;
                case COMPARATOR_LESS_OR_EQUAL    : test = static_cast< int64_t>(data0) <= static_cast< int64_t>(data1); break;
                }
            else
              switch (_param->_type)
                {
                case COMPARATOR_EQUAL            : test = static_cast<uint64_t>(data0) == static_cast<uint64_t>(data1); break;
                case COMPARATOR_NOT_EQUAL        : test = static_cast<uint64_t>(data0) != static_cast<uint64_t>(data1); break;
                case COMPARATOR_GREATER          : test = static_cast<uint64_t>(data0) >  static_cast<uint64_t>(data1); break;
                case COMPARATOR_GREATER_OR_EQUAL : test = static_cast<uint64_t>(data0) >= static_cast<uint64_t>(data1); break;
                case COMPARATOR_LESS             : test = static_cast<uint64_t>(data0) <  static_cast<uint64_t>(data1); break;
                case COMPARATOR_LESS_OR_EQUAL    : test = static_cast<uint64_t>(data0) <= static_cast<uint64_t>(data1); break;
                }
            break;
          }
        default :
          {
            TEST_KO("Invalid size for the test.");
          }
        }

      TEST(Tcontrol_t,out_COMPARE_TEST->read(),test);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;
  DELETE0_SC_SIGNAL( in_COMPARE_DATA_0);
  DELETE0_SC_SIGNAL( in_COMPARE_DATA_1);
  DELETE0_SC_SIGNAL(out_COMPARE_TEST  );
    }
#endif

  delete _Comparator;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
