#ifdef VHDL
/*
 * $Id: Comparator_vhdl_xilinx_body.cpp 116 2009-04-30 13:51:41Z moulu $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Comparator/include/Comparator.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace comparator {


#undef  FUNCTION
#define FUNCTION "Comparator::vhdl_xilinx_body"
  void Comparator::vhdl_xilinx_body (Vhdl * & vhdl)
  {
    log_begin(Comparator,FUNCTION);
    vhdl->set_body (0,"ins_c_compare_v9_0 : c_compare_v9_0");
    vhdl->set_body (1,"generic map (");
    vhdl->set_body (2,"c_width      => "+toString(_param->_size_data)+",");
    vhdl->set_body (2,"c_data_type  => "+toString(!_param->_is_signed)+",  -- 0 = signed, 1 = unsigned");
    std::string print_res_pin = "";
    switch (_param->_type)
      {
      case COMPARATOR_EQUAL :
        vhdl->set_body (2,"c_has_a_eq_b => 1)");
        print_res_pin = "a_eq_b";
        break;
      case COMPARATOR_NOT_EQUAL :
        vhdl->set_body (2,"c_has_a_eq_b => 0,");
        vhdl->set_body (2,"c_has_a_ne_b => 1)");
        print_res_pin = "a_ne_b";
        break;
      case COMPARATOR_GREATER :
        vhdl->set_body (2,"c_has_a_eq_b => 0,");
        vhdl->set_body (2,"c_has_a_gt_b => 1)");
        print_res_pin = "a_gt_b";
        break;
      case COMPARATOR_GREATER_OR_EQUAL :
        vhdl->set_body (2,"c_has_a_eq_b => 0,");
        vhdl->set_body (2,"c_has_a_ge_b => 1)");
        print_res_pin = "a_ge_b";
        break;
      case COMPARATOR_LESS :
        vhdl->set_body (2,"c_has_a_eq_b => 0,");
        vhdl->set_body (2,"c_has_a_lt_b => 1)");
        print_res_pin = "a_lt_b";
        break;
      case COMPARATOR_LESS_OR_EQUAL :
        vhdl->set_body (2,"c_has_a_eq_b => 0,");
        vhdl->set_body (2,"c_has_a_le_b => 1)");
        print_res_pin = "a_le_b";
        break;
      }
    
    vhdl->set_body (1,"port map (");
    vhdl->set_body (2,"a => in_COMPARE_DATA_0,");
    vhdl->set_body (2,"b => in_COMPARE_DATA_1,");
    vhdl->set_body (2,print_res_pin+" => out_COMPARE_TEST);");
    
    log_end(Comparator,FUNCTION);
  };

}; // end namespace comparator
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
