#ifndef morpheo_behavioural_Debug_signal_h
#define morpheo_behavioural_Debug_signal_h

/*
 * $Id: Debug_signal.h 137 2010-02-16 12:35:48Z rosiere $
 *
 * [ Description ]
 * 
 */

# ifdef DEBUG_SIGNAL

#include <map>
#include <list>
#include <string>

namespace morpheo {
namespace behavioural {

  class debug_signal
  {
  private : std::map <void *,std::string> _signal;
  private : std::list<std::string>        _signal_access;

  public  : void add       (void *      signal,
                            std::string name);
  public  : void write     (void *      signal);
  public  : void end_cycle (void);
  public  : void print     (void);
  };
  
  extern debug_signal _debug_signal;
  
#  define DEBUG_SIGNAL_ADD(signal,name)                                 \
  do                                                                    \
    {                                                                   \
      morpheo::behavioural::_debug_signal.add(signal,name);             \
    } while(0)

  // Test if signal is previously define  
  
#  define DEBUG_SIGNAL_WRITE(signal)                                    \
  do                                                                    \
    {                                                                   \
      morpheo::behavioural::_debug_signal.write(signal);                \
    } while(0)

#  define DEBUG_SIGNAL_END_CYCLE()                      \
  do                                                    \
    {                                                   \
      morpheo::behavioural::_debug_signal.end_cycle();  \
    } while (0)

#  define DEBUG_SIGNAL_PRINT()                          \
  do                                                    \
    {                                                   \
      morpheo::behavioural::_debug_signal.print();      \
    } while (0)
  
}; // end namespace behavioural          
}; // end namespace morpheo              
# else
#  define DEBUG_SIGNAL_ADD(signal,name) do {} while (0)
#  define DEBUG_SIGNAL_WRITE(signal)    do {} while (0)
#  define DEBUG_SIGNAL_END_CYCLE()      do {} while (0)
#  define DEBUG_SIGNAL_PRINT()          do {} while (0)
# endif


#endif
