/*
 * $Id: Parameters_msg_error.cpp 138 2010-05-12 17:34:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Core_Glue/include/Parameters.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Issue_queue/include/Types.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace core_glue {


#undef  FUNCTION
#define FUNCTION "Core_Glue::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_begin(Core_Glue,FUNCTION);

    Parameters_test test ("Core_Glue");

    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_ooo_engine_nb_front_end[i]; ++j)
        if (_translate_ooo_engine_num_front_end [i][j] > _nb_front_end)
          test.error(_("Translation in ooo_engine of front_end id is an invalid id.\n"));

    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_ooo_engine_nb_execute_loop[i]; ++j)
        if (_translate_ooo_engine_num_execute_loop [i][j] > _nb_execute_loop)
          test.error(_("Translation in ooo_engine of execute_loop id is an invalid id.\n"));

    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_execute_loop_nb_ooo_engine[i]; ++j)
        if (_translate_execute_loop_num_ooo_engine [i][j] > _nb_ooo_engine)
          test.error(_("Translation in execute_loop of ooo_engine id is an invalid id.\n"));

    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_ooo_engine_nb_front_end[i]; ++j)
        {
          uint32_t num_front_end = _translate_ooo_engine_num_front_end [i][j];

          if (_front_end_nb_inst_branch_complete [num_front_end] != _ooo_engine_nb_inst_branch_complete [i])
            test.error(toString(_("front_end[%d].nb_inst_branch_complete must be equal at ooo_engine[%d].nb_inst_branch_complete.\n"),num_front_end,i));
        }

    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_execute_loop_nb_ooo_engine[i]; ++j)
        {
          Tcontext_t num_ooo_engine = _translate_execute_loop_num_ooo_engine [i][j];
          for (uint32_t k=0; k<_ooo_engine_nb_execute_loop[num_ooo_engine]; ++k)
            if (_translate_ooo_engine_num_execute_loop [num_ooo_engine][k] == i)
              if (_nb_inst_execute[num_ooo_engine][k] != _nb_write_unit [i])
            test.error(toString(_("ooo_engine[%d][%d].nb_inst_execute must be equal at execute_loop[%d].nb_write_unit.\n"),num_ooo_engine,k,i));
        }

    {
      bool issue_queue_can_ooo [_nb_ooo_engine];
      for (uint32_t i=0; i<_nb_ooo_engine; ++i)
        issue_queue_can_ooo [i] = true;

      for (uint32_t i=0; i<_nb_execute_loop; ++i)
        for (uint32_t j=0; j<_execute_loop_nb_ooo_engine[i]; ++j)
          {
            Tcontext_t num_ooo_engine = _translate_execute_loop_num_ooo_engine [i][j];
            
            // Test if multiple ooo_engine for this execute loop
            if (_execute_loop_nb_ooo_engine[i]>1)
              issue_queue_can_ooo [num_ooo_engine] = false;
          }

      for (uint32_t i=0; i<_nb_ooo_engine; ++i)
        if (not _issue_queue_in_order [i] and // out of order
            not issue_queue_can_ooo [i])
          test.error(toString(_("The scheme of Issue queue in ooo_engine [%d] must be \"%s\" because, the execute loop can be access with multiple ooo_engine (deadlock is possible).\n"),i,toString(core::multi_ooo_engine::ooo_engine::issue_queue::ISSUE_QUEUE_SCHEME_IN_ORDER).c_str()));
    }

    if (_dispatch_load_balancing != LOAD_BALANCING_MAXIMUM_FOR_PRIORITY)
      test.error(toString(_("distpatch load_balancing scheme \"%s\" is not yet supported.\n"),toString(_dispatch_load_balancing).c_str()));

    log_end(Core_Glue,FUNCTION);

    return test;
  };

}; // end namespace core_glue
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
