/*
 * $Id: Parameters.cpp 138 2010-05-12 17:34:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace load_store_unit {


#undef  FUNCTION
#define FUNCTION "Load_store_unit::Parameters"
  Parameters::Parameters (uint32_t            size_store_queue                   ,
			  uint32_t            size_load_queue                    ,
			  uint32_t            size_speculative_access_queue      ,
                          uint32_t            nb_store_queue_bank                ,
                          uint32_t            nb_load_queue_bank                 ,
                          uint32_t            nb_port_check                      ,
                          Tspeculative_load_t speculative_load                   ,
                          Tpredictor_t        speculative_commit_predictor_scheme,
                          uint32_t          * lsu_pht_size_counter               ,//[1]
                          uint32_t          * lsu_pht_nb_counter                 ,//[1]
			  uint32_t            nb_bypass_memory                   ,
			  uint32_t            nb_cache_port                      ,
			  uint32_t            nb_inst_memory                     ,
			  uint32_t            nb_context                         ,
			  uint32_t            nb_front_end                       ,
			  uint32_t            nb_ooo_engine                      ,
			  uint32_t            nb_packet                          ,
			  uint32_t            size_general_data                  ,
			  uint32_t            size_special_data                  ,
			  uint32_t            nb_general_register                ,
			  uint32_t            nb_special_register                ,
                          uint32_t            nb_thread                          ,
                          bool              * num_thread_valid                   , //[nb_thread]
                          bool                is_toplevel)
  {
    log_printf(FUNC,Load_store_unit,FUNCTION,"Begin");

    _size_store_queue                      = size_store_queue                   ;
    _size_load_queue                       = size_load_queue                    ;
    _size_speculative_access_queue         = size_speculative_access_queue      ;
    _nb_store_queue_bank                   = nb_store_queue_bank                ;
    _nb_load_queue_bank                    = nb_load_queue_bank                 ;
    _nb_port_check                         = nb_port_check                      ;
    _speculative_load                      = speculative_load                   ;
    _speculative_commit_predictor_scheme   = speculative_commit_predictor_scheme;
    _lsu_pht_size_counter                  = lsu_pht_size_counter               ;
    _lsu_pht_nb_counter                    = lsu_pht_nb_counter                 ;
    _nb_bypass_memory                      = nb_bypass_memory                   ;
    _nb_cache_port                         = nb_cache_port                      ;
    _nb_inst_memory                        = nb_inst_memory                     ;
    _nb_context                            = nb_context                         ;
    _nb_front_end                          = nb_front_end                       ;
    _nb_ooo_engine                         = nb_ooo_engine                      ;
    _nb_packet                             = nb_packet                          ;
    _nb_general_register                   = nb_general_register                ;
    _nb_special_register                   = nb_special_register                ;
    _nb_thread                             = nb_thread                          ;
    _num_thread_valid                      = num_thread_valid                   ;
    
    _size_speculative_access_queue_ptr     = log2(size_speculative_access_queue);

    _size_dcache_context_id                = log2(nb_context) + log2(nb_front_end) + log2(nb_ooo_engine);
    _size_dcache_packet_id                 = log2((size_store_queue>size_load_queue)?size_store_queue:size_load_queue)+1;
    _have_port_dcache_context_id           = _size_dcache_context_id>0;

    _mask_address_lsb                      = gen_mask<Tdcache_address_t>(log2(size_general_data/8));
    _mask_address_msb                      = gen_mask<Tdcache_address_t>(size_general_data) << log2(size_general_data/8);
    _mask_check_hit_byte                   = 0;

    for (uint32_t i=0; i<(size_general_data>>3) /*8*/; ++i)
      _mask_check_hit_byte |= (1<<i);

    test();

    if (is_toplevel)
      {
        _size_instruction_address              = size_general_data-2;
        _size_context_id                       = log2(nb_context         );
        _size_front_end_id                     = log2(nb_front_end       );
        _size_ooo_engine_id                    = log2(nb_ooo_engine      );
        _size_rob_ptr                          = log2(nb_packet          );
        _size_general_register                 = log2(nb_general_register);
        _size_special_register                 = log2(nb_special_register);
        _size_store_queue_ptr                  = log2(size_store_queue   );
        _size_load_queue_ptr                   = log2(size_load_queue    );
        _size_general_data                     = size_general_data      ;
        _size_special_data                     = size_special_data      ;

        _have_port_context_id                  = _size_context_id    >0;
        _have_port_front_end_id                = _size_front_end_id  >0;
        _have_port_ooo_engine_id               = _size_ooo_engine_id >0;
        _have_port_rob_ptr                     = _size_rob_ptr       >0;
        _have_port_load_queue_ptr              = _size_load_queue_ptr>0;

        copy();
      }

    log_printf(FUNC,Load_store_unit,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Load_store_unit::~Parameters"
  Parameters::~Parameters (void) 
  {
    log_printf(FUNC,Load_store_unit,FUNCTION,"Begin");

    log_printf(FUNC,Load_store_unit,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Load_store_unit::copy"
  void Parameters::copy (void) 
  {
    log_printf(FUNC,Load_store_unit,FUNCTION,"Begin");
    log_printf(FUNC,Load_store_unit,FUNCTION,"End");
  };

}; // end namespace load_store_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
